#*      MWC32LIB.MAK
#*
#* Make script for MIDAS Sound System Windows NT library
#*
#* $Id: midasnt.mak,v 1.4 1996/05/24 21:25:42 pekangas Exp $
#*
#* Copyright 1996 Petteri Kangaslampi and Jarno Paananen
#*
#* This file is part of the MIDAS Sound System, and may only be
#* used, modified and distributed under the terms of the MIDAS
#* Sound System license, LICENSE.TXT. By continuing to use,
#* modify or distribute this file you indicate that you have
#* read the license and understand and accept it fully.
#*


# Compilers and options:

CC = wcc386
CCOPTS = -w3 -d2 -bt=nt -mf -d__WC32__ -dDEBUG -dNOTIMER
ASM = tasm
ASMOPTS = -UT310 -p -m9 -zi -d__WC32__ -dDEBUG

LIBNAME = midasnt.lib
LIBCMDS = midasnt.

TOUCH = wtouch
LIBCMD = wlib -c -n $(LIBNAME) @$(LIBCMDS)


# These definitions ensure that the includes work OK:
O = obj

# Macros for MIDAS includes:
!include mincs.mak

$(LIBNAME) : midas.obj dsm.obj dsmmix.obj mmem.obj errors.obj \
        mutils.obj winwave.obj postproc.obj mglobals.obj \
        gmplayer.obj gmpcmds.obj file.obj rawfile.obj loadmod.obj \
        loadxm.obj loads3m.obj vu.obj $(EMSOBJ) $(DPMIOBJ)
        $(LIBCMD)


# Default rules:
.c.obj :
        $(CC) $[* $(CCOPTS)

.asm.obj :
        $(ASM) $[* $(ASMOPTS)


# Dependencies for MIDAS files:
!include mcdeps.mak
!include madeps.mak


#* $Log: midasnt.mak,v $
#* Revision 1.4  1996/05/24 21:25:42  pekangas
#* Separated assembler and C dependency information files
#*
#* Revision 1.3  1996/05/24 18:59:37  pekangas
#* Changed to use mdeps.mak and mincs.mak
#*
#* Revision 1.2  1996/05/23 20:51:27  pekangas
#* Added debug information to assembler modules also
#*
#* Revision 1.1  1996/05/22 20:49:33  pekangas
#* Initial revision
#*