procedure writedsp(b : byte); assembler;
asm
  mov  dx,sc_base
  add  dx,0ch
  mov  cx,60000
@readyloop:
  dec  cx
  cmp  cx,0
  je   @end
  in   al,dx
  test al,80h
  jnz  @readyloop
@end:
  mov  al,b
  out  dx,al
end;

procedure resetdsp;
var
l : longint;
begin
  l := meml[$40:$6c];
  inc(l,1);
  port[sc_base+6]:=1;
  repeat until meml[$40:$6c] = l;
  inc(l,1);
  port[sc_base+6]:=0;
  repeat until meml[$40:$6c] = l;
end;

procedure speaker_on;
begin
  writedsp($d1);
end;

procedure speaker_off;
begin
  writedsp($d3);
end;

procedure dmacontinue;
begin
  writedsp($d4);
end;

procedure dmastop;
begin
  writedsp($d0);
end;

procedure sb_irq;
const
b : byte = 0;
begin
  b := port[sc_base+$e];
  writedsp($14);
  writedsp(lo(sc_bufsize-1));
  writedsp(hi(sc_bufsize-1));
end;

procedure sb20_irq;
const
b : byte = 0;
begin
  b := port[sc_base+$e];
  writedsp($48);
  writedsp(lo(sc_bufsize-1));
  writedsp(hi(sc_bufsize-1));
  writedsp($91);
end;

procedure sb16_irq;
const
b : byte = 0;
begin
  b := port[sc_base+$f];
  writedsp($b0);
  writedsp(0);
  writedsp(lo(sc_bufsize-1));
  writedsp(hi(sc_bufsize-1));
end;

const
dmapage : array[0..7] of integer = ($87,$83,$81,$82,$8f,$8b,$89,$8a);
dmaaddr : array[0..7] of integer = (0,2,4,6,$c0,$c4,$c8,$cc);

procedure irqdma;
const
i : integer = 0;
begin
  if sc_dma < 4 then begin
    port[$0A]:= sc_dma or 4;
    port[$0C]:= 0;
    i := dmaaddr[sc_dma];
    port[i]:= lo(bufofs+sc_bufofs);
    port[i]:= hi(bufofs+sc_bufofs);
    port[dmapage[sc_dma]]:= bufseg;
    port[$0A]:= sc_dma;
  end
  else begin
    port[$d4]:= sc_dma or 4;
    port[$d8]:= 0;
    i := dmaaddr[sc_dma];
    port[i]:= lo((bufofs+sc_bufofs));
    port[i]:= hi((bufofs+sc_bufofs));
    port[dmapage[sc_dma]]:= bufseg;
    port[$d4]:= sc_dma and 3;
  end;
end;

procedure startdma;
const
i : integer = 0;
begin
  if sc_dma < 4 then begin
    port[$0A]:= sc_dma or 4;
    port[$0C]:= 0;
    port[$0B]:= $48+sc_dma;
    i := dmaaddr[sc_dma];
    port[i]:= lo(bufofs+sc_bufofs);
    port[i]:= hi(bufofs+sc_bufofs);
    port[dmapage[sc_dma]]:= bufseg;
    port[i+1]:= lo(sc_bufsize-1);
    port[i+1]:= hi(sc_bufsize-1);
    port[$0A]:= sc_dma;
  end
  else begin
    port[$d4]:= sc_dma or 4;
    port[$d8]:= 0;
    port[$d6]:= $48+(sc_dma and 3);
    i := dmaaddr[sc_dma];
    port[i]:= lo((bufofs+sc_bufofs));
    port[i]:= hi((bufofs+sc_bufofs));
    port[dmapage[sc_dma]]:= bufseg;
    port[i+2]:= lo(2*sc_bufsize-1);
    port[i+2]:= hi(2*sc_bufsize-1);
    port[$d4]:= sc_dma and 3;
  end;
end;

procedure stopdma;
begin
  if sc_dma < 4 then port[$0A]:=sc_dma or 4
  else port[$d4] := sc_dma or 4;
  port[$0C]:=0;
  if sc_dma < 4 then port[$0A]:=0
  else port[$d4] := 0;
end;

procedure sbstart;
begin
  writedsp($40);
  writedsp(256-1000000 div sc_rate);
  writedsp($14);
  writedsp(lo(sc_bufsize-1));
  writedsp(hi(sc_bufsize-1));
end;

procedure sb20start;
begin
  writedsp($40);
  writedsp(256-1000000 div sc_rate);
  writedsp($48);
  writedsp(lo(sc_bufsize-1));
  writedsp(hi(sc_bufsize-1));
  writedsp($91);
end;

procedure sb16start;
begin
  writedsp($40);
  writedsp(256-1000000 div (sc_rate));
  writedsp($b0);
  writedsp(0);
  writedsp(lo(sc_bufsize-1));
  writedsp(hi(sc_bufsize-1));
end;

procedure sbstop;
begin
  speaker_off;
  dmastop;
  resetdsp;
end;

procedure sb20stop;
begin
  speaker_off;
  dmastop;
  writedsp($da);
  dmastop;
  resetdsp;
end;

procedure sb16stop;
begin
  speaker_off;
  writedsp($d5);
  writedsp($d9);
  writedsp($d5);
  resetdsp;
end;

{stuffia:
autoinit:
writedsp($48);
writedsp(lo(size));
writedsp(hi(size));
writedsp($1c);}
