uses modunit,dos,crt,memunit;
function hex(w : word) : string;
const
hextbl : array[0..15] of char =
  ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
begin
  hex := hextbl[w shr 8 and $f]+hextbl[w shr 4 and $f]+hextbl[w and 15];
end;

var
n : integer;
begin
  clrscr;
  if paramcount < 1 then halt(1);

  init_sc(find_sc(sc_auto));
  writeln('Sound device: ',sc_id);
  writeln('Port ',hex(sc_base),' IRQ ',sc_irq,' DMA ',sc_dma);

  init_mod;  {Initialises mod routines and sets up interrupt}
  initxms;
  load_mod(paramstr(1));  {Loads mod/s3m}
  if mod_error <> 0 then begin
    writeln('Load error!');
    halt(1);
  end;
  start_playing;  {Starts playing}

  writeln('Playing ',paramstr(1));
  repeat
    write(#13,'POS:',cur_ptn:2,' ROW:',cur_row:2);
  until keypressed;
  readkey;
  writeln;

  stop_playing; {Stops playing}
  free_mod;     {Frees memory taken by mod}
  donexms;
  done_mod;     {Restores interrupt and deinit's GUS. You MUST call this at
                 the end of your program!}
end.
