;*****************************************************************************
; Filename: MEMSET.ASM
;   Author: Peter Andersson
;  Version: 0.2
;  Created: 1995.03.11
;  Updated: -
;*****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;*****************************************************************************
; Function: VOID @memset(PVOID buf,BYTE char,ULONG length);
;  Comment: Sets a block of memory to a byte value.
;    Input: Eax - memory buffer to clear
;           Dl - character value to fill the buffer with
;           Ecx - buffer length
;  Returns: pointer to buf
;*****************************************************************************

        Include STDDEF.INC

        Codeseg                 ; Change memory model in the STDDEF.INC

Proc    memset  ,3
                Push    Eax
                Mov     Dh,Dl
                Push    dx
                Shl     edx,16
                Pop     dx
Loop32:
                Sub     Ecx,32
                Jb @done32
                Mov     [Eax],Edx
                Mov     [Eax+4],Edx
                Mov     [Eax+8],Edx
                Mov     [Eax+12],Edx
                Mov     [Eax+16],Edx
                Mov     [Eax+20],Edx
                Mov     [Eax+24],Edx
                Mov     [Eax+28],Edx
                Add     Eax,32
                jmp     Loop32
@done32:        Add     Ecx,32
REPT 7
                Sub     Ecx,4
                jb      Done4
                Mov     [Eax],Edx
                Add     Eax,4
ENDM

Done4:          Add     Ecx,4

REPT 3
                Sub     Ecx,1
                jb      Done1
                Mov     [Eax],Dl
                Inc     Eax
ENDM
Done1:
                Pop     Eax
                Ret
Endp

        End
