;****************************************************************************
; Filename: STRNCMP.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.29
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @strncmp(char * srcptr, char * destptr, ulong max_len);
;  Comment: compares upto max_len bytes of two strings.
;    Input: Eax = pointer of source string
;           Edx = pointer of destination string
;           Ecx = maximum number of bytes to compare
;  Returns: zero if equal, less than zero srcptr < destptr and above zero
;           if srcptr > destptr.
;****************************************************************************

        Include STDDEF.INC

        Codeseg

Proc      strncmp  ,3
                Push    Ebx
        Align   4
@@Loop01:
                Clear   Ebx
                Jecxz   @@Exit01
                Dec     Ecx
                Mov     Bh,[Eax]
                Mov     Bl,[Edx]
                TestZ   Bh,Bh
                Jz      @@Exit01
                Sub     Bh,Bl
                Inc     Edx
                Inc     Eax
                And     Bh,Bh
                Jz      @@Loop01
                Movsx   Eax,Bh
                Pop     Ebx
                Ret

        Align   4
@@Exit01:       Sub     Bh,Bl
                Movsx   Eax,Bh
                Pop     Ebx
                Ret
Endp

        End

