comment $
****************************************************************************
 Filename: C0.ASM
   Author: Adam Seychell and Peter Anderson
  Version: 0.0
  Created: ?
  Updated: 1995.03.12 - Peter Andersson, general update for DOS32 v3.0
           1995.07.08 - Added CTRL+BREAK/CTRL+C handler, Adam Seychell
           1995.11.20 - modified heap allocation to reserve base memory.
           1996.4.08 - removed CTRL+BREAK/CTRL+C handler, Adam Seychell

  Comment: Startup file.
****************************************************************************
 Copyright Adam Seychell, 1994-1995.
 All rights reserved.
****************************************************************************



                       Startup code settings

 Below are various numeric contants that control the memory sizes and
 startup configeration. They may be defined in TASM command line
 (with -D switch) to a specific value, otherwise they will be set to
 their default value.





;
                             STACK_SIZE

 Stack size constant STACK_SIZE determines the amount of stack space
 allocated for the application. Adjust this value according to application
 requirments however it must never be set below 256 bytes.

Default is 16Kb



                           MAX_HEAP_SIZE

 The memory heap size. This constant sets the amout of memory to
 initally allocate for the memory pool used by the malloc memory
 functions. If the availible free memory is less than this value then
 it will allocate as much as it can provided its above the contant
 MIN_HEAP_SIZE.  if you want to ignore memory allocation all together
 then set this constant to zero.

(Default is 4Gb)




                       MIN_HEAP_SIZE

 This constant sets the minimum memory required by the application.
 If the availible memory is less than this value then the program will
 immediatly abort with an 'out of memory' error message.

(Default is 4Kb)




                           BASE_MEMORY

 The constant below sets the maximum amount of base memory to reserve once
 the heap has been allocated. This is useful if you would like to run DOS
 programs within a DOS32 application, for example, a DOS shell.

(Default is 0 bytes)







                       NO_DMA

 Do you want DMA buffer support?
 if NO_DMA is defined then no DMA support is availible.
 otherwise a 16Kb DMA buffer is allocated with near and physical
 addresses contained in pointer varibles DMA_addr and DMA_phys
 respectivly.

(Default is to allocate a DMA buffer)

$


    Include STDDEF.INC



; Setup contants, if the constant is not defined then use default values.
;
Ifdef MIN_HEAP_SIZE
    _MIN_HEAP_SIZE_ = MIN_HEAP_SIZE
Else
	_MIN_HEAP_SIZE_ = 1024 * 4
Endif

Ifdef BASE_MEMORY
	_BASE_MEMORY_ = BASE_MEMORY
Else
    _BASE_MEMORY_ = 1024 * 0
Endif

Ifdef MAX_HEAP_SIZE
   _MAX_HEAP_SIZE_ = MAX_HEAP_SIZE
Else
	_MAX_HEAP_SIZE_ = 0FFFFFFFFh
Endif

Ifdef STACK_SIZE
  _STACK_SIZE_ = STACK_SIZE
Else
  _STACK_SIZE_ = 1024*16
Endif


    Stack   _STACK_SIZE_

    Codeseg

Public AbortStackPos
Public NoLanguage ExitSlow,NoLanguage ExitQuick, startup
Extrn __setupio :Near

extrn System_Setup :Near
extrn Debug :Near
PROC   startup NoLanguage


            Mov Ax,0EE02h       ; Fixup the standard variables
            Int 31h
            Neg Ebx
            Mov [_psp],Esi
            Mov [_environ],Edi
            Mov [_zero],Ebx
            Mov [exesize],Edx
            Mov [exename],Ecx


        Ifndef  NO_DMA
            Mov Eax,0EE41h      ; Allocate 16Kb DMA buffer
            Int 31h
            Jc  @@Exit01
            Mov [DMA_addr],Edx      ; Store near pointer
            Mov [DMA_phys],Ebx      ; Store physical address
        Endif

            Mov Ax,0EE00h
            Int 31h
            And Eax,0FFFFh
            Mov [dos32version],Eax  ; Save DOS32 version number
            Mov [dos32system],Dl    ; Save DOS32 system type
            Mov [_zero_sel],Ebx

     If _BASE_MEMORY_ GT 640*1024
       _BASE_MEMORY_ = 640*1024
     Endif
     If _MIN_HEAP_SIZE_ GT _MAX_HEAP_SIZE_
       _MIN_HEAP_SIZE_ = _MAX_HEAP_SIZE_
     Endif


     IfE  _MAX_HEAP_SIZE_ EQ 0

            Mov Edx,_MAX_HEAP_SIZE_
            test [dos32system],1000b
            jnz @@Allocate_it

        ;  Get memory size.
        ;
            Mov Ax,0EE42h           ; Allocate heap
            Mov Edx,-1
            Int 31h                 ; EAX = size, EDX = ptr
            Push Eax
            Mov Ax,0EE40h           ; Deallocate heap
            Int 31h
            Pop Edx
            Cmp Edx,_MAX_HEAP_SIZE_
            Jbe  @@J43
            Mov Edx,_MAX_HEAP_SIZE_
@@J43:
            Sub Edx,_MIN_HEAP_SIZE_
            Jb @@Exit01

            Sub Edx,_BASE_MEMORY_
            Jae @@J41
            Clear Edx
@@J41:
            Add Edx,_MIN_HEAP_SIZE_


@@Allocate_it:

            Mov Ax,0EE42h           ; Allocate heap
            Int 31h                 ; EAX = size, EDX = ptr
            cmp eax,_MIN_HEAP_SIZE_
            jb @@Exit01

            Xchg    Eax,Edx
            Call    @setmem
            TestZ   Eax
            Jz  @@Exit01
      EndIf

            call    __setupio      ; inialize file stream functions

    ;
    ; Fixup the environment pointer table and it's varibles
    ;
                Mov Eax,[_environ]  ; Get the environment pointer
                Mov Edi,Esp
    Align   4
@@Loop01:       Mov [Esp],Eax       ; Save EAX
                Call    @strlen
                TestZ   Eax
                Jz  @@Next01
                Add Eax,[Esp]
                Inc Eax
                Push    Eax
                Jmp @@Loop01
    Align   4
@@Next01:       Mov Ecx,[Edi]   ; Swap first and last to make the last
                Xchg    [Esp],Ecx   ; one a zero length string
                Mov [Edi],Ecx
                Mov [environ],Esp   ; Save environment pointer table pointer
                Sub Edi,Esp
                Shr Edi,2
                Mov [_envsize],Edi  ; Save environment size


 ;
 ; Fixup command line argument table on the stack
 ;
       ; If the CMDLINE environment varible is availbe then
       ; take the command tail from here. 4DOS command shell
       ; sets this environment varible each time a command is executed
       ;
       ; The CMDLINE environment varible is used on the following conditions;
       ;  It must be present
       ;  The PSP cmd tail is greater than 127 bytes
       ;  The PSP string = the first 127 bytes of CMDLINE string.
       ; Otherwise use the cmd line from offset 80h of the PSP.
       ;
                Mov     Eax,Offset CMDLINE_environ
                Call    @getenv
                TestZ	Eax
                Jz      @@skipEnvCmd
                Mov		Dl,' ' 				; Search for ' '
                call	@strchr
                TestZ	Eax
                Jz      @@skipEnvCmd
                Mov		Esi,Eax				; Save cmdline string ptr
                call	@strlen
                Mov     Ebx,Eax             ; Save CMDLINE length in EBX
                Mov 	Eax,[_psp]
                Add     Eax,80h
                Movzx 	Ecx,[BYTE Eax]      ; Get size of psp cmd string
                Cmp     Ecx,127
                Jl      @@skipEnvCmd        ; use psp cmd tail if < 127
                Inc     Eax
                Mov     Edx,Esi
                call    @strncmp
                TestZ   Eax
                jz      @@copycmdtail
@@skipEnvCmd:
                Clear   Ebx
                Mov 	Eax,[_psp]
                Mov 	Bl,[Eax+80h]
                Lea     Esi,[Eax+81h]     ; Esi -> first character in cmd tail

@@copycmdtail:  Mov     Ecx,Ebx
                Sub     Esp,Ebx           ; Allocate mem for cmd tail
                Sub		Esp,8
                And		Esp,NOT 3		  ; always keep ESP aligned
                Mov     Edi,Esp
                Cld
                Rep     Movsb             ; copy cmd tail to stack
                Mov     Ecx,Ebx           ; restore Ecx
                Lea     Edi,[Esp+Ecx-1]   ; Esi -> last character in cmd tail
                Std
                Mov     Al," "
                Mov     Ebx,1

CmdTailLoop:
                Repe    Scasb                   ; search for a non " " char

                TestZ   Ecx
                Jz      TailExit
                Inc     Ebx
                Inc     Edi
                Mov     [Byte Edi+1],0
                Inc     Ecx
                Repne   Scasb                   ; search for a " " char
                Inc     Edi
                Push    Edi                     ; push argv[] pointer on stack
                Inc     [Dword PTR Esp]
                TestZ   Ecx
                Jz      TailExit
                Inc     Ecx
                jmp     CmdTailLoop
TailExit:       Push    [exename]             ; Store EXE file namepath
                Mov     Eax,Esp


                Mov [AbortStackPos],Esp ; Save the stack pointer

    ; Save in these varibles
    ;
                mov     [_argc],ebx
                mov     [_argv],eax
    ;
    ; Call the main!    /*  int main ( int argc, char * argv[], environ); */
    ;
                Push    [_environ]            ; pass environment pointer
                Push    Eax                   ; pass pointer to pointer array
                Push    Ebx                   ; pass arg count
                Call    main                  ; Start up the main()!

ExitSlow:       Mov Esi,Eax
                Call _cexit
ExitQuick:      Mov Eax,Esi
                Mov Ah,4Ch
                Int 21h
    Align   4
@@Exit01:       Mov Edx,Offset MemoryError
                Mov Ah,9
                Int 21h
                Mov Esi,3
                Jmp ExitQuick
ENDP







Proc __main
    ret
ENDP

    Dataseg

    Ifndef  NO_DMA
DMA_addr    Dd  ?           ; DMA near pointer address
DMA_size    Dd  8192            ; DMA size in bytes
DMA_phys    Dd  ?           ; DMA physical address
    Endif


_environ        Dd  ?       ; pointer to environment
_envsize        Dd  ?       ; environment table entries.
environ         Dd  ?       ; Table environment pointer
_psp            Dd  ?       ; PSP pointer
exesize         Dd  ?       ; Executable size
exename         Dd  ?       ; Executable name
_zero           Dd  ?       ; Relative address to zero
_zero_sel       Dd  ?       ; 4GB ZERO selector (not NULL!)
_argc           Dd  ?       ; commane line ptr table size
_argv           Dd  ?       ; ptr of command line ptr table
dos32version    Dd  ?       ; DOS32 version
dos32system     Db  ?       ; System extender type

AbortStackPos   Dd  ?       ; Saved stack position (abort)
ExitStatus      Db  3       ; Exit status
CMDLINE_environ Db  "CMDLINE",0

MemoryError Db  "Out of memory...",CRLF,'$'

    End startup
