;******************************************************************************
; Filename: RENAME.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.06.05
;  Updated: 1994.09.20
;******************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;******************************************************************************
; Function: LONG @rename(PSZ oldname,PSZ newname)
;  Comment: Renames a file or moves a file (within a drive)
;    Input: Eax - oldname, file to be renamed
;           Edx - newname, new file name
;  Returns: 0 if successful or -1 if it failed
;******************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    rename ,2
                Push    Edi,Es
                Push    Ds
                Pop     Es
                Mov     Edi,Edx
                Mov     Edx,Eax
                Mov     Ah,56h
                Int     21h
                Jc      @@Error
                Pop     Es,Edi
                Clear   Eax
                Ret
        Align   4
@@Error:        Pop     Es,Edi
                Mov     [Word errno],Ax
        IfDef   DEBUG
                Call    printf,Offset ErrReadMsg,Edx,Edi
        EndIf
                Mov     Eax,-1
                Ret
Endp

        Dataseg

        IfDef   DEBUG
ErrReadMsg      Db      "Error renaming file from '%s' to '%s'! Error: %h",LF,0
        Endif

        End
