comment $#####################################################################

Memory Allocation System v0.2a
by Dark Fiber [NuKE]
entropy@break.com.au


Read MEMORY.DOC for usage details.....


#############################################################################
$

.386
.Model Flat ,C


Include memory.inc

ifdef masm
 OPTION OLDSTRUCTS
endif


d equ dword ptr
f equ fword ptr
w equ word ptr
b equ byte ptr

_mem_free       equ "AA"
_mem_used       equ "BB"

on              equ     1
off             equ     0

mem struc
mem_marker      dw ?
mem_block       dd ?
mem_end         db ?
db              16-$ dup (?)
mems_size       equ $
mem ends

.CODE

align 4
init_mem_heap proc near
        push    esi
        push    edx
        push    eax

        mov     esi,edx
        mov     ax,0ee42h       ;DOS32 specific, allocate memory.
        int     031h            ;EDX=size to allocate.
        jnc     init_heap_ok    ;returns, EAX=actual size, EDX=offset
        cmp     esi,-1
        je      init_heap_ok

        push    eax
        mov     ax,0ee40h       ;DOS32 specific. deallocate block.
        int     031h            ;EAX=offset
        pop     eax
        jmp     init_heap_fail

init_heap_ok:
        mov     d[mem_off],edx
        mov     d[mem_size],eax

        sub     eax,mems_size
        mov     w[edx].mem_marker,_mem_free
        mov     d[edx].mem_block,eax
        mov     b[edx].mem_end,on

        clc

init_heap_fail:
        pop     eax
        pop     edx
        pop     esi
        ret
init_mem_heap endp

;%% call with
;   eax = memory block
; returns
;   nocarry
;     eax=0 = good
;   carry
;     eax=1 = not a used memory block
;     eax=2 = corrupt memory block

align 4
free_mem proc near
        push    ebx
        push    ecx

        lea     ebx,[eax-mems_size]
        xor     eax,eax
        cmp     w[ebx].mem_marker, _mem_used
        je      fm_00

        stc
        inc     eax
        cmp     w[ebx].mem_marker, _mem_free
        je      fm_01
        inc     eax
        jmp     fm_01

fm_00:  mov     w[ebx].mem_marker, _mem_free
        call    hash_free_mem

fm_01:  pop     ecx
        pop     ebx
        ret
free_mem endp

align 4
hash_free_mem proc near
        push    esi
        push    ebx
        push    ecx
        push    edx

        mov     esi,d[mem_off]

hfm_00: cmp     w[esi].mem_marker, _mem_free
        jne     hfm_01

        mov     ebx,esi
        add     ebx,d[esi].mem_block
        cmp     w[ebx].mem_marker, _mem_free
        jne     hfm_01

        mov     dl,b[ebx].mem_end
        mov     ecx,d[ebx].mem_block

        mov     b[esi].mem_end, dl
        add     d[esi].mem_block, ecx
        jmp     hfm_00

hfm_01: cmp     b[esi].mem_end, on
        je      hfm_02
        add     esi,d[esi].mem_block
        jmp     hfm_00

hfm_02: pop     edx
        pop     ecx
        pop     ebx
        pop     esi
        ret
hash_free_mem endp


;%% call with
;   eax=size in bytes of block to allocate
; returns
;   nocarry
;     eax=offset
;   carry
;     eax=max block you can have
align 4
alloc_mem proc near
        push    ecx
        push    esi
        push    ebx
        push    edx

        mov     ebx,eax
        add     ebx,mems_size
        jnc     am_02
        mov     ebx,-1
am_02:
        mov     esi,d[mem_off]
        call    scan_mem
        jc      am_00

        mov     esi,eax

        mov     dl,b[esi].mem_end
        mov     ecx,d[esi].mem_block
        mov     w[esi].mem_marker, _mem_used
        mov     d[esi].mem_block, ebx
        mov     b[esi].mem_end, on

        sub     ecx,ebx

        cmp     ecx,(mems_size*2)
        ja      am_01

        add     d[esi].mem_block, ecx
        lea     eax,[esi+mems_size]
        jmp     am_00

am_01:  mov     b[esi].mem_end, off
        lea     eax,[esi+mems_size]

        add     esi,ebx
        mov     w[esi].mem_marker, _mem_free
        mov     d[esi].mem_block, ecx
        mov     b[esi].mem_end, dl

am_00:  pop     edx
        pop     ebx
        pop     esi
        pop     ecx
        ret
alloc_mem endp

align 4
scan_mem proc near
        push    ecx
        xor     ecx,ecx

sm_00:  cmp     w[esi].mem_marker,_mem_free
        je      sm_98

sm_97:  cmp     b[esi].mem_end, on
        je      sm_99
        add     esi,d[esi].mem_block
        jmp     sm_00

sm_98:  cmp     ecx,d[esi].mem_block
        ja      sm_96
        mov     ecx,d[esi].mem_block
sm_96:  cmp     d[esi].mem_block, ebx
        jb      sm_97
        lea     eax,[esi]
        pop     ecx
        clc
        ret

sm_99:  lea     eax,[ecx-mems_size]
        pop     ecx
        stc
        ret
scan_mem endp

mem_off         dd ?
mem_size        dd ?
mem_version     db "0.2",0
end_memory_system:

;============================================================================

end 