VERSION_AND_DATE    EQU    <"1.20 , Aug-1996">
comment ~ 

				  DOS32 Protected Mode Debugger

						Version (see above)

      Copyright (c) Adam Seychell, James B, 1995.  All rights reserved




                           COPYRIGHT

     This software is under copyright and may only be
distributed under the terms and conditions stated in the
General Public Licence. A copy of the licence is distibuted
with this software under the file name GPL.DOC




		     Last Modified on 1st Oct 1995 by Adam S.
		     Last Modified on 11th Dec 1995 by James B.
		     Last Modified on 14th Dec 1995 by James B.
		     Last Modified on 25th Dec 1995 by James B.
		     Last Modified on 19th Mar 1996 by Adam S.
		     Last Modified on 20th Mar 1996 by James B.
		     Last Modified on 17th April 1996 by Adam S.
		     Last Modified on 27th April 1996 by Adam S.
		     Last Modified on 3 May 1996 by Adam S.
		     Last Modified on 13 May 1996 by James B







 I have released the source in the hope it will be useful and that
 if someone has made some improvments and would like to share thier
 work then please send me the new copy so I can release it for next
 versions of DOS32. This source code is written in MASM 6.1 and by
 no means is it written neatly. If someone wants to write thier
 own debugger then best thing would be to use the instruction decode
 routine ( DEBUG.INC ) since this is a general routine for displaying
 486 instructions as a string. The rest of the debugger could be written
 in 32bit C/C++ and while still using ASM for the exception handlers.

 If you have written some code for the debugger or you would like to then
 please contact me by email or snail mail (see address in DOS32.DOC)
 and I will send you the latest copy of the source code so you can
 make your changes. The other option is to send me just the changes
 you have made and I'll implement them to the 'home copy' of the debugger
 source. This is to make sure that all improvments made by everyone who
 has or would like to contirbute, will released in the next version
 of DOS32.

James modification note from version 1.11 to 1.11a

The modification was based on DEBUG32 version 1.11 as released in DOS32 v3.2.
Since the modification was minor, I don't change the version, only append an
'a' to it to differentiate it from the original.

All modification are surrounded by ;***. This is not to show off that I
modify a lot of places, no at all. I do that so you can see which part is
changed and which part is not. After you have examined it, you can delete
all the marks.

Basically, this is what I've done to it:
* rewrite the key dispatcher (in Handle_Debug_Exception) using tables
  instead of direct comparison. This is to facilitate interactivity in
  each "window". Each window now has separate command keys table.
* adding a data window
  - add data display section to refresh_screen
  - change frame drawing in Debuggers_Video
* the other windows are now active: there are now 4 active windows:
  code, register, flag, data, instead of code only. Each has a set of
  context sensitive menu bar and context sensitive command keys, with some
  global keys (in shared_table).
* add interactivity to each window
  - in code window,
    + you can change the starting address of display.
    + get the true F4-Here (from turbo debugger). The original F4 is now
      renamed under Ctrl-N (New) which sets EIP from selected_line.
    + get Ctrl-O (origin): to get back the disassembly at current EIP if you
      have moved to somewhere else and get lost.
  - in register window
    + you can change the value
  - in the flag window
    + you can change set/reset/toggle the flag
  - in data window
    + you can change the offset to display
    + you can change the actual data bytes in memory
    + you can scroll up, down, page-up, page down bytes of memory.
* I have decided to change some of the key lay-out in the original DEBUG32,
  in order to match turbo debugger more closely. Sorry about that. I used TD
  very often so I think matching DEBUG32 keys to TD keys is a good idea...
  You can see the key allocation from the menu bar. It contains all the
  keys I have defined.
  Anyway, you can always change the lay-out: it is as easy as changing the
  tbl_key value in key_struct below in the command tables.

James modification note from version 1.11a to 1.11b

* Alt +,- is now a global key to inc/dec ESP by 4. That is, a global key to
  view the stack frame. Alt * will reset ESP to its most recent value.

James modification note from version 1.11b to 1.11c

* Change regs (in whatever ways) now works as expected (change jmp main_loop
  to jmp load_all_regs). Previously it has a bug: the value shown on
  screen is changed, but when stepping it uses old value (yuck!).
* Alt +,- is now a global key to change stack frame view.
  Alt + will scroll up
  Alt - will scroll down
  Alt * will reset stack frame ptr to ESP,
  Alt / will reset stack frame ptr to EBP.
  By default, after stepping stack frame ptr will be equal to ESP
  Note: Alt +,-,*,/ *no longer* affects ESP!!! You have to change ESP
  manually now.
  Note: changing any register automatically resets frame ptr to ESP!!!

Adam's change from 1.11c to 1.11d

1. Fix Numlock bug. Previously, activating Numlock will screw up keypad
   (not numeric pad) cursors handling, because each key press of keypad
   will automagically enclosed with a shift key press.
2. Make stack frame shows ss:esp and/or ss:ebp at exact location, and
   this is scrollable. Can even shows both ss:esp & ss:ebp now! (nice feature).

James's change from 1.11d to 1.11e

1. Now changing registers does not change frame ptr.
   Stepping/run program etc still do, and this is intentional.

Note to Adam:
1. I don't change the copyright name. You make most of it, I only add some
   infinitesimal cosmetics...I just don't deserve a place there. I am content
   enough if you can put my name in contributors' list.
   (But of course if you think differently and want to put my name in the
   copyright section, I would feel very honored.... :)

2. I will not distribute the modified version to public domain by myself.
   Rather, I submit this modification to you so that you can organize them and
   publish them with the next version of DOS32. In this way, there is only
   one authoritative version of DOS32, and there is  only one authorized
   source: Adam Seychell (thanks for the great product! :).

Adam:   v1.11f

* Improved print_message_box procedure to handle multiple lines.
  Uses character 10 for a new line.
* changed debugger intro message to list contributors.
* converted all symbols to case matching.
* made DECODE.ASM into a module.
* changed makefile to produce a LIB
* defined multiple symbol names that can be used to execute the debugger.
  eg.  Debug, debug, DEBUG, _debug, _Debug,, ect...



Adam:   v1.11g

* started setting up for FPU windows.
* coded routine to print 80bit extended precision floating point real
  numbers. This was not an easy task. See the routine for your self and
  you'll relize the trouble I must of went through. It took me a week
  to complete.
* made new macros for FPU instruction definitions for the instruction
  decode routines. filles in first three FPU instructions


Adam:   v1.11h

* made code window screen draw line to and from jump instructions.
  only draws if jump condition is true

James:   v1.11i

* coded an alternative 80-bit printer. The accuracy is only 17-digits, though 
  (out of 19-digits possible). It uses log & antilog algorithms.
* correct tag word meaning. tag word is *not* aligned with st0 etc in fpu_envir!!
* eliminate several references to i variable.
* eliminate residual chars when printing "empty" (just add more spaces)
* todo: - make segment reg window active (is this useful? in flat mode, we
	  are not supposed to use (or change) segment very often...)
	- make fpu reg window active (this will need a float_input, and will
	  be impossible without input window dialog box (or something like that)
* known bug not yet fixed:
  - see BUGS.TXT


Adam:   v1.11j

* fixed jumping line bug with the instructions JECXZ, LOOPZ, LOOPNZ and
   Jxx near displacments.
* Stoped instruction pointer from going below the program loading address
  for DOS32 Versions 3.5+. This will stop page faulting in the debugger
  trying to 'look' at non valid memory.
* included the non 387+ fpu instructions, fdidi, feni, fsetpm, frspm
* made decode routine diaplay fpu memory operand size.
* fixed fstp st(i)  display, The Intel Microprocessors Vol I & II
  have a error in their opcode table for this instruction.


Adam:   v1.11k

* fixed bug in print_float2 routine. Now displays floats OK.
* put feature to set data window offset to current memory operand
  by pressing Shift+Space when in code window.

~


OPTION OLDSTRUCTS
.386p
.387
.MODEL FLAT


;
;  Define all possible calling names to the debugger.
;(just so you don't have to remember what case to use )


EXTERNDEF       Debug             :Near
EXTERNDEF       _Debug            :Near
EXTERNDEF       debug             :Near
EXTERNDEF       _debug            :Near
EXTERNDEF       _Debug_Run        :Near
EXTERNDEF       _debug_run        :Near
EXTERNDEF       _debugrun         :Near
EXTERNDEF       _DebugRun         :Near
EXTERNDEF       Debug_Run         :Near
EXTERNDEF       debug_run         :Near
EXTERNDEF       debugrun          :Near
EXTERNDEF       DebugRun          :Near





include debug.inc   ; This is the instruction decoding routine

;***james
include keys.inc    ; this file holds key scan code definition
SHF   EQU 4         ; artificial KB flag used in Handle_Debug_Exception
CTL   EQU 2         ;
ALT   EQU 1         ;
NONE  EQU 0         ;

CODE_W EQU 0        ;do not change this!!! The code depends on the value.
REGS_W EQU 1        ;used in which_window variable
FLAG_W EQU 2        ;
DATA_W EQU 3        ;
DRx_W  EQU 32
STx_W  EQU 33
;***


CODE_WINDOW_WIDTH               EQU     46
CODE_WINDOW_HEIGHT              EQU     39

ScreenHeight            EQU     50
ScreenWidth             EQU     80
boarder_color           EQU     3fh
back_color              EQU     3fh
back_color_EA           EQU     03fh
selected_color          EQU     1fh
selected_brkpt_color    EQU     0dfh
brkpt_color             EQU     4fh
registers_color         EQU     30h
base_addr_color         EQU     38h
RegistersHiLight_color  EQU     34h
menu_color              EQU     70h
menu_color1             EQU     78h
heading_color           EQU     3bh
SS_EBP_stackframe_color EQU     3ah
hilight_color           EQU     75h
mesg_box_text_color     EQU     071h
mesg_box_color          EQU     07eh
fpu_registers_color             EQU             038h
flag_registers_color    EQU             030h
fpu_dummy_color                 EQU             039h
DATA_offset_color               EQU             03Eh
cs_eip_color                    EQU             038h



VIDEO_BUFFERS STRUC
BitPlane1     DB 8192 dup (?)          ; The 8KB of screen memory
BitPlane2     DB 8192 dup (?)          ; The 8KB of video font memory
VIDEO_BUFFERS ENDS



	.DATA?


VideoBuffers                    VIDEO_BUFFERS   <>
registers_save                  program_reg     <>
origonal_registers              program_reg     <>
registers_saved_backlog         program_reg     48 DUP ({})
Old_IntVect7                            intvector               ?
Old_IntVect13                           intvector               ?
Old_IntVect14                           intvector               ?
Old_IntVect16                           intvector               ?
BreakPoint_EIP                  dword                   Number_brkpts dup (?)
BreakPoint_oldopcode            byte                    Number_brkpts dup (?)

; VGA register saved 
VideoReg_CRTC_index             byte    ?
VideoReg_SQ_index               byte    ?
VideoReg_GC_index               byte    ?
VideoReg_MiscOutp               byte    ?
VideoReg_CRTC                   byte    19h dup (?)
VideoReg_SQ                     byte    5h dup  (?)
VideoReg_GC                     byte    9h dup  (?)
VideoReg_Attr                   byte    15h dup (?)
VideoReg_Palette                byte    768 dup (?)
VideoReg_PELaddrWrite           byte    ?
BIOS_cursor                     word    ?
NumberOfCharacterRows           byte    ?
BytesPerCharacter               word    ?


string_buffer                           byte    80 dup (?)


		.DATA

align 4
;=


align 4
Segment_Base            		DD  0
_0B8000h                		dd 0B8000h  ; 32bit offset
Program_Addr            		dd 0        ; 32bit offset
Zero_addr               		dd 0        ; 32bit offset
Program_BaseOffset				dd 0
screen_EIP_value        		dd 0
current_memory_operand_address 	dd 0
selected_EIP            		dd 0
BacklogRegPTR_tail      		dd 0
BacklogRegPTR_head      		dd 0
screen_ending_EIP       		dd 0
CODE32_sel              		dw 0        ; Selector
Zero_sel                		dw 0        ; Selector
saved_IRQ1              		df 0
saved_int21             		df 0
saved_INT32             		df 0
prg_videomode           		db 0
special_brkpt_EIP       		dd 0
special_brkpt_save      		db 0
special_brkpt           		db FALSE
haveOrigonalRegisters   		db FALSE
Step_flag               		db FALSE
users_screen_flag       		db TRUE
program_is_running      		db FALSE
fast_scroll                     db FALSE
InitDebugOnly           		db FALSE
Debug_Operating         		db FALSE
testing_EA_TEXT         		db FALSE
conditional_jump        		db FALSE
DebuggerTerminated      		db FALSE
fpu_emulation_flag      		db FALSE
bottom_window_FLAG      		db STx_W
Key_flags               		db 0
selected_line           		sbyte 0
MOD_RM_flag             		db 0
Kbd_Rate                		db -1
Kbd_Delay               		db -1
prev_key_code           		db 0
FPU_installed           		db FALSE  ; is the FPU installed ?

;***james addition
Until_Here              db 0  ;0=not engaged, 1=set brkpt, 2=run program
Until_Here_EIP          dd 0  ;brk point set by Until_Here
Data_Offset             dd 0  ;inv_adr_mesg  ;current top ptr of data view
which_window            db 0  ;0=code, 1=reg, 2=flag, 3=data
reg_selected            db 0  ;equivalent of selected_line for register window
flag_selected           db 0  ;for flag window
data_selected           db 0  ;for data window
max_data_select         db 0  ;max value for data_selected
Frame_Ptr               dd 0  ;stack frame ptr
Keep_Frame_Ptr          db 0  ;FALSE=reload frame_ptr from ss:esp, TRUE=don't reload
;***



;***james modified
; menu bar texts 
Menu_shift_bar label dword      ;context-sensitive menu bar for shift key
  dd Code_Menu_shift_bar_text
  dd Reg_Menu_shift_bar_text
  dd Flag_Menu_shift_bar_text
  dd Data_Menu_shift_bar_text

Menu_ctrl_bar label dword      ;context-sensitive menu bar for ctrl key
  dd Code_Menu_ctrl_bar_text
  dd Reg_Menu_ctrl_bar_text
  dd Flag_Menu_ctrl_bar_text
  dd Data_Menu_ctrl_bar_text

Menu_alt_bar label dword      ;context-sensitive menu bar for alt key
  dd Code_Menu_alt_bar_text
  dd Reg_Menu_alt_bar_text
  dd Flag_Menu_alt_bar_text
  dd Data_Menu_alt_bar_text

Menu_bar label dword          ;context-sensitive menu bar
  dd Code_Menu_bar_text
  dd Reg_Menu_bar_text
  dd Flag_Menu_bar_text
  dd Data_Menu_bar_text

;;code window
sp_str_ = $
Code_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: ',0,menu_color,'   '
db 0,hilight_color,'X-',0,menu_color,'Exit   '
db 0,hilight_color,'F4-',0,menu_color,'Back   '
db 0,hilight_color,'F5-',0,menu_color,'User screen   '
db 0,hilight_color,'+,-,*,/ ',0,menu_color,'Frame Up,Dn,ESP,EBP   '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Code_Menu_bar_text Label byte
db 0,menu_color,'    '
db 0,hilight_color,'F2-',0,menu_color,'Brkpt  '
db 0,hilight_color,'F4-',0,menu_color,'Here  '
db 0,hilight_color,'F7-',0,menu_color,'Next  '
db 0,hilight_color,'F8-',0,menu_color,'Step  '
db 0,hilight_color,'F9-',0,menu_color,'Run  '
db 0,hilight_color,'Tab-',0,menu_color,'Regs  '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec  '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Code_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,'    '
db 0,hilight_color,'F2-',0,menu_color,'Restart  '
db 0,hilight_color,'N-',0,menu_color,'New EIP  '
db 0,hilight_color,'O-',0,menu_color,'Goto Origin  '
db 0,hilight_color,'0..9/A..F/BackSp-',0,menu_color,'Change EIP  '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Code_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: ',0,menu_color,'   '
db 0,hilight_color,'Up/Dn/PgUp/PgDn-',0,menu_color,'Scroll data   '
db 0,hilight_color,'Space-',0,menu_color,'goto memory operand   '
db 0,hilight_color,'Tab-',0,menu_color,'Data   '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

;;reg window
sp_str_ = $
Reg_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: ',0,menu_color,' '
db 0,hilight_color,'X-',0,menu_color,'Exit  '
db 0,hilight_color,'F4-',0,menu_color,'Back  '
db 0,hilight_color,'F5-',0,menu_color,'User screen  '
db 0,hilight_color,'F9-',0,menu_color,'Restart  '
db 0,hilight_color,'+,-,*,/ ',0,menu_color,'Frame Up,Dn,ESP,EBP   '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Reg_Menu_bar_text Label byte
db 0,menu_color,'    '
db 0,hilight_color,'F7-',0,menu_color,'Next    '
db 0,hilight_color,'F8-',0,menu_color,'Step    '
db 0,hilight_color,'F9-',0,menu_color,'Run    '
db 0,hilight_color,'Tab-',0,menu_color,'Flag   '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Reg_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,'      '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Reg_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: ',0,menu_color,' '
db 0,hilight_color,'0..9/A..F/BackSp-',0,menu_color,'Change '
db 0,hilight_color,'Up/Dn/PgUp/PgDn-',0,menu_color,'Scroll data '
db 0,hilight_color,'Tab-',0,menu_color,'Code '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

;;flag window
sp_str_ = $
Flag_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: ',0,menu_color,' '
db 0,hilight_color,'X-',0,menu_color,'Exit  '
db 0,hilight_color,'F4-',0,menu_color,'Back  '
db 0,hilight_color,'F5-',0,menu_color,'User screen  '
db 0,hilight_color,'F9-',0,menu_color,'Restart  '
db 0,hilight_color,'+,-,*,/ ',0,menu_color,'Frame Up,Dn,ESP,EBP   '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Flag_Menu_bar_text Label byte
db 0,menu_color,'  '
db 0,hilight_color,'F7-',0,menu_color,'Next  '
db 0,hilight_color,'F8-',0,menu_color,'Step  '
db 0,hilight_color,'F9-',0,menu_color,'Run   '
db 0,hilight_color,'Space,Enter-',0,menu_color,'Toggle  '
db 0,hilight_color,'0-',0,menu_color,'Reset  '
db 0,hilight_color,'1-',0,menu_color,'Set  '
db 0,hilight_color,'Tab-',0,menu_color,'Data  '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Flag_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,'      '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Flag_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: ',0,menu_color,'    '
db 0,hilight_color,'Up/PgUp-',0,menu_color,'Scroll data up    '
db 0,hilight_color,'Down/PgDn-',0,menu_color,'Scroll data down    '
db 0,hilight_color,'Tab-',0,menu_color,'Regs  '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

;;data window
sp_str_ = $
Data_Menu_alt_bar_text Label byte
db 0,hilight_color,' Alt: ',0,menu_color,' '
db 0,hilight_color,'X-',0,menu_color,'Exit  '
db 0,hilight_color,'F4-',0,menu_color,'Back  '
db 0,hilight_color,'F5-',0,menu_color,'User screen  '
db 0,hilight_color,'F9-',0,menu_color,'Restart  '
db 0,hilight_color,'+,-,*,/ ',0,menu_color,'Frame Up,Dn,ESP,EBP   '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Data_Menu_bar_text Label byte
db 0,menu_color,'    '
db 0,hilight_color,'F7-',0,menu_color,'Next   '
db 0,hilight_color,'F8-',0,menu_color,'Step   '
db 0,hilight_color,'F9-',0,menu_color,'Run   '
db 0,hilight_color,'Tab-',0,menu_color,'Code   '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec value  '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Data_Menu_ctrl_bar_text label byte
db 0,hilight_color,' Ctrl: ',0,menu_color,'   '
db 0,hilight_color,'0..9/A..F/BackSp-',0,menu_color,'Change offset   '
db 0,hilight_color,'+/- ',0,menu_color,'Inc/Dec offset   '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'

sp_str_ = $
Data_Menu_shift_bar_text label byte
db 0,hilight_color,' Shift: ',0,menu_color,' '
db 0,hilight_color,'0..9/A..F-',0,menu_color,'Change value '
db 0,hilight_color,'Up/Dn-',0,menu_color,'Scroll '
db 0,hilight_color,'Tab-',0,menu_color,'Flag '
sp_len_ = 110-($-sp_str_)
db sp_len_ dup(' '),'$'
;***


stk_mesg        db 0,heading_color,'Stack frame$'
stk_ptrmesg     db 0,heading_color,'ss:esp$'
ebp_ptrmesg     db 0,SS_EBP_stackframe_color,'ss:ebp$'
stk_blankit     db '      $'
dat_mesg db 0,heading_color,'Offset: $'  ;***james



man_font        LABEL   byte
Include man_font.inc
man_font_SIZE    EQU $ - offset man_font

superscript_font    LABEL   byte
Include supscrip.inc
superscript_font_SIZE    EQU $ - offset superscript_font

arrows_font    LABEL   byte
Include arrows.inc
arrows_font_SIZE    EQU $ - offset arrows_font




		.CODE
;
;
;    The routine wich starts the dubugger
;
;    This roitine will just init the debugger and set the Trap flag
;
;
;
align 4
_Debug:
_debug:
debug:
Debug    PROC
	push    ds                              ; save DS
	mov     ax,_TEXT
	mov     ds,ax
	pop     registers_save.prg_ds
	pushfd                                  ; Save eflags
	pop     registers_save.prg_eflags
	mov     registers_save.prg_es,es        ; Save ES
	pop     registers_save.prg_EIP          ; Save EIP
	mov     registers_save.prg_esp,esp      ; Save SS:ESP
	sub     registers_save.prg_esp,4
	mov     registers_save.prg_ss,ss
	pushad
	push    ds
	pop     es
	mov     Debug_Operating,TRUE
	call    debugger_init
	;* start the debugging *


	mov     byte ptr [debug],11001100b        ; put a INT 3
	mov     byte ptr [debug+1],11000011b      ; put a ret
	mov     byte ptr [debug_run+1],11000011b      ; put a ret


	push    registers_save.prg_es
	push    registers_save.prg_ds

       .if  Debug_Operating == FALSE
	 pop    ds
	 pop    es
	 popad
	 push    word ptr cs:registers_save.prg_eflags
	 popf
	 jmp     cs:registers_save.prg_EIP      ; goto program without debug
       .endif

       .if    InitDebugOnly == FALSE
	 or     registers_save.prg_eflags,00100000000b
       .endif

	pop     ds
	pop     es
	popad
	push    cs:registers_save.prg_eflags    ; set eflags with TF set
	popfd
	jmp     cs:registers_save.prg_EIP      ; goto program

Debug    ENDP



;
;
;    The routine initalizes the dubugger but does not set the Trap flag
;  thus continuing normal program execution.
;
;
;
align 4
_Debug_Run:
_debug_run:
_debugrun:
_DebugRun:
debug_run:
debugrun:
DebugRun:
Debug_Run PROC
	push    ds
	mov     ax,_TEXT
	mov     ds,ax
	mov     InitDebugOnly, TRUE
	call    Debug
	pop     ds
	ret
Debug_Run ENDP



;
;
;               initalize the debugger !!!!!!!!!!!!!!!!
;
;  This gets run only once when the debugger is started
;
;
;
debugger_init PROC PRIVATE

	mov     ax,0EE00h                       ; Get selecor values
	int     31h
	mov     Zero_sel,Bx


    cmp     ax,0350h					; get loading address of program
    jb @f
    mov		Program_BaseOffset,edi
    mov		Data_Offset,edi
@@:

	mov     ax,0EE02h                       ; Fixup address information
	int     31h
	mov     Program_Addr,Ebx
	neg     Ebx
	mov     Zero_addr,Ebx
	add     Ebx,0b8000h
	mov    _0B8000h,Ebx



	; If the Current Privilege Level (CPL) is above 0 then
	; we can't run the debugger
	;

	       mov      ax,cs
	       lar      eax,eax
	       test     ah,01100000b
	       jz CPL_0                      ; brach if the CPL = 0

	     ; display the error message
	     ;
	       call    Debuggers_Video
	       mov  edx,offset Mesg_dpmi_is_bad
	       call    print_message_box
	       mov  edx,offset Mesg_dpmi_is_bad1
	       call    print_message_box
	       call    Restore_Video
	       mov     Debug_Operating ,FALSE
	       ret                 ; Return to main program with no debugger
CPL_0:

	      mov  ax,cs                      ; Set RPL field to zero
	      and  al,11111100b
	      push eax
	      push offset Load_cs
	      retf
Load_cs:

	      cli



   .IF InitDebugOnly == TRUE

	mov     program_is_running, TRUE
  .ELSE

	call    Debuggers_Video

	; clear user breakpoint array 
	xor             eax,eax
@@: mov         BreakPoint_EIP[eax*4],-1
    inc         eax
    cmp         eax, LENGTHOF BreakPoint_EIP
    jne @b


	; set starting instuction 
	mov     eax,registers_save.prg_EIP
	mov     screen_EIP_value,eax
	cld
	mov    edx,offset intro_mesg
	call    print_message_box
  .ENDIF


    ; determine if FPU is installed 

    smsw        ax
    test        al, 4
    jz          emulation_is_off

    mov         fpu_emulation_flag,TRUE

   ; temperarily turn emulation off, 16bit emulators don't like
   ; 32bit mode.
   ;
    and         al,NOT 4
    lmsw    ax

emulation_is_off:

    ; No emulation. can try instructions
    ;

    fninit
    mov         ax,5a5ah
    fstsw       ax
    cmp         al,0
    jne         _turn_on_EM

	mov             FPU_installed, TRUE
	jmp             _387_checked


       ; if no FPU is installed then turn emulation flag on to trap
       ; all fpu instruction with exception # 7.
       ;
_turn_on_EM:
	    smsw        ax
	    or          al, 4
		lmsw    ax


_387_checked:

	; See if can set/get keyboard typmatic rate 
	mov     ah,9
	int     16h
	jc LeaveKbd
	and     al,00001100b
	cmp     al,00001100b
	jne  LeaveKbd


	; Save keyboard typmatic rate 
	mov     ah,03
	mov     al,06h
	int     16h
	mov     Kbd_Rate,bl             ; Rate  (0..1fh)
	mov     Kbd_Delay,bh            ; Delay (0..3)

	; set fast keyboard typmatic rate 
	mov     ah,03
	mov     al,05h
	mov     bl,0            ; Rate  (0..1fh)
	mov     bh,0            ; Delay (0..3)
	int     16h

LeaveKbd:





	; hook INT21 AH=4Ch   
	mov     bl,21h
	call    GetIntVector
	mov     dword ptr saved_int21,edx
	mov     word ptr saved_int21+4,cx

	mov     edx,offset terminate_Hooker
	mov     cx,cs
	call    SetIntVector


	; hook IRQ 1 the keyboard interrupt 
	mov     bl,1
	call    getIRQvector
	mov     dword ptr saved_IRQ1,edx
	mov     word ptr saved_IRQ1+4,cx

	mov     edx,offset keyboard_ISR
	mov     cx,cs
	call    setIRQvector


	; set debug interrupt hanlder ( INT 1 ) 
	mov     bl,1
	mov     edx,offset Debug_Exception
	mov     cx,cs
	call    SetIntVector


	; set the page faults handler 

	mov     bl,14
	call    GetIntVector
	mov     dword ptr Old_IntVect14,edx
	mov     word ptr Old_IntVect14+4,cx

	mov     bl,14
	mov     edx,offset PageFalts_Exception
	mov     cx,cs
	call    SetIntVector

	; set the break point handler (opcode 0CCh) 
	mov     bl,3
	mov     edx,offset BreakPoint_Exception
	mov     cx,cs
	call    SetIntVector

	; the General protection exception vector 
	mov     bl,13
	call    GetIntVector
	mov     dword ptr Old_IntVect13,edx
	mov     word ptr Old_IntVect13[4],cx

	mov     bl,13
	mov     edx,offset GeneralProtection_Exception
	mov     cx,cs
	call    SetIntVector

	; set the Invalid Opcode handler 
	mov     bl,6
	mov     edx,offset InvalidOpcode_Exception
	mov     cx,cs
	call    SetIntVector


	; set the Divide Error handler 
	mov     bl,0
	mov     edx,offset DivideError_Exception
	mov     cx,cs
	call    SetIntVector

	; set FPU exception handler 
	mov     bl,16
	call    GetIntVector
	mov     dword ptr Old_IntVect16,edx
	mov     word ptr Old_IntVect16[4],cx

	mov     bl,16
	mov     edx,offset FPU_Exception
	mov     cx,cs
	call    SetIntVector

	; set device NOT available handler 
	mov     bl,7
	call    GetIntVector
	mov     dword ptr Old_IntVect7,edx
	mov     word ptr Old_IntVect7[4],cx

	mov     bl,7
	mov     edx,offset DEVICE_Unavailable_Exception
	mov     cx,cs
	call    SetIntVector

	ret

debugger_init ENDP         ; end of debugger  inialization =
intro_mesg      db 'DOS32 protected mode debugger version ',VERSION_AND_DATE,10,
		       '   original author:     Adam Seychell',10,
		       '   contributors:      James Budiono ',
		   '$'
mem_mesg db 'Warning:   Insufficient memory available.',10,' Video buffering will be disabled $'
Mesg_dpmi_is_bad    db 'Debugger cannot be run above Privlidge Level 0$'
Mesg_dpmi_is_bad1    db 'Press a key to begin normal progam execution$'





;
;
;       Save the *complete* VGA video card state
;
;
;
save_CompleteVideoState PROC PRIVATE
	 cld
	 cli
;
;               Save some VGA registers
;

	; get and save programs video mode 
	mov     ah,0fh
	Int     10h
	mov     prg_videomode,al


	; get font information 
    push    ebp
	mov     ax,1130h
    mov     bh,0
	Int     10h
    pop		ebp
    inc     dl
	mov     NumberOfCharacterRows,dl
	mov     BytesPerCharacter,cx



	; save the CRT controller registers 
	mov     dx,3D4h
	in      al,dx
	mov     VideoReg_CRTC_index,al

	xor     ecx,ecx
@@:     mov     dx,3D4h
	mov     al,cl
	out     dx,al
	mov     dx,3D5h
	in      al,dx
	mov     VideoReg_CRTC[ecx],al
	inc     cl
	cmp     cl,SIZEOF VideoReg_CRTC
	jb @b


	; save the Sequencure controller registers 
	mov     dx,3C4h
	in      al,dx
	mov     VideoReg_SQ_index,al

	xor     ecx,ecx
@@:     mov     dx,3C4h
	mov     al,cl
	out     dx,al
	mov     dx,3C5h
	in      al,dx
	mov     VideoReg_SQ[ecx],al
	inc     cl
	cmp     cl,SIZEOF VideoReg_SQ
	jb @b


	; save the Graphic Controller Registers 
	mov     dx,3CEh
	in      al,dx
	mov     VideoReg_GC_index,al
	xor     ecx,ecx
@@:     mov     dx,3CEh
	mov     al,cl
	out     dx,al
	mov     dx,3CFh
	in      al,dx
	mov     VideoReg_GC[ecx],al
	inc     cl
	cmp     cl,SIZEOF VideoReg_GC
	jb @b


	; save the Attribute Controller Registers 
	mov     dx,3DAh         ; reset flip flop
	in      al,dx
	xor     ecx,ecx
@@:
	mov     dx,3C0h
	mov     al,cl
	out     dx,al
	inc     dl
	in      al,dx
	dec     dl
	out     dx,al
	mov     VideoReg_Attr[ecx],al
	inc     cl
	cmp     cl,SIZEOF VideoReg_Attr
	jb @b
	mov     dx,3C0h
	mov     al,20h                  ; Enaple palette
	out     dx,al
	mov     dx,3DAh                 ; reset flip flop
	in      al,dx




    ; save the video memory that gets wiped on mode switching 
    ;      set up registers to accsess one Bit plane  only
	mov dx,3C4h     ; sequencer reg group
	mov al,4
	mov ah,0111b
	out dx,ax

	mov dx,3CEh     ; The Graphics Controller reg group
	mov al,5        ; Mode Register
	mov ah,00000000b
	out dx,ax

	mov al,6        ; Miscellaneous Register
	mov ah,1100b
	out dx,ax

	mov al,4        ; set Read Map Mask Register
	mov ah,2        ; to read to bit plane 2
	out dx,ax

      ; save a bit of Bit Plane 2 ( the 8KB of video font memory ) -
	mov     esi,_0B8000h
	mov     edi,Offset VideoBuffers.BitPlane2
	mov     ecx,(sizeof  BitPlane2 )/4
	rep     movsd


  ; set up registers to accsess one Bit plane 0 and 1 chained together
	mov dx,3C4h ; sequencer reg group
	mov al,4
	mov ah,0011b    ; Chain four enabled
	out dx,ax

	mov dx,3CEh     ; The Graphics Controller reg group
	mov al,5        ; Mode Register
	mov ah,00010000b
	out dx,ax

	mov al,6        ; Miscellaneous Register
	mov ah,1110b
	out dx,ax

	mov al,4        ; set Read Map Mask Register
	mov ah,0        ; to read to bit plane 0
	out dx,ax

	; save a bit of Bit Plane 0 and 1 together 
	mov     edi,Offset VideoBuffers.BitPlane1
	mov     ecx,(sizeof BitPlane1 )/4
	mov     esi,_0B8000h
	rep     movsd



	mov dx,3C4h ; sequencer reg group
	mov al,4
	mov ah,VideoReg_SQ[4]
	out dx,ax

	mov dx,3CEh         ; The Graphics Controller reg group
	mov al,4            ; set Read Map Mask Register
	mov ah,VideoReg_GC[4]
	out dx,ax

	mov al,5      ; Mode Register
	mov ah,VideoReg_GC[5]
	out dx,ax

	mov al,6    ; Misellaneous Register
	mov ah,VideoReg_GC[6]
	out dx,ax

	; save the general or external VGA registers 
	mov     dx,3CCh
	in      al,dx
	mov     VideoReg_MiscOutp,al



; save the palette
	mov     dx,3C8h
	in      al,dx
	mov     VideoReg_PELaddrWrite,al
	mov     dx,3C7h

	mov     al,0
	out     dx,al
	mov     dx,3C9h
	xor     ecx,ecx
@@:     in      al,dx
	mov     VideoReg_Palette[ecx],al
	in      al,dx
	mov     VideoReg_Palette[ecx+1],al
	in      al,dx
	mov     VideoReg_Palette[ecx+2],al
	add     ecx,3
	cmp     ecx,SIZEOF VideoReg_Palette
	jb @b


	; save cursor position 
	mov     ah,3
	mov     bh,0
	int  10h
	mov     BIOS_cursor,dx
	ret

; finished saveing the video state 
save_CompleteVideoState ENDP




;
;
;
;   load the VGA video state from what was saved in the
;  "save_CompleteVideoState" procedure above
;
;
;
Restore_Video PROC PRIVATE
	 cld
	.IF   users_screen_flag
		ret
	.Endif
	pushad

	  ; first  retrun video mode 
	  xor   eax,eax
	  mov   al,prg_videomode
	  cmp   al,3h
;          je _Vmode3
	  cmp   al,83h
;          je _Vmode3
	  or    al,80h   ;***why is this needed ?
	  int 10h

	  mov   al,prg_videomode
      and   al,7fh
   .if (AL==3) && (BytesPerCharacter==8)
      mov ax,1123h
      mov bl,0
      mov dl,NumberOfCharacterRows
      int 10h
   .elseif  (AL==3) && (BytesPerCharacter==14)
      mov ax,1122h
      mov bl,0
      mov dl,NumberOfCharacterRows
      int 10h
   .endif

_Vmode3:

	 ; restore cursor position 
	 mov     ah,2
	 mov     bh,0
	 mov     dx,BIOS_cursor
	 int  10h



 ; restore the video memory that gets wiped on mode switching 

    ;      set up registers to accsess one Bit plane  only
    ; set for sequentual memory addressing
	mov dx,3C4h ; sequencer reg group
	mov al,4
	mov ah,0111b
	out dx,ax

	mov dx,3CEh ; The Graphics Controller reg group
	mov al,5      ; Mode Register
	mov ah,00000000b
	out dx,ax

	mov dx,3ceh ; The Graphics Controller reg group
	mov al,6    ; Misellaneous Register
	mov ah,1100b
	out dx,ax

      ; set Map Mask Register
	mov dx,3c4h ; sequencer reg group
	mov al,2
	mov ah,0100b    ;to write to bit plane 2
	out dx,ax

     ; can now fill up the video font memory
	mov     edi,_0B8000h
	mov     esi,Offset VideoBuffers.BitPlane2
	mov     ecx,(sizeof  BitPlane2 )/4
	rep     movsd



  ;      set up registers to accsess one Bit plane 0 and 1 chained together
	mov dx,3C4h ; sequencer reg group
	mov al,4
	mov ah,00011b            ; Chain four enabled
	out dx,ax

	mov dx,3CEh ; The Graphics Controller reg group
	mov al,5      ; Mode Register
	mov ah,00010000b
	out dx,ax

	mov al,6    ; Miscellaneous Register
	mov ah,1110b
	out dx,ax

     ; set Map Mask Register
	mov dx,3c4h ; sequencer reg group
	mov al,2
	mov ah,0011b    ;to write to bit plane 0 and 1
	out dx,ax

	; restore the first 4KB of bit plane 0 and 1 

	mov     esi,Offset VideoBuffers.BitPlane1
	mov     ecx,(sizeof BitPlane1 )/4
	mov     edi,_0B8000h
	rep     movsd


	; Resotre the general or external VGA registers 
	mov     dx,3C2h
	mov     al,VideoReg_MiscOutp
	out     dx,al


	; restore the CRT controller registers 

	mov     al,VideoReg_CRTC[ecx]   ; Turn off protection
	mov     dx,3D4h
	mov     ah,VideoReg_CRTC[11h]
	and     ah,01111111b
	mov     al,11h
	out     dx,ax

	xor     ecx,ecx
@@:     mov     dx,3D4h
	mov     al,cl
	out     dx,al
	mov     dx,3D5h
	mov     al,VideoReg_CRTC[ecx]
	out     dx,al
	inc     cl
	cmp     cl,SIZEOF VideoReg_CRTC
	jb @b
	mov     dx,3D4h
	mov     al,VideoReg_CRTC_index
	out     dx,al


	; restore the Graphic Controller Registers 

	xor     ecx,ecx
@@:     mov     dx,3CEh
	mov     al,cl
	out     dx,al
	mov     dx,3CFh
	mov     al,VideoReg_GC[ecx]
	out     dx,al
	inc     cl
	cmp     cl,SIZEOF VideoReg_GC
	jb @b
	mov     dx,3CEh
	mov     al,VideoReg_GC_index
	out     dx,al


	; Restore the Sequencure controller registers 
	xor     ecx,ecx
@@:     mov     dx,3C4h
	mov     al,cl
	out     dx,al
	mov     dx,3C5h
	mov     al,VideoReg_SQ[ecx]
	out     dx,al
	inc     cl
	cmp     cl,SIZEOF VideoReg_SQ
	jb @b
	mov     dx,3C4h
	out     dx,al
	mov     al,VideoReg_SQ_index


	; Restore the Attribute Controller Registers 
	mov     dx,3DAh         ; reset flip flop
	in      al,dx
	xor     ecx,ecx
@@:
	mov     dx,3C0h
	mov     al,cl
	out     dx,al
	mov     al,VideoReg_Attr[ecx]
	out     dx,al
	inc     cl
	cmp     cl,SIZEOF VideoReg_Attr
	jb @b
	mov     dx,3C0h
	mov     al,20h                  ; Enaple palette
	out     dx,al
	mov     dx,3DAh         ; reset flip flop
	in      al,dx




; Retore the palette

	mov     dx,3C8h
	mov     al,0
	out     dx,al
	mov     dx,3C9h
	xor     ecx,ecx
@@:     mov     al,VideoReg_Palette[ecx]
	out     dx,al
	mov     al,VideoReg_Palette[ecx+1]
	out     dx,al
	mov     al,VideoReg_Palette[ecx+2]
	out     dx,al
	add     ecx,3
	cmp     ecx,SIZEOF VideoReg_Palette
	jb @b
	mov     dx,3C8h
	mov     al,VideoReg_PELaddrWrite
	out     dx,al

	mov     users_screen_flag,TRUE
	popad
	ret
Restore_Video ENDP


;***james
;
;
;
;       Convert a scan code to a hex digit.
;
;      Expects   ch  = scan code
;      Return:   CF  = scan code not 0-9 or A-F
;                NC  = success, CL = hex digit (low nibble)
;
;
_scan2hex PROC PRIVATE
   xor cl,cl
   .if     cx == A_KEY
	mov cl,10
   .elseif cx == B_KEY
	mov cl,11
   .elseif cx == C_KEY
	mov cl,12
   .elseif cx == D_KEY
	mov cl,13
   .elseif cx == E_KEY
	mov cl,14
   .elseif cx == F_KEY
	mov cl,15
   .elseif cx == NUM_0
	;;xor cl,cl   ;do nothing
   .elseif (cx >= NUM_1) && (CX <= NUM_9)
	sub cx,(NUM_1-100h)
	shr ecx,8
   .else
	stc
   .endif
    ret
_scan2hex ENDP
;***


;
;
; The following routines are used to make calling DOS32 services easier.
;


SetIntVector    PROC PRIVATE Uses Eax
	mov     ax,0205h
	int     31h
	ret
SetIntVector    ENDP

GetIntVector    PROC PRIVATE Uses Eax
	mov     ax,0204h
	int     31h
	ret
GetIntVector    ENDP

getIRQvector    PROC PRIVATE Uses Eax Ebx
	cmp     bl,8h
	jb @@j1
	add     bl,60h
@@j1:   add     bl,8
	mov     ax,0204h
	int     31h
	ret
getIRQvector    ENDP

setIRQvector    PROC PRIVATE  Uses Eax Ebx
	cmp     bl,8h
	jb @@j1
	add     bl,60h
@@j1:   add     bl,8
	mov     ax,0205h
	int     31h
	ret
setIRQvector    ENDP




;
;  This procedure will test the QWORD at address in ECX to see if it's
; a valid location, i.e will not cause a page fault.
;
;
;  Return       If location is Ok then
;                   testing_EA_TEXT = TRUE
;                                   ecx:ebx = qword
;               else
;                   testing_EA_TEXT = FALSE
;
;
Test_location PROC PRIVATE USES ES
		mov     es,Zero_sel
		jmp  $+2
		mov     testing_EA_TEXT,TRUE
tea_ins:
		mov     ebx,es:[ecx]
		mov     ecx,es:[ecx+4]
tea_ins_size EQU $ - tea_ins
		nop
		nop
		nop
		nop
		nop
		nop
		ret
Test_location ENDP



;
;
;        Look at current instrucion and see if a VGA register was modified
;
;
;  Expects      "registers_save.prg_EIP" pointing to instruction
;
;  Returns:    restores video state if instruction was using a VGA port
;
;
CheckVGAport    PROC PRIVATE

	pushad
	mov     eax,registers_save.prg_EIP
	mov     eax,[eax]
	mov     cl,2
Loopeer:
	 .IF     al == 66h               ; igonre operand size prefix
	   shr eax,8
	 .ELSEIF  al == 11110010b        ; igonre any stupid REP prefix
	   shr eax,8
	 .ENDIF
       dec cl
       jnz Loopeer

	and     al,01111100b
	cmp    AL ,01101100b            ;see if IN,OUT, INS or OUTS
	je getPortIn
	jmp exit


getPortIn:
	mov     eax,registers_save.prg_edx
	mov     edi,offset allVGAports
	cld
	mov     ecx,19
	repne   scasw
	jne  exit

	 call    Restore_Video

exit:   popad
	ret

allVGAports     dw      3D4h,3D5h,3C4h,3C5h,3CEh,3CFh,3CCh,3CAh,3C2h,3DAh
		dw      3c0h,3c8h,3c9h,3c7h,3d6h,3c3h,3cdh,3d4h,3d5h
CheckVGAport    ENDP








;
;
;
;       Displays a repeated character on the screen Verticaly
;
;      Expects   edi = character offset in the screen memory.
;                al  = character
;                cl  = repeat
;                ah  = color
;
;
_draw_vert PROC PRIVATE USES edx ;***james: now preserve edx
	mov     edx,_0B8000h
@@:     mov     word ptr [edi*2+edx],ax
	add     edi,80
	dec    cl
	jnz @b
	ret
_draw_vert ENDP


;
;
;
;       Displays a repeated character on the screen horizonataly
;
;      Expects   edi = character offset in the screen memory.
;                al  = character
;                cl  = repeat
;                ah  = color
;
;
_draw_horz PROC PRIVATE USES edx ;***james: now preserve edx
	mov     edx,_0B8000h
@@:     mov     word ptr [edi*2+edx],ax
	inc     edi
	dec    cl
	jnz @b
	ret
_draw_horz ENDP



;
;
;
;       Displays a single character on the screen
;
;      Expects   edi = character offset in the screen memory.
;                al  = character
;                ah  = color
;
;
_draw_char PROC PRIVATE USES edx ;***james: now preserve edx
	mov     edx,_0B8000h
	mov     word ptr [edi*2+edx],ax
	inc     edi
	ret
_draw_char ENDP

;
;
;
;       reads current characer on the screen
;
;      Expects   edi = character offset in the screen memory.
;      returns   al  = character
;
;
read_char PROC USES EDX
	mov     edx,_0B8000h
	mov     al,byte ptr [edi*2+edx]
	ret
read_char ENDP

;
;
;
;       Displays two characters on the screen
;
;      Expects   edi = character offset in the screen memory.
;                bh  = character 1
;                bl  = character 2
;                ah  = color
;
;
_draw_2char PROC PRIVATE USES edx ;***james: now preserve edx
	mov     al,bh
	mov     edx,_0B8000h
	mov     word ptr [edi*2+edx],ax
	inc     edi
	mov     al,bl
	mov     word ptr [edi*2+edx],ax
	inc     edi
	ret
_draw_2char ENDP

;
;
;
;       Display a string on the screen
;
;      Expects   edi = character offset in the screen memory.
;                edx = points to the string that terminates with a '$'
;                ah  = color
;
;
plot_string PROC PRIVATE USES EBX
local first_pos :dword

		mov             ebx,_0B8000h
		mov             first_pos,edi
leer:   mov     al,[edx]
		cmp     al,'$'
		je exit
		cmp     al,0
		jne @f
	 	mov ax,[edx+1]
	 	add   edx,2
	 	xchg  al,ah
   @@:
    .if al != 10
      mov     word ptr [edi*2+ebx],ax
	  inc     edi
    .else
      add       first_pos,ScreenWidth*2
      mov    edi,first_pos
    .endif

    inc     edx
	jmp leer
exit:   ret
plot_string ENDP



;
;
;
;       Display a hexidecimal number on the screen
;
;      Expects   edi = character offset in the screen memory.
;                ebx = The number to display
;                cl = The number of nibbles to display
;
;
;
print_hex PROC PRIVATE USES EBX EBP EDX ECX
	mov     edx,_0B8000h
he_plotloop:
	rol     ebx,4
	movzx   ebp,bl
	and     ebp,0fh
	mov     al,ds:hex_chars[ebp]
	mov     word ptr [edi*2+edx],ax
	inc     edi
    dec     cl
	jnz he_plotloop
    ret
print_hex ENDP

hex_chars       db '0123456789abcdef'


;
;
;
;       Display a hexidecimal number on the screen without leading zeros
;
;      Expects   edi = character offset in the screen memory.
;                ebx = The number to display
;                cl = The number of nibbles to display
;
;
;
print_hexz PROC PRIVATE USES EBX EBP EDX ECX

    mov         ch,hex_chars[0]
	mov     edx,_0B8000h
he_plotloop:
	rol     ebx,4
	movzx   ebp,bl
	and     ebp,0fh
	mov     al,ds:hex_chars[ebp]
    cmp         al,ch
    jne _P
    mov         al,' '
    jmp     _E
_P: mov     ch,-1
_E:     mov     word ptr [edi*2+edx],ax
	inc     edi
    dec     cl
	jnz he_plotloop
    cmp         ch,-1
    jne @f
    ret
@@: dec         edi
	mov     al,'0'
	mov             cl,1
	jmp             _P

print_hexz ENDP


;
;
;
;       This will display the 387 stack
;
;
;  Expects Nothing
;
;
Display_387_info     PROC  PRIVATE

Local ST_symbol_ptr :dword
Local ST_tag_word   :word

    .if (bottom_window_FLAG != STx_W)
	 call   clear_bottom_window
	     mov         bottom_window_FLAG, STx_W
    .endif




;********* plot the FPU registers ******************

	    .IF ( FPU_installed )
		mov     ST_symbol_ptr , offset ST0_symb
		mov     edi,  ScreenWidth*(ScreenHeight-9) + 1
		mov     esi,0

	     ;***james
	     ; Note: while the tag field sequence is absolute,
	     ;       the ST(x) sequence in save area is *RELATIVE* to stack top!!
	     ; This must be taken into account by rolling the tag bits so that
	     ; the stack top bits are at the bottom.
	     ; we do this only once, and use the modified one for the rest of the time

	     ; ** get the stack top
	     mov     ecx, registers_save.fpu_envir.status
	     shr     ch,3
	     and     ch,7      ;stack top on ch
	     mov     cl,ch
	     add     cl,cl     ;times 2 (tag is 2-bit wide)
	     mov     ebx, registers_save.fpu_envir.tag
	     ror     bx,cl     ;do the trick
	     mov     ST_tag_word,bx
	     ; ***

Plot_ST_loop:
	     ; ** plot eight 80 bit register symbol ******
		push    edi
		mov     edx,ST_symbol_ptr
		mov     ah,registers_color
		call    plot_string
        inc 	edi

	     ; read specific TAG field

		mov     bx, ST_tag_word   ;*** use modified one
		mov     ecx,esi           ;*** esi =2*index already
		shr     bx,cl
		and     bl,3

		.IF (BL == 3)
		    mov         edx,offset mesg_tag3

		.ELSEIF (BL == 2)
		    mov         edx,offset mesg_tag2

		.ELSE    ; floating point number dsiplay
			 ;
		    lea     eax,[ registers_save.fpu_envir.st0 + ESI*4+ESI]
		    mov     edx,Offset string_buffer
		    call    print_float2
		.ENDIF

		mov     ah,registers_color
		call    plot_string

        ;*** fill rest of line with blanks ***/

        pop edx
        push edx
        add edx,59
		sub edx,edi
        draw_horz ' ', DL


		pop edi
		add edi,ScreenWidth
		add ST_symbol_ptr, 6
		add esi,2
		cmp esi,16     ;ESI=2*index
		jb Plot_ST_loop

	    .ELSE
		; IF no 387 then print dummy message

		mov     edi, ScreenWidth*(ScreenHeight-8) + 6
		mov     ah,fpu_dummy_color
		mov     edx,Offset dummy_ST_reg
		call    plot_string
	    .ENDIF

	    ret


dummy_ST_reg      db  ' ............',10
		  db  '.   Floating  Point  Unit  not  available  . ',10
		  db  ' ... $'
mesg_tag3                 db  'Empty',25 dup(' '),'$'
mesg_tag2                 db  'NaN or infinity',15 dup(' '),'$'
Display_387_info ENDP


;
;
;
;       This will display all the debug register values and
;       the the R,W and LEN fields of each
;
;      Also displays the program segment Base & Limit fields
;
;
;   Expects :  Nothing
;
Display_DRx_info PROC  PRIVATE

    .if (bottom_window_FLAG != DRx_W)
	 call   clear_bottom_window
	     mov         bottom_window_FLAG,DRx_W
    .endif

	mov     ah,heading_color

    ;***** plot SEGMENT info ****
	mov     edi,(1 + ScreenWidth*(ScreenHeight-3) )
	mov     edx,offset seg_data_mesg1
	call    plot_string
    mov         ah,base_addr_color
    mov         ebx,Program_Addr
    mov         cl,8
    call        print_hex
    add         edi,4
	mov     ah,heading_color
	mov     edx,offset seg_data_mesg2
	call    plot_string
    mov         ah,base_addr_color
    mov         cx,cs
    lsl         ebx,ecx
    mov         cl,8
    call        print_hex

		mov     edi,(1 + ScreenWidth*(ScreenHeight-9) )
		mov     ah,heading_color
		mov     edx,offset HardwareBrkpts_mesg
		call    plot_string

		; display the break point regieters 
		mov     edi,(2 + ScreenWidth*(ScreenHeight-8) )
		mov     ah,registers_color
		draw_2char 'DR'
		draw_2char '0='
		mov     ebx,DR0
		mov     cl,0
		call    Plot_DR

		mov     edi,(2 + ScreenWidth*(ScreenHeight-7) )
		draw_2char 'DR'
		draw_2char '1='
		mov     ebx,DR1
		mov     cl,2
		call    Plot_DR


		mov     edi,(33 + ScreenWidth*(ScreenHeight-8) )
		draw_2char 'DR'
		draw_2char '2='
		mov     ebx,DR2
		mov     cl,4
		call    Plot_DR

		mov     edi,(33 + ScreenWidth*(ScreenHeight-7) )
		draw_2char 'DR'
		draw_2char '3='
		mov     ebx,DR3
		mov     cl,6
		call    Plot_DR

		mov     edi,(2 + ScreenWidth*(ScreenHeight-6) )
		draw_horz  ' ',58


				ret

Plot_DR PROC PRIVATE    ; sub proc for plotiing one DR reg 
		mov     ebp,DR7
		shr     ebp,cl
		push    ecx
		mov     cl,8
		call    print_hex
		pop     ecx
		test    ebp,00000003h   ; look at  Gi and Li bits
		jnz  @f
		     mov  edx,offset nul_DRx_measg
		     call  plot_string
		     ret
	  @@:   shr     ebp,cl
		draw_char  ' '
		draw_2char 'W='
		mov  bx,'0 '
		test    ebp,00010000h
		jz  @f
		 mov  bh,'1'
	   @@:  call  _draw_2char
		draw_2char 'R='
		mov  bx,'0 '
		test    ebp,00020000h
		jz  @f
		 mov  bh,'1'
	   @@:  call  _draw_2char
		draw_2char 'LE'
		draw_2char 'N='
		mov     ebx,ebp
		and     ebx,000C0000h
		rol     ebx,10
		mov     cl,1
		call    print_hex
		draw_char  ' '
		ret
Plot_DR ENDP


nul_DRx_measg   db ' disabled $'

HardwareBrkpts_mesg     db  '      80386  Linear Address Breakpoint Registers         $'

seg_data_mesg1 db 'program segment (CS);  base = $'
seg_data_mesg2 db 'size = $'

Display_DRx_info ENDP




;
; clear_bottom_window;
;
;    Clears the window for the debug registers and FPU registers
;
; No paramaters;
;
clear_bottom_window PROC PRIVATE
		pushad
		mov     edi,(1 + ScreenWidth*(ScreenHeight-9) )
	shl             edi,1
	add             edi,_0B8000h
	mov             ah,back_color
	mov             al,' '
	mov             bl,8
@@:             mov     ecx, 59
	push    edi
	rep             stosw
	pop             edi
	add             edi,ScreenWidth*2
	dec             bl
	jnz   @b
	popad
	ret
clear_bottom_window ENDP


;
;
;     checks Jump condition code tttn with current program flags
;
;   Expects :  AL = condition code
;   returns  ZF = 0 if condation fails
;            ZF = 1 if condation not fails
;
get_Jcc_condition PROC

		and al,00001111b
		or al,10010000b
		mov [set_instr+1],al
		jmp $+2
		jmp $+2
		jmp $+2
		jmp $+2
		jmp $+2
		jmp $+2
		jmp $+2
		jmp $+2
		jmp $+2
		mov      ah,BYTE PTR registers_save.prg_eflags
		sahf

set_instr   DB  0fh,?,11000000b                 ; SETccc EAX

		and    al,al
		ret 0
get_Jcc_condition ENDP


;
; removed user break point at location EAX
; returns ZF = 1    if removed
;         ZF = 0    if was not removed
;
remove_BreakPoint PROC USES EDI EAX ECX

	mov     ecx,Number_brkpts
	mov     edi,offset BreakPoint_EIP
    cld
	repne   scasd
	jne no_brkpt_
	   sub  edi,offset BreakPoint_EIP+4
	   shr  edi,2
	   mov   cl,BreakPoint_oldopcode[edi]            ; temperarly put
	   mov   [eax],cl                                ; in old intruction
       xor       eax,eax                                                                 ; set zero flag
no_brkpt_:
	ret
remove_BreakPoint        ENDP



;
;
;     This will update the registers log storage.
;
;   Expects :  Nothing
;
;
Update_register_LOG PROC  PRIVATE
	   ; copy all regs into back log 
	mov        edi,BacklogRegPTR_head
	add        edi,offset registers_saved_backlog
	mov        esi,offset registers_save
	mov        ecx,(SIZEOF program_reg ) /4
	rep        movsd

	mov        eax,BacklogRegPTR_head
	add        eax, SIZEOF program_reg
       .if       eax >= SIZEOF registers_saved_backlog
	     xor   eax,eax
       .endif
	mov        BacklogRegPTR_head,eax

	.if     BacklogRegPTR_tail  == EAX
		mov     eax,BacklogRegPTR_tail
		add     eax, SIZEOF program_reg
	       .if      eax >= SIZEOF registers_saved_backlog
		     xor   eax,eax
	       .endif
		mov        BacklogRegPTR_tail,eax
	.endif
	ret
Update_register_LOG     ENDP



;
;
;
;       This will display all the register values, flags and all the
; intructions on the screen  ( except segment and debug registers )
;
;
;
refresh_screen PROC PRIVATE

local   old_esi                         :dword
local   count1                          :dword
local   line_count                      :byte
local   current_instruc                 :byte
local   brkpt_flag                      :byte
local   InstCursor_flag                 :byte
Local   screen_ptr                              :dword
Local   displacment_dest_EIP    :long
Local   displacment_src_EIP     :long


	; print the nine registers on the screen 
	mov     edi,(ScreenWidth*1+66)
	xor     esi,esi
RegPrint_LOOP:
	mov     ebx,registers_save.prg_eax[esi*4]
	mov     ah,registers_color
	mov     edx,BacklogRegPTR_head
       .if     BacklogRegPTR_tail  != EDX
		sub     edx, SIZEOF program_reg
		jge @f
		mov edx,SIZEOF registers_saved_backlog - SIZEOF program_reg
	    @@:
		.if ( EBX != Dword PTR registers_saved_backlog[edx+esi*4] ) \
		     &&  ( ESI != 8 )
		  mov     ah,RegistersHiLight_color
		.endif
	.endif
	.if which_window == REGS_W
	    movzx   ecx,reg_selected
	   .if esi == ecx
	       mov ah,selected_color
	   .endif
	.endif
	mov     cl,8
	call    print_hexz
	inc     esi
	add     edi,80-8
	cmp     esi,9
	jb RegPrint_LOOP

	;***james: do not change the flag sequence! flag_map_table depends
	;          on this sequence!!!     
	; print the eight flags 
	_f_setcolor 0
	mov     edi,(ScreenWidth*1+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0000000000001b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 1
	mov     edi,(ScreenWidth*2+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0000001000000b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 2
	mov     edi,(ScreenWidth*3+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0000010000000b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 3
	mov     edi,(ScreenWidth*4+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0100000000000b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 4
	mov     edi,(ScreenWidth*5+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0000000000100b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 5
	mov     edi,(ScreenWidth*6+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0000000010000b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 6
	mov     edi,(ScreenWidth*7+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0001000000000b
	jz @f
	mov   al,'1'
@@:     call    _draw_char
	_f_setcolor 7
	mov     edi,(ScreenWidth*8+78)
	mov   al,'0'
	test  registers_save.prg_eflags,0010000000000b
	jz @f
	mov   al,'1'
@@:     call    _draw_char


	; plot the stack frame 
		mov     edi,(ScreenWidth*(ScreenHeight-16)+61)  ;***16 was 2
		; mov     esi,registers_save.prg_esp ***james
		mov     esi,Frame_Ptr
		push    es
		mov     bx,word ptr registers_save.prg_ss
		mov     es,bx
	       .IF    BX == _TEXT
		  mov  ebx,Program_Addr
		  mov Segment_Base,ebx
	       .ElseIF BX == Zero_sel
		  mov Segment_Base,0
	       .else
		  mov Segment_Base,0
	       .endif

stlplol:

		.if ( esi ==  registers_save.prg_esp)
			mov     edx,offset stk_ptrmesg
			call    plot_string
		.elseif ( esi ==  registers_save.prg_ebp)
			mov     edx,offset ebp_ptrmesg
			call    plot_string
		.else
			mov     edx,offset stk_blankit
			call    plot_string
		.endif


		mov     ah,registers_color

		mov     ecx,esi
		add     ecx,Segment_Base
		Call  Test_location           ; Test location DS:[ECX]
	       .If testing_EA_TEXT == TRUE
		  mov     ebx,es:[esi]
		  mov     cl,8
		  call    print_hex
		  mov testing_EA_TEXT,FALSE
		.Else
		  mov      edx,Offset Bad_stack_mesg
		  call     plot_string
		.Endif
		sub     edi,ScreenWidth+8+6
		add     esi,4
		cmp     edi,(ScreenWidth*16+67)
		jae stlplol
		pop     es

	; stack frame plotting finished 


;******************** plot the six Segment regsiters ***********************

		   mov     screen_ptr,(62 + ScreenWidth*10 )
		   mov     ah,registers_color
		   xor     esi,esi
plot_segloop:
		   add     screen_ptr, ScreenWidth
		   mov     edi,screen_ptr
		   ;***mov     i,2
		   mov     edx,2 ;***
	   plot_segloop01:
		   push    edx   ;***
		   mov     edx,offset ES_symb
		   add     edx,esi
		   call    plot_string
		   draw_char '='
		   mov     ebx,registers_save.prg_es[esi]
		   mov     cl,4
		   ror     ebx,16
		   call    print_hex
		   movzx   ecx,word ptr registers_save.prg_es[esi]
		   lsl     ebx,ecx
		   jz @f
		   sub  edi,4
		   mov  edx,offset nul_sel_measg
		   call  plot_string
	   @@:
		   add  esi,4
		   cmp  esi,4*6
		   pop  edx  ;***
		   jae  exit01
		   ;***dec  i
		   dec  edx  ;***
		   jz   plot_segloop
		   draw_2char '  '
		   jmp  plot_segloop01
exit01:

				 



;***james: plot the data window
	xor ebx,ebx
    mov ah,heading_color
       .if which_window == DATA_W    ;;if we are active, show actual address
		movzx ebx,data_selected
	    mov ah,DATA_offset_color
       .endif
	mov edi,(70+ ScreenWidth*36)  ;show off the address
	add ebx,Data_Offset
	mov cl,8
	call print_hex

	mov esi,Data_Offset
	mov edi,(61+ ScreenWidth*37)
	xor dl,dl   ;;dl = count of data

data_plot_loop:     ;;code from stack frame plot, modified
	mov     ecx,esi
	add     ecx,Program_Addr
	Call    Test_location           ; Test location DS:[ECX]
	push edi
	push esi
	.If testing_EA_TEXT == TRUE     ;we can read the char
	   mov     testing_EA_TEXT,FALSE
	   mov     ebx,[esi]
	   mov     ecx,4
	   mov     esi,edi
       @@:
	       push ecx
	       neg      ecx
	       add      ecx,4
	       _d_setcolor dl

	       lea      edi,[esi+ecx+4*3+1]  ;draw the chars
	       draw_char bl

	       lea      edi,[esi+ecx*2]      ;draw the hexes
	       add      edi,ecx
	       mov      cl,2
	       ror      ebx,8
	       call     print_hex

	       mov      ah,registers_color
	       draw_char ' '
	       pop      ecx
	       inc      dl
	   loop @b
	.Else                           ;we cannot read the char
	   mov ecx,4
	   mov esi,edi
	   add dl,4
       @@:
	      dec       dl
	      dec       ecx
	      _d_setcolor dl            ;draw the chars

	      lea       edi,[esi+ecx+4*3+1]
	      draw_char  '?'

	      lea       edi,[esi+ecx*2]
	      add       edi,ecx
	      draw_2char ''           ;draw the hexes
	      mov       ah,registers_color
	      draw_char ' '
	      inc       ecx
	   loop @b
	   add  dl,4
	.Endif
	pop esi
	pop edi
	add     esi,4
	add     edi,80
	cmp     edi,(ScreenWidth*(ScreenHeight-2)+61)
	jbe data_plot_loop
	mov     max_data_select,dl
;***

; plot the intructions 
; plot the intructions 
; plot the intructions 
; plot the intructions 
; plot the intructions 

Plot_The_Instructions:

    mov    eax , Program_BaseOffset
    .if  ( screen_EIP_value < EAX )
       mov  screen_EIP_value,eax
    .endif


    mov	current_memory_operand_address,-1
	mov     count1,0
    mov         displacment_src_EIP,-1
    mov         displacment_dest_EIP,-1
	mov     esi,screen_EIP_value
	mov     line_count,0
	mov     InstCursor_flag,FALSE

    mov         eax,esi
    mov     [old_esi],eax
	mov     brkpt_flag,FALSE
    call        remove_BreakPoint                       ; removes break point at EAX
    jne  @f
    mov    brkpt_flag,TRUE
@@:

back_more:

	.if selected_line > (ScreenHeight-12)
		   mov  selected_line,(ScreenHeight-12)
		   mov     edi,offset string_buffer
		   call    Decode_instruction
		   mov     screen_EIP_value,esi

	.elseif selected_line < 0
		     inc     selected_line
		     mov     edi,offset string_buffer
		     mov     old_esi,esi
		     mov cl,8
	    tryagn:
			 dec   cl
		     jz stptry
             mov    ebx , Program_BaseOffset
             cmp    screen_EIP_value , ebx
             je	stptry
		     dec    screen_EIP_value
		     mov    esi,screen_EIP_value
		     mov    edi,offset string_buffer
		     call   Decode_instruction
		     cmp    esi,old_esi
		     jne tryagn
	    stptry:
			 mov     esi,screen_EIP_value
		     jmp  back_more
	.endif


    ; Put back break point if is here
	.if   brkpt_flag  == TRUE
		mov     eax,old_esi
		mov     byte ptr [eax],0CCh
	.endif
; finished adjusting screen to display current EIP value within in it range 


       .if Step_flag == 1
		mov     eax,registers_save.prg_EIP
		.if   eax < esi
			mov  screen_EIP_value,eax
			mov  esi,eax
		.endif
		.if   eax > screen_ending_EIP
			mov  screen_EIP_value,eax
			mov  esi,eax
		.endif
		mov    selected_EIP,eax
       .endif




       ; decode current instruction to find jump displacment if any.
       ;
			push	esi
		    mov    	esi,registers_save.prg_EIP
		    mov    	edi,offset string_buffer
		    call   	Decode_instruction
            mov		esi,registers_save.prg_EIP
	       .if  (JMP_displacement != -1) && (JMP_displacement != ESI)

             ; ok instruction is a jump;  now see if its conditional
             ;

              mov         eax,[esi]
              and         al,11110000b
		     .IF (al == 01110000b )  ; is Jccc  short_disp ?
                mov   al,[esi]
                call  get_Jcc_condition
                jz Skip_jmpline
             .ENDIF
              mov         eax,[esi]
              and         eax,0F0FFh
			 .IF ( eax == 800Fh )  ; is Jccc  long_disp ?
                mov   al,[esi+1]
                call  get_Jcc_condition
                jz Skip_jmpline
             .ENDIF
             mov   al,[esi]
			 .IF ( AL == 11100001b )  	; is LoopZ ?
                mov   al, 0100b
                call  get_Jcc_condition
                jz Skip_jmpline
			 .ELSEIF ( AL == 11100000b )  	; is LoopNZ ?
                mov   al, 0101b
                call  get_Jcc_condition
                jz Skip_jmpline
			 .ELSEIF ( AL == 11100011b )  	; is JECXZ ?
                cmp  registers_save.prg_ecx,0
                jnz	Skip_jmpline
             .ENDIF
	          move		  displacment_dest_EIP, JMP_displacement
	          mov		  displacment_src_EIP ,ESI
 Skip_jmpline:
		   .endif
            pop		esi




mainloop:       ; MAIN  LOOP 

       mov      screen_ending_EIP,esi

       mov     ah,registers_color
      .if Step_flag == 1
		.if     registers_save.prg_EIP == esi
		   mov  al,line_count
		   mov  selected_line,al
		   or InstCursor_flag,TRUE
		   .if which_window == CODE_W
			mov ah,selected_color
		   .endif
		   mov  Step_flag,FALSE
		.endif
       .else
	       mov  al,selected_line
	       .if line_count == al
		   mov    selected_EIP,esi
		   or InstCursor_flag,TRUE
		   .if which_window == CODE_W
			mov ah,selected_color
		   .endif
	       .endif
       .endif


    ;
    ; if current selected instruction is on a break point then temperarily
    ; resore its origonal opcode so the instrcution can be decoded
	; and displayed.

	push    eax
	mov     brkpt_flag,FALSE
	mov     eax,ESI
    call        remove_BreakPoint                       ; removes break point at EAX
    pop         eax
    jne @f
	   mov     brkpt_flag,TRUE
	  .if ah == selected_color
	       mov   ah,selected_brkpt_color
	  .else
	       mov   ah,brkpt_color
	  .endif
@@:


   ; plot the line's instruction address left of screen
   ;
	push    eax
    .if  ah == registers_color
	    mov      ah,cs_eip_color
    .endif
	mov     edi,(ScreenWidth*1 +1 )
	add     edi,count1
	add     count1,ScreenWidth
	mov     ebx,esi
	mov     cl,8
	call    print_hex
    pop         eax

		  ;-- copy string buffer to screen 
		.if     registers_save.prg_EIP == esi
		    mov    bl,4
		    mov  al,INSTR_POINTER_CHAR
	       @@:  call  _draw_char
		    inc   al
		    dec   bl
		    jnz @b
		.else
		    draw_horz ' ',4
		.endif

	mov             old_esi ,esi
		; plot the instuction 
		push    edi
		mov     edi,offset string_buffer
		mov     ecx,edi
		call    Decode_instruction
		sub     ecx,edi
		neg     ecx
		pop     edi
	    xor   ebx,ebx
   @@:  mov   al,string_buffer[ebx]
	inc    ebx
	    call  _draw_char
	    dec    ecx
	    jnz @b

	mov             ecx,old_esi                     ; get old EIP value

	.if  (displacment_dest_EIP == ECX )
	    draw_horz ' ',5
	    draw_char  ARROWS_CHAR
			add     ebx,6
	    mov dx,''
			mov al,''
	.elseif  (displacment_src_EIP == ECX )
	    draw_horz ' ',6
	    draw_horz '',2
	    add ebx,8
	    mov dx,'ٿ'
			mov al,''
	.else
	    xor edx,edx
			mov al,' '
	.endif

		push  edx
	sub     ebx,46                              ; fill reset of line with spaces
	neg     ebx
	jle    @f
		draw_horz  al,bl
     @@:
	pop edx

		; plot the jmp to line   
	;
	mov      ecx, old_esi
		.if (edx)                                ; plot the ending characters
	   mov  ebx,displacment_src_EIP
	   .if (displacment_dest_EIP < EBX )
	     xchg dh,dl
	   .endif
		dec edi
	    draw_char dl

	.elseif ( (ECX > displacment_dest_EIP) && (ECX < displacment_src_EIP) ) \
			|| ( (ECX < displacment_dest_EIP) && (ECX > displacment_src_EIP) )
		dec edi
	    .if (line_count == 0) || (line_count >= CODE_WINDOW_HEIGHT-1)
		mov bx,(SUPERSCRIPT_CHAR + 14) + (SUPERSCRIPT_CHAR + 15)*256
	    .else
		    mov bx,''
	    .endif
	    .if (ECX < displacment_dest_EIP)
	      xchg bh,bl
	    .endif
	    mov      al,bl
	    call        _draw_char
	.endif



		; plot the effective address of the mod r/m field 
       .IF (AH == selected_brkpt_color) || (AH == selected_color)

		 or InstCursor_flag,TRUE
		 pushad
		 mov     edi,24
		.if MOD_RM_flag == TRUE
		  mov   ah,back_color
		  draw_horz '',35                              ; clear last MOD_RM address desiplay
		  mov     edi,24
		  mov     ah,back_color_EA
		  draw_char    ' '
		  mov   edx,op_seg_overide
		  .if edx == NULL
		    mov   edx,MOD_RM_DefaultSegmentReg
		  .endif
		  sub   edx,offset ES_symb
		  mov   ebx,ds:registers_save.prg_es[edx]
		  mov   cx,cs
		  .if   BX == CX
		     mov   ecx,Program_Addr
		  .elseif  BX == _TEXT
		     mov   ecx,Program_Addr
		  .elseif  BX == Zero_sel
		     xor        ecx,ecx
		  .else
		    add   edx,offset ES_symb
		    call  plot_string
		    mov edx,offset inv_sel_mesg
		    jmp inval_addre             ; invalid sel if
		  .endif
		  mov   Segment_Base,ecx
		  add   edx,offset ES_symb
		  call  plot_string

		  draw_2char    ':['
		  mov     ebx,MOD_RM_EffectiveAddress
		  mov   cl,8
		  call    print_hex
		  push ebx
		  draw_2char   '] '
		  draw_2char '= '
		  pop   ecx
		  add   ecx,Segment_Base
		  Call  Test_location           ; Test TWORD at linear addr ECX

		    .if  testing_EA_TEXT == TRUE
			   push     ebx
			   push     ecx
               push     MOD_RM_EffectiveAddress
	  		   pop		current_memory_operand_address
			   draw_char '0'
			  .if  MOD_RM_size == Far_mem48
			     mov    ebx,ecx
			     mov    cl,4
			     rol    ebx,16
			     call    print_hex
			    draw_char ':'
			  .endif
			   pop     ecx
			   pop     ebx
			  .if  (MOD_RM_size == Int_mem32) || (MOD_RM_size == Far_mem48)
			     mov   cl,8
			     call    print_hex

	      .elseif (MOD_RM_size == Int_mem64)
		 mov     cl,8
		 push    ebx
		 mov     ebx,ecx
		 call    print_hex
		 pop     ebx
		 mov     cl,8
		 call    print_hex

			  .elseif MOD_RM_size == Int_mem16
			     mov   cl,4
			     rol    ebx,16
			     call    print_hex

			  .else
			     mov   cl,2
			     rol    ebx,24
			     call    print_hex

			  .endif
			    mov     testing_EA_TEXT,FALSE
		    .else
		       mov	edx,offset inv_adr_mesg
inval_addre:        call    plot_string
		    .endif
		   draw_char ' '
		.else
		   mov   ah,back_color
		   draw_horz '',35
		.endif
		 popad

	.ENDIF


	 ; Put back break point if is here
	.if   brkpt_flag  == TRUE
		mov     eax,screen_ending_EIP
		mov     byte ptr [eax],0CCh
	.endif

	inc     line_count
	cmp     line_count,CODE_WINDOW_HEIGHT
	jb mainloop

     ; If the selected instruction was not displayed then
     ; replaot the screen with the selected instruction at the top.
     ;

	.If     InstCursor_flag == FALSE
	   mov     selected_line,0
	   mov     eax,registers_save.prg_EIP
	   mov     selected_EIP,eax
	   mov     screen_EIP_value,eax
	   jmp  Plot_The_Instructions
	.Endif


	ret

inv_adr_mesg      db  'illegal address$'
inv_sel_mesg      db  ':   illegal selector$'
Bad_stack_mesg    db  '$'
nul_sel_measg     db  'null$'

refresh_screen ENDP











;
;      ISR for terminate hooking  INT21h AH=4Ch
;
;  Used to trap any INT21h AH=4Ch. so can notify the user that the program
; has terminated
;
;
terminate_Hooker PROC PRIVATE
		 cli
	.IF ( ah == 4Ch ) && ( cs:InitDebugOnly == FALSE ) && (cs:DebuggerTerminated == FALSE)

		pushad
		push   es
		push   ds
		xor     eax,eax             ;disable debug registers
		mov     DR7,eax
		mov     ax,_TEXT
		mov     ds,ax
		mov     es,ax
		mov     users_screen_flag,FALSE
	       .If program_is_running
		 mov     users_screen_flag,TRUE
	       .Endif
		call    Debuggers_Video
		mov     edx,offset exit_code
		call    print_message_box
		pop     ds
		pop     es
		popad
		sub     dword ptr [esp],2
		jmp     Handle_Debug_Exception
       .ENDIF
	jmp     cs:saved_int21

exit_code       db  ' Program terminated with exit code INT 21h AH=4Ch $'
terminate_Hooker ENDP





;
;
;
;       PRINTS A MESSAGE IN THE SCREEN IN A BOX and waits for a key.
;Expects:
;              EDX = points to a string that ends with a '$'
;
;
; carage return characters 10 are allowed.
;
;
;
;
print_message_box       PROC PRIVATE
local height :byte
local lenth :byte
local   ok_pos:dword

		push    edx
		mov     height,6
		mov     lenth,0
	mov             cl,0
	mov             ok_pos,0
@@:     mov     al,[edx]
	add     edx,2
	cmp             al,0
	je      @b
	dec             edx
	.if    al == 10
		  add   height,2
	  add   ok_pos,ScreenWidth * 2
	  mov   cl,0
	.endif
	.if cl >  lenth
	  mov lenth,cl
	.endif
	inc             cl
	cmp   al,'$'
	jne  @b
		add             lenth,6
		movzx   edi,lenth
	sub             edi,ScreenWidth
	neg             edi
	shr             edi,1
		add     edi,ScreenWidth* (ScreenHeight/2 - 3)
		push    edi
		mov     ah,mesg_box_color
		push    edi
		add     edi,ScreenWidth
		draw_vert '',height
		pop     edi
		push    edi
		draw_char ''
		draw_horz '',lenth
		draw_char ''
		add     edi,ScreenWidth-1
		draw_vert '',height
		pop     edi
		add     edi,ScreenWidth+1
		mov     ch,height
@@:             push    edi
		draw_horz ' ',lenth
		pop     edi
		add     edi,ScreenWidth
		dec     ch
		jnz @b
		dec     edi
		draw_char ''
		draw_horz '',lenth
		draw_char ''
		pop     edi
		add     edi,ScreenWidth*3 + 3
		pop     edx
		mov     ah,mesg_box_text_color
	add             ok_pos,edi
		call    plot_string
	mov             edi,ok_pos
		add     edi,ScreenWidth*3
		movzx   eax,lenth
		shr     eax,1
		lea     edi,[edi+eax-3]
		mov     ah,(mesg_box_color and 0f0h) or 8
		mov     edx,offset mesg_OK_
		call    plot_string
		sub     edi,ScreenWidth+5
		mov     ah,0A1h
		mov     edx,offset mesg_OK
		call    plot_string
		mov     ah,(mesg_box_color and 0f0h) or 8
		draw_char ''

		mov     eax,Zero_addr   ; clear the keyboard buffer
		mov     dx,[eax+41ch]
		mov     [eax+41ah],dx
@@:
		in al,64h             ; Read key only when 8242 is ready
		test al,1
		jz @b
		in      al,60h          ; wait for enter key
		test    al,80h          ; see if was a release code
		jz  go_make
		INT 9                   ; Must send code to BIOS
		jmp @b
go_make:        sub     al,3Bh          ; loop if key was an Function key
		cmp     al,10
		jbe @b
		call    Debuggers_Video
		ret
mesg_OK db ' OK $'
mesg_OK_ db '$'
print_message_box       ENDP



;
; copy 8*8 font patters to video memory.
;
; ESI -> 8*8 font
; AL  = starting character
; AH  = number of characters to copy
;
;
copy_font_to_video PROC
    pushad
    cld
    movzx       edi,al
    shl         edi,5
	add     edi,_0B8000h
@@:
	test    ah,ah
    jz exit
	mov             ecx,8
	rep     movsb
    add         edi,32-8
    dec         ah
    jmp     @b
exit:
    popad
	ret
copy_font_to_video ENDP



;
;
;
;      SETS UP THE VIDEO SCREEN FOR THE DEBUGGER
;
;
;
Debuggers_Video PROC PRIVATE
	pushad


    .IF  users_screen_flag

	call    save_CompleteVideoState

	mov   ax,83h            ; Goto VGA Text Mode 80x25
	int     10h

	mov     bl,00h                 ;  Text Mode 80x50
	mov     ah,11h
	mov     al,012h
	int 10h

    .ENDIF





	; put in my man 
    ;      set up registers to accsess Bit plane 2 only
    ; set for sequentual memory addressing
	mov dx,3C4h ; sequencer reg group
	mov al,4
	mov ah,0111b
	out dx,ax

	mov dx,3ceh ; The Graphics Controller reg group
	mov al,6    ; Misellaneous Register
	mov ah,1100b
	out dx,ax

      ; set Map Mask Register
	mov dx,3c4h ; sequencer reg group
	mov al,2
	mov ah,0100b    ;to write to bit plane 2
	out dx,ax

       ; can now fill up the video font memory
	cld

	mov             esi,offset man_font
    mov         al,INSTR_POINTER_CHAR
    mov         ah,(man_font_SIZE / 8)
    call        copy_font_to_video

	mov             esi,offset superscript_font
    mov         al,SUPERSCRIPT_CHAR
    mov         ah,(superscript_font_SIZE / 8)
    call        copy_font_to_video

	mov             esi,offset arrows_font
    mov         al,ARROWS_CHAR
    mov         ah,(arrows_font_SIZE / 8)
    call        copy_font_to_video



    ; set for sequentual memory addressing
	mov dx,3C4h ; sequencer reg group
	mov al,4
	mov ah,0011b
	out dx,ax

	mov dx,3ceh ; The Graphics Controller reg group
	mov al,6    ; Misellaneous Register
	mov ah,1110b
	out dx,ax

      ; set Map Mask Register
	mov dx,3c4h ; sequencer reg group
	mov al,2
	mov ah,0011b    ;to write to bit plane 1+0
	out dx,ax

	; disable character blinking
	mov     dx,3DAh
	in      al,dx
	mov     dl,0C0h
	mov     al,10h or 20h
	out     dx,al
	inc     dl
	in      al,dx
	and      al,NOT 8
	dec     dl
	out     dx,al

	; turn off cursor 
	mov     dx,3D4h
	mov     ax,200Ah
	out     dx,ax



	; draw the screen 
	mov     edi,_0B8000h
	mov     ax,back_color*256
	mov     ecx, ScreenWidth * ScreenHeight
	cld
	rep     stosw

	mov     ah,boarder_color
	mov     edi,(0+ 80*1 )
	draw_vert  '',39
	draw_char  ''
	draw_horz  '',59
	draw_char  ''
	mov     edi,(0+ 80*0 )
	draw_char  ''
	draw_horz  '',59
	draw_char  ''
	draw_horz  '',13
	draw_char  ''
	draw_horz  '',4
	draw_char  ''
	mov     edi,(0+ 80*41 )
	draw_vert  '',8
	mov     edi,(60+ 80*41 )
	draw_vert  '',8
	mov     edi,(60+ 80*11 )
	draw_vert  '',29
	mov     edi,(60+ 80* 1 )
	draw_vert  '',9
	draw_char  ''
	draw_horz  '',13
	draw_char  ''
	draw_horz  '',4
	draw_char  ''
	mov     edi,(79+ 80*1  )
	draw_vert  '',9
	mov     edi,(79+ 80*11 )
	draw_vert  '',38
	mov     edi,(74+ 80*1  )
	draw_vert  '',9

	;***adam add
	mov     edi,(60+ ScreenWidth*14)
	draw_char  ''
	draw_horz  '',18
	draw_char  ''


	;***james add
	mov     edi,(60+ 80*35)
	draw_char  ''
	draw_horz  '',18
	draw_char  ''

	mov     edi,(61+ 80*36)
	mov     edx,offset dat_mesg
	call    plot_string
	;***



	mov     edi,(64+ ScreenWidth*15 )
	mov     edx,offset stk_mesg
	call    plot_string

    ;* plot integer register names *
	mov     edi,(80*1+62)
	mov     edx,offset EAX_symb
	mov     ah,registers_color
@@:     call    plot_string
	add     edi,80 - 3
	add     edx,1
	cmp     edx,offset EAX_symb+9*4
	jb  @b




	mov     ah,flag_registers_color
	mov     edi,(80*1+76)
	draw_2char  'c='          ; DRAW CARRY FLAG STATE 
	mov     edi,(80*2+76)
	draw_2char  'z='          ; DRAW ZERO  FLAG STATE 
	mov     edi,(80*3+76)
	draw_2char  's='          ; DRAW SIGN  FLAG STATE 
	mov     edi,(80*3+76)
	draw_2char  's='          ; DRAW SIGN  FLAG STATE 
	mov     edi,(80*4+76)
	draw_2char  'o='          ; DRAW OVERFLAW FLAG STATE 
	mov     edi,(80*5+76)
	draw_2char  'p='          ; DRAW PARITY FLAG STATE 
	mov     edi,(80*6+76)
	draw_2char  'a='          ; DRAW AUX FLAG STATE 
	mov     edi,(80*7+76)
	draw_2char  'i='          ; DRAW INTERRUPT FLAG STATE 
	mov     edi,(80*8+76)
	draw_2char  'd='          ; DRAW DIRECTION FLAG STATE 

	mov  users_screen_flag , FALSE
	popad
	ret
Debuggers_Video ENDP






;
;
;
;     THIS PROC TRAPS ANY VIDEO MODE CHANGING  BY THE PROGRAM
;    So we can keep track of the video state at all times
;
;
Video_mode_trap PROC PRIVATE
	pushfd
	push    ds
	push    es
	push    eax
	mov     ax,_TEXT
	mov     ds,ax
	mov     es,ax
	pop     eax
		cmp     byte ptr [esp+4*5],10h
		jne no_video_change
		cmp     ah,0
		jne no_video_change
		cmp     program_is_running, TRUE
		jne no_video_change
		 push 10h
		 pushfd
		 push cs
		 push offset JO99
		 jmp saved_INT32
	JO99:
		  call    save_CompleteVideoState

no_video_change:
	pop     es
	pop     ds
	popfd
	jmp cs:saved_INT32
Video_mode_trap ENDP





;
;
;  The debugger's low level keyboard handler ( for traping CTRL-BREAK )
;
;
keyboard_ISR PROC PRIVATE
	test    byte ptr [esp+4*2+2],10b    ; don't trap if was in V86 mode
	jnz    noPM
	push    ds
	push    es
	pushad
	mov     ax,_TEXT
	mov     ds,ax
	mov     es,ax

	in al,60h       ;get scan code from perifial port A

     .if program_is_running == TRUE

	.if scan_coden == 0
	    cmp  al,0e0h
	    jne no_break
	.elseif  scan_coden == 1
	    cmp  al,046h
	    jne no_break
	.elseif  scan_coden == 2
	    cmp  al,0e0h
	    jne no_break
	.elseif  scan_coden == 3
	    cmp  al,0c6h
	    jne no_break
		; set the ctrl-breaker 
		mov     al,20h               ; Send EOI cmd to 8259
		out     20h,al
		mov program_is_running , FALSE
		call    Debuggers_Video
		mov     edx,offset user_ctrl_breaked
		call    print_message_box
		popad
		pop     es
		pop     ds
		or      byte ptr [esp+4*2+1],1   ; set TF
		jmp    Handle_Debug_Exception
	.ENDIF
	 inc    scan_coden

   .ENDIF


noTrap:
	popad
	pop     es
	pop     ds
noPM:   jmp cs:saved_IRQ1

no_break:
	mov    scan_coden,0
	jmp noTrap

scan_coden      db 0
user_ctrl_breaked   db ' Program Stoped with CTRL-BREAK  $'

keyboard_ISR ENDP

;
;
;    Floating Point Error Exception Handler.
;
;
;
;
DEVICE_Unavailable_Exception                            PROC PRIVATE

		push    edx
		mov     edx,offset bad_fpu_mesg
		jmp     Close_the_fatal_falt

bad_fpu_mesg db 'Device Not Available  exception (7) $'


DEVICE_Unavailable_Exception                                                    ENDP

;
;
;    Floating Point Error Exception Handler. (exception #16)
;
;
;
;
FPU_Exception                                           PROC PRIVATE
	.IF ( FPU_installed )
	push    eax
	xor             eax,eax
	fstsw   ax
		test    al,80h                  ; test Error Summary Status
		pop             eax
	jz              EXIT_INT
		push    edx                                                                     ; save EDX
		mov     edx,offset fpu_mesg
		jmp   Close_the_fatal_falt
    .ENDIF

EXIT_INT:
	jmp  cs:Old_IntVect16


fpu_mesg db  '  Floating Point Exception (16)$'

FPU_Exception                                                                                   ENDP



;
;
;    This is the INT 3 breakpoint exception handler.
;
; caused from opcode CCh
;
;
BreakPoint_Exception                                    PROC PRIVATE
	push    ds
	pushad
	mov     ax,_TEXT
	mov     ds,ax

	mov     eax,Zero_addr   ; clear the keyboard buffer
	mov     dx,[eax+41ch]
	mov     [eax+41ah],dx

	 cmp    special_brkpt,TRUE
	 je     special_CCh
nospecial_CCh:
	mov     eax,[esp+4*9]           ; get EIP from stack
	push    es
	push    ds
	pop     es
	dec     eax

    call        remove_BreakPoint                       ; removes break point at EAX
	pop     es
	jne  not_a_brkpt

	dec    dword ptr [esp+4*9]        ; decreament  EIP on stack

	.if  program_is_running == TRUE
	   popad
	   pop     ds
	   or      byte ptr [esp+4*2+1],1   ; set Trap Flag on stack
	   jmp   Handle_Debug_Exception
	.else
	   popad
	   pop     ds
	   iretd                          ; set to debugging mode (again)
	.endif


not_a_brkpt:    ;
	cmp     byte ptr [eax],0CCh
	je     normal_CCh
	dec     eax
	cmp     word ptr [eax],03cdh
	je      normal_INT_3
	popad
	pop     ds
	iretd



normal_CCh:
	.if  program_is_running == TRUE
	   sub   dword ptr [esp+4*9],1       ; decreament  EIP on stack
	   jmp exit
	.endif
	jmp exit


normal_INT_3:
	.if  program_is_running == TRUE
	   sub   dword ptr [esp+4*9],2       ; decreament  EIP on stack
	   jmp exit
	.endif
	 popad
	 pop     ds
	 iretd

special_CCh:
	 mov     ebx,dword ptr [esp+4*9]      ; look to see if on a special
	 dec    ebx
	 mov     eax,special_brkpt_EIP
	 cmp    ebx,eax
	 jne   nospecial_CCh
	 mov    special_brkpt,FALSE
	 dec     dword ptr [esp+4*9]
	 mov     dl,special_brkpt_save
	 mov     [eax],dl                ; delete the 0CCh

exit:
	   popad
	   pop     ds
	   or      byte ptr [esp+4*2+1],1   ; set Trap Flag on stack
	   jmp   Handle_Debug_Exception


BreakPoint_Exception    ENDP






;
;
;    The General Protection handler  ( Interrupt 13 )
;
;
;
GeneralProtection_Exception               PROC PRIVATE


   ; Read the ISR (Interrupt Service Register) to see if a IRQ is waiting
   ; to be serviced.
   ;
	push   eax
	mov     al,00001011b    ; OCW3 to read ISR on next read
	out     20h,al          ; write to base I/O address of 8259A
	in      al,20h          ; read ISR
	and     al,al
	pop     eax
	jz    non_V86_exec        ; Brach if a IRQs is not awaiting
	jmp  cs:Old_IntVect13

non_V86_exec:
	add     esp,4
	push    edx
	mov     edx,offset GP_mesg
	jmp   Close_the_fatal_falt

align 4

GP_mesg         db  'Instruction Caused a General Protection Exception $'

GeneralProtection_Exception  endp

;
;
;    The Invalid Opcode handler  ( Interrupt 6 )
;
;
;
InvalidOpcode_Exception                                     PROC PRIVATE
	push    edx
	mov     edx,offset badI_mesg
	jmp   Close_the_fatal_falt

badI_mesg db  'Program executed an Invalid Opcode $'

InvalidOpcode_Exception    ENDP

;
;
;    The Divide by Zero handler  ( Interrupt 0 )
;
;
;
DivideError_Exception                                     PROC PRIVATE
	push    edx                                                                     ; save EDX
	mov     edx,offset divide0_mesg
	jmp   Close_the_fatal_falt

divide0_mesg db  '  Division By Zero Error$'


DivideError_Exception    ENDP

;
;
;    The Page Fault handler  ( Interrupt 14 )
;
;
;
PageFalts_Exception                                     PROC PRIVATE


   ; Read the ISR (Interrupt Service Register) to see if a IRQ is waiting
   ; to be serviced for VCPI server.
   ;
	push   eax
	mov     al,00001011b    ; OCW3 to read ISR on next read
	out     20h,al          ; write to base I/O address of 8259A
	in      al,20h          ; read ISR
	and     al,al
	pop     eax
	jz    skip_8259pf        ; Brach if a IRQs is not awaiting
	jmp  cs:Old_IntVect14

skip_8259pf:

	add     esp,4
	 .IF  cs:testing_EA_TEXT == TRUE
	    push  ds
	    push  dword ptr _TEXT
	    pop   ds
	    mov   testing_EA_TEXT,FALSE
	    pop   ds
	    add   dword ptr [esp],tea_ins_size ; skip intruction that caused
	    iretd
	 .ENDIF
	push    edx
	mov     edx,offset PF_mesg
	jmp   Close_the_fatal_falt

PF_mesg         db  'Instruction caused a Page Falt $'

PageFalts_Exception    ENDP


;
;

; This rotine displays the  exception error message and stuff
; Used by the above CPU exception routines

;
Close_the_fatal_falt PROC PRIVATE
	push    ds
	push    es
	pushad
	mov     ax,_TEXT
	mov     ds,ax
	mov     es,ax

	xor     eax,eax                         ;disable debug registers
	mov     DR7,eax
	mov     eax,[esp+4*11]          ; get EIP from stack
	mov     Step_flag,TRUE
	mov     selected_EIP,eax
	mov     screen_EIP_value,eax
	mov     registers_save.prg_EIP,eax
	mov     registers_save.prg_cs,cs
	cld
	push    edx
	call    Debuggers_Video
	call    refresh_screen
	pop     edx
	call    print_message_box
	popad
	pop     es
	pop     ds
	pop     edx
	or      byte ptr [esp+4*2+1],1          ; set Trap Flag on stack
	jmp   Handle_Debug_Exception          ; set to debugging mode (again)
Close_the_fatal_falt ENDP



hardwareInstruc_mesg   db ' Instruction Fault on Breakpoint Register '
DRx_mesg1        db '    $'
hardwareData_mesg   db '  Data Trap on Breakpoint Register '
DRx_mesg2        db '    $'






;
;
;     THE MAIN  DEBUG EXCEPTION HANDLER     ( INTERRUPT ONE )
;
;
;
Debug_Exception PROC PRIVATE
	pushad
	push    ds
	push    es
	mov     ax,_TEXT
	mov     ds,ax
	mov     es,ax
	 .IF  cs:testing_EA_TEXT == TRUE
	    mov   testing_EA_TEXT,FALSE
	    pop     es
	    pop     ds
	    popad
	    iretd               ; return  to intruction on in EA test mode
	 .ENDIF

	;  GET DEBUG EXCEPTION STATUS from DR6 
		mov     eax,DR6
		mov     ebx,DR7
		mov     DRx_mesg1,'0'
		mov     DRx_mesg2,'0'
		test    al,1
		jz brkpt1
		 test  bl,3
		 jz brkpt1
		 shr    ebx,16
		 jmp found_brkptReg

brkpt1:         mov     DRx_mesg1,'1'
		mov     DRx_mesg2,'1'
		test    al,2
		jz brkpt2
		 test  bl,0ch
		 jz brkpt2
		 shr    ebx,20
		 jmp found_brkptReg

brkpt2:         mov     DRx_mesg1,'2'
		mov     DRx_mesg2,'2'
		test    al,4
		jz brkpt3
		  test  bl,030h
		 jz brkpt3
		 shr    ebx,24
		 jmp found_brkptReg

brkpt3:         mov     DRx_mesg1,'3'
		mov     DRx_mesg2,'3'
		test    al,8
		jz no_brkpt
		  test  bl,0c0h
		  jz no_brkpt
		  shr    ebx,28
found_brkptReg:
		test     bl,03
		jz  RW0
		push     offset hardwareData_mesg
		jmp RW1
       RW0:     push    offset hardwareInstruc_mesg
       RW1:     call    Debuggers_Video
		mov     eax,[esp+4*11]                  ; get EIP form stack
		mov     selected_EIP,eax
		mov     Step_flag,TRUE
		mov     registers_save.prg_EIP,eax
		call    refresh_screen
		pop     edx
		call    print_message_box
		or      dword ptr [esp+4*12],010100h    ; Set the TF and RF
		jmp Step_debug


no_brkpt:
	test    eax,4000h
	jz   normal_INT1


Step_debug:
		xor     eax,eax
		mov     DR6,eax         ; must clear the DR6 bits
normal_INT1:    pop     es
		pop     ds
		popad
		jmp Handle_Debug_Exception

Debug_Exception ENDP

;
;
;     THE GENARAL DEBUG EXCEPTION HANDLER for exceptions from  breakpoints
; , TF or  any breakpoint registers.
;
;   This is the main routine of the whole debugger.
;
;
Handle_Debug_Exception PROC PRIVATE
	push    ds
	push    dword ptr _TEXT
	pop     ds
	pop     registers_save.prg_ds
	pop     registers_save.prg_EIP
	pop     registers_save.prg_cs
	pop     registers_save.prg_eflags

	mov     registers_save.prg_eax, eax
	mov     registers_save.prg_ebx, ebx
	mov     registers_save.prg_ecx, ecx
	mov     registers_save.prg_edx, edx
	mov     registers_save.prg_edi, edi
	mov     registers_save.prg_esi, esi
	mov     registers_save.prg_ebp, ebp
	mov     registers_save.prg_esp, esp
	mov     registers_save.prg_ss , ss
	mov     registers_save.prg_es , es
	mov     registers_save.prg_fs , fs
	mov     registers_save.prg_gs , gs
	pushad
	push    fs
	push    es
	push    ds                         ; Load ES with data selector
	pop     es
	cld

	.IF ( FPU_installed )
	fsave   registers_save.fpu_envir                ; save 108 bytes
    .ENDIF

;

	mov     program_is_running,FALSE

	.if haveOrigonalRegisters == FALSE
		mov     edi,offset origonal_registers
		mov     esi,offset registers_save
		mov     ecx,(SIZEOF registers_save)/4
		rep     movsd
		mov     haveOrigonalRegisters,TRUE
	.endif

	mov     eax,registers_save.prg_EIP
	mov     selected_EIP,eax
	mov     Step_flag,TRUE

	;***
	.if Keep_Frame_Ptr == FALSE
	   mov     eax,registers_save.prg_esp
	   mov     Frame_Ptr,eax
	.elseif
	   mov     Keep_Frame_Ptr,FALSE
	.endif
	;***

	.if  users_screen_flag  == TRUE
	   call    Debuggers_Video
	.endif


       .if InitDebugOnly == TRUE
	 mov    edx,offset intro_mesg
	 call   print_message_box
	 mov    InitDebugOnly,FALSE
      .endif


main_loop:


	call    refresh_screen

	;***james add
	cmp Until_Here,0
	jnz Run_Until_Here  ;enter our state machine
	;***

	;***james: modified for window system
key_waitloop:

		test    Key_flags,CTL       ; look at CTL flag
		jz      @@no_ctrl
		call    Display_DRx_info

		movzx   edx,which_window
		mov     edx,[Menu_ctrl_bar+edx*4]
		jmp     disp_menu_bar

@@no_ctrl:
		call    Display_387_info
		test    Key_flags,ALT       ; look at ALT flag
		jz      @@no_alt

		movzx   edx,which_window
		mov     edx,[Menu_alt_bar+edx*4]
		jmp     disp_menu_bar

@@no_alt:
		test    Key_flags,SHF       ; look at SHiFt flag
		jz      @@no_shift

		movzx   edx,which_window
		mov     edx,[Menu_shift_bar+edx*4]
		jmp     disp_menu_bar

@@no_shift:
		movzx   edx,which_window
		mov     edx,[Menu_bar+edx*4]

disp_menu_bar:
		mov     edi,(0 + 80*49 )
		mov     ah,menu_color
		call    plot_string
skip_disp:



;

@@:     in      al,64h
	test    al,1
	jz      @b
	in      al,60h




	 ;***james: modi
	.if     al == 38h                         ; set for 'Alt'
		or  Key_flags,ALT
	.elseif al == 38h or 80h
		and Key_flags,Not ALT             ; clear 'Alt'

	.elseif al == 1Dh                         ; set for 'Ctrl'
		or Key_flags,CTL
		INT 9
	.elseif al == 1Dh or 80h
		and Key_flags,Not CTL             ; clear 'Ctrl'
		INT 9

	.elseif (prev_key_code != 0E0h)
	     .if (al == 2Ah) || (al == 36h)        ; set for 'Shift'
		  or Key_flags,SHF
	     .elseif (al == (2Ah or 80h)) || (al == (36h or 80h))
		  and Key_flags,Not SHF             ; clear 'Shift'
	     .endif
	.endif
	;***

    ; if ALT+CRL then turn off key repeat rate
    ;
		mov  fast_scroll,TRUE


	Mov     prev_key_code,al

	       push   eax
	       in al,61h                ; (pulse PPI port B bit 1
	       or al,80h       ;set bit 7   ; to acknoledge the keyboard)
	       out 61,al
	       and al,7fh      ;clear bit 7
	       out 61h,al
	       pop   eax

	test    al,80h
	jnz key_waitloop
	mov     ah,al

	mov     al,Key_flags

	;***james: new dispatcher
	movzx   ebx,which_window
	mov     ebx,[Cmd_Tables+ebx*4]
	xor     edx,edx
@@:
	.repeat
	    mov    cx,[ebx].tbl_mask
	    not    cx
	    and    cx,ax

	   .if     cx == [ebx].tbl_key
		jmp [ebx].tbl_addr      ;ax = key, cx=masked key
	   .else
		add ebx,size tbl
	   .endif
	.until [ebx].tbl_key == 0

       .if edx == 0
	  mov ebx,offset Shared_Table
	  inc edx
	  jmp @b               ;;try again for shared cmd table
       .endif
	jmp main_loop
	;***

;;command tables for main_loop
tbl struc
  tbl_key  dw 0  ;;key to match
  tbl_addr dd 0  ;;addr to jump
  tbl_mask dw 0  ;;ignore these bits, if on
tbl ends

Cmd_Tables label ptr
   dd Code_Table
   dd Reg_Table
   dd Flag_Table
   dd Data_Table

Shared_Table label ptr             ;;shared by all windows
   tbl <ALT+F4,back_step,CTL>
   tbl <ALT+F5,user_screen,CTL>
   tbl <ALT+X_KEY,exit_debugger,CTL>
   tbl <F7,step_intruc,CTL>
   tbl <F8,large_steping,CTL>
   tbl <F9,run_program,CTL>
   tbl <CTL+F2,goto_start,ALT>
   tbl <SHF+CSR_UP,data_scroll_up>
   tbl <SHF+CSR_DN,data_scroll_dn>
   tbl <SHF+PGUP,data_pgup>
   tbl <SHF+PGDN,data_pgdn>
   tbl <ALT+KEYPAD_PLUS,Frame_Down>
   tbl <ALT+KEYPAD_MINUS,Frame_Up>
   tbl <ALT+KEYPAD_STAR,Frame_ESP>
   tbl <ALT+KEYPAD_SLASH,Frame_EBP>
   tbl <0,0,0>

Code_Table label tbl
   tbl <TAB_KEY,move_to_regs,CTL>
   tbl <SHF+TAB_KEY,move_to_data,CTL>
   tbl <SHF+CSR_RGT,move_to_regs>         ;;alternate
   tbl <SHF+CSR_LFT,move_to_data>         ;;alternate
   tbl <SHF+SPACE_KEY,set_data_memoprerand>
   tbl <CSR_UP,sel_up>
   tbl <CSR_DN,sel_dn>
   tbl <PGDN,page_Down>
   tbl <PGUP,page_Up>
   tbl <F2,set_brkpt>
   tbl <F4,Run_Until_Here>
   tbl <CTL+N_KEY,here>
   tbl <CTL+O_KEY,show_current_inst>
   tbl <NUM_0,chg_code_offset,CTL>
   tbl <NUM_1,chg_code_offset,CTL>
   tbl <NUM_2,chg_code_offset,CTL>
   tbl <NUM_3,chg_code_offset,CTL>
   tbl <NUM_4,chg_code_offset,CTL>
   tbl <NUM_5,chg_code_offset,CTL>
   tbl <NUM_6,chg_code_offset,CTL>
   tbl <NUM_7,chg_code_offset,CTL>
   tbl <NUM_8,chg_code_offset,CTL>
   tbl <NUM_9,chg_code_offset,CTL>
   tbl <A_KEY,chg_code_offset,CTL>
   tbl <B_KEY,chg_code_offset,CTL>
   tbl <C_KEY,chg_code_offset,CTL>
   tbl <D_KEY,chg_code_offset,CTL>
   tbl <E_KEY,chg_code_offset,CTL>
   tbl <F_KEY,chg_code_offset,CTL>
;*   tbl <BS_KEY,chg_code_offset_del,CTL>     removed by Adam ?
   tbl <KEYPAD_PLUS,inc_code_offset,CTL+SHF>
   tbl <KEYPAD_MINUS,dec_code_offset,CTL+SHF>
   tbl <0,0,0>

Reg_Table  label tbl
   tbl <TAB_KEY,move_to_flag,CTL>
   tbl <SHF+TAB_KEY,move_to_code,CTL>
   tbl <SHF+CSR_RGT,move_to_flag>         ;;alternate
   tbl <SHF+CSR_LFT,move_to_code>         ;;alternate
   tbl <CSR_UP,reg_up>
   tbl <CSR_DN,reg_dn>
   tbl <NUM_0,chg_reg,SHF>
   tbl <NUM_1,chg_reg,SHF>
   tbl <NUM_2,chg_reg,SHF>
   tbl <NUM_3,chg_reg,SHF>
   tbl <NUM_4,chg_reg,SHF>
   tbl <NUM_5,chg_reg,SHF>
   tbl <NUM_6,chg_reg,SHF>
   tbl <NUM_7,chg_reg,SHF>
   tbl <NUM_8,chg_reg,SHF>
   tbl <NUM_9,chg_reg,SHF>
   tbl <A_KEY,chg_reg,SHF>
   tbl <B_KEY,chg_reg,SHF>
   tbl <C_KEY,chg_reg,SHF>
   tbl <D_KEY,chg_reg,SHF>
   tbl <E_KEY,chg_reg,SHF>
   tbl <F_KEY,chg_reg,SHF>
   tbl <BS_KEY,chg_reg_del,SHF>
   tbl <KEYPAD_PLUS,inc_reg,SHF+CTL>
   tbl <KEYPAD_MINUS,dec_reg,SHF+CTL>
   tbl <0,0,0>

Flag_Table label tbl
   tbl <TAB_KEY,move_to_data,CTL>
   tbl <SHF+TAB_KEY,move_to_regs,CTL>
   tbl <SHF+CSR_RGT,move_to_data>         ;;alternate
   tbl <SHF+CSR_LFT,move_to_regs>         ;;alternate
   tbl <CSR_UP,flag_up>
   tbl <CSR_DN,flag_dn>
   tbl <SPACE_KEY,toggle_flag>
   tbl <ENTER_KEY,toggle_flag>
   tbl <NUM_0,reset_flag>
   tbl <NUM_1,set_flag>
   tbl <0,0,0>

Data_Table label tbl
   tbl <TAB_KEY,move_to_code,CTL>
   tbl <SHF+TAB_KEY,move_to_flag,CTL>
   tbl <SHF+CSR_RGT,move_to_code>         ;;alternate
   tbl <SHF+CSR_LFT,move_to_flag>         ;;alternate
   tbl <CSR_UP,data_up>
   tbl <CSR_DN,data_dn>
   tbl <CSR_LFT,data_left>
   tbl <CSR_RGT,data_right>
   tbl <PGDN,data_pgdn>
   tbl <PGUP,data_pgup>
   tbl <NUM_0,chg_data,SHF+CTL>
   tbl <NUM_1,chg_data,SHF+CTL>
   tbl <NUM_2,chg_data,SHF+CTL>
   tbl <NUM_3,chg_data,SHF+CTL>
   tbl <NUM_4,chg_data,SHF+CTL>
   tbl <NUM_5,chg_data,SHF+CTL>
   tbl <NUM_6,chg_data,SHF+CTL>
   tbl <NUM_7,chg_data,SHF+CTL>
   tbl <NUM_8,chg_data,SHF+CTL>
   tbl <NUM_9,chg_data,SHF+CTL>
   tbl <A_KEY,chg_data,SHF+CTL>
   tbl <B_KEY,chg_data,SHF+CTL>
   tbl <C_KEY,chg_data,SHF+CTL>
   tbl <D_KEY,chg_data,SHF+CTL>
   tbl <E_KEY,chg_data,SHF+CTL>
   tbl <F_KEY,chg_data,SHF+CTL>
   tbl <CTL+BS_KEY,chg_data_del,SHF>
   tbl <KEYPAD_PLUS,inc_data,SHF+CTL>
   tbl <KEYPAD_MINUS,dec_data,SHF+CTL>
   tbl <0,0,0>

;; Code Window Management 

continue_debugging:


	.IF ( FPU_installed )
	frstor  registers_save.fpu_envir                ; load 108 bytes
    .ENDIF
	pop     es
	pop     fs
	popad
	mov     ds,registers_save.prg_ds
	push    cs:registers_save.prg_eflags
	push    cs:registers_save.prg_cs
	push    cs:registers_save.prg_EIP
	iretd



;
sel_up:
  dec   selected_line
  jmp   main_loop

;
sel_dn:
  inc   selected_line
  jmp   main_loop

;
page_Up:
	 sub    selected_line,(ScreenHeight-10)
	 jmp main_loop

;
page_Down:
	mov     eax,screen_ending_EIP
	mov     screen_EIP_value,eax
	jmp main_loop


;
set_data_memoprerand:

	mov     eax,current_memory_operand_address
    cmp 	eax,-1
    je @f
	mov     Data_Offset,eax
@@:
	jmp main_loop



;
large_steping:
	mov     eax,registers_save.prg_EIP
    call        remove_BreakPoint                       ; removes break point at EAX

    call    CheckVGAport

	mov     esi,eax
	mov     edi,offset string_buffer
	call    Decode_instruction
	cmp     dword ptr string_buffer,06c6c6163h       ; look for "call"
	je  skip_small_step
	cmp     dword ptr string_buffer,0706f6f6ch       ; look for "loop"
	je  skip_small_step
	and     dword ptr string_buffer,0ffffffh
	cmp     dword ptr string_buffer,00706572h       ; look for "rep"
	jne  step_intruc

 skip_small_step:
		  mov     special_brkpt_EIP,esi
		  mov     dl,[esi]
		  mov     special_brkpt_save,dl
		  mov     byte ptr [esi],0CCh          ; insert the CC
		  mov     special_brkpt,TRUE
		  mov     program_is_running,TRUE
		  call    Restore_Video            ; goto users screen
		  and      registers_save.prg_eflags,not 00100000000b
		  mov        BacklogRegPTR_head,0         ; clear backlog
		  mov        BacklogRegPTR_tail,0
		  jmp continue_debugging




;
step_intruc:
	call    Update_register_LOG

	mov     eax,registers_save.prg_EIP
    call        remove_BreakPoint                       ; removes break point at EAX

	call  CheckVGAport

   ; if an INT n instruction then insert special break point
   ; except if INT 21h AH=4Ch then don't insert a special break point;
   ;
   ; otherwise simply jmp to continue_debugging
   ;

	.if   (byte ptr [eax] == 0CDh)  && (  (byte ptr [eax+1] != 21h) || (byte ptr [registers_save.prg_eax+1] != 04Ch)  )
	  lea esi,[eax + 2]
	  jmp   skip_small_step
     .endif
      jmp continue_debugging




;
run_program:
	mov        BacklogRegPTR_head,0         ; clear backlog
	mov        BacklogRegPTR_tail,0
	call    Restore_Video
	mov     eax,registers_save.prg_EIP
	mov     ecx,Number_brkpts
	mov     edi,offset BreakPoint_EIP
	repne scasd
	je continue_debugging   ; don't run a debugger break point
	.if    byte ptr [eax] == 0CCh       ; don't run a users break point
	    inc  registers_save.prg_EIP
	.elseif word ptr [eax] == 03CDh
	    add  registers_save.prg_EIP,2
	.endif
	mov     program_is_running,TRUE
	and      registers_save.prg_eflags,not 00100000000b
	jmp continue_debugging



;
exit_debugger:
	xor     eax,eax             ;disable debug registers
	mov     DR7,eax

	call  Restore_Video      ; Goto normal users mode on exit

	mov     ah,03              ;- Restore keyboard typmatic rate
	mov     al,05h
	mov     bl,Kbd_Rate             ; Rate  (0..1fh)
	mov     bh,Kbd_Delay            ; Delay (0..3)
	cmp     bl,-1
	je @f
	int     16h
@@:

    ;
    ; Restore a few interrupt handlers
    ;
	    mov         edx,dword ptr Old_IntVect7
	    mov         cx,word ptr Old_IntVect7[4]
	    mov         bl,7
	    call        SetIntVector
	    mov         edx,dword ptr Old_IntVect16
	    mov         cx,word ptr Old_IntVect16[4]
	    mov         bl,16
	    call        SetIntVector
	    mov         edx,dword ptr Old_IntVect14
	    mov         cx,word ptr Old_IntVect14[4]
	    mov         bl,14
	    call        SetIntVector
	    mov         edx,dword ptr Old_IntVect13
	    mov         cx,word ptr Old_IntVect13[4]
	    mov         bl,13
	    call        SetIntVector

   ;
   ; restore fpu emulation flag to origonal state
   ;
	smsw    ax
    and         al, NOT 4
    .if  (fpu_emulation_flag == TRUE )
	or              al, 4
    .endif
	lmsw    ax

	mov     DebuggerTerminated,TRUE         ; let int 21h handler know were are
										; really terminating
	mov     ax,4C00h
	int     21h                  ; Terminate to Operating system


;
user_screen:
	call    Restore_Video

@@:
		in al,64h             ; Read key only when 8242 is ready
		test al,1
		jz @b
		in      al,60h          ; wait for enter key
	       .if     al == 38h                       ; set for 'Alt'
		  or  Key_flags,1
	       .elseif al == 38h or 80h
		  and Key_flags,Not 1             ; clear 'Alt'
	       .endif
		test    al,80h          ; loop if release code
		jnz  @b
	call    Debuggers_Video
	jmp main_loop


here:
	mov     eax,selected_EIP
	mov     registers_save.prg_EIP,eax
	jmp     main_loop

goto_start:
	call    Debuggers_Video
	mov        BacklogRegPTR_head,0
	mov        BacklogRegPTR_tail,0
	mov        Step_flag,TRUE
	.if haveOrigonalRegisters == TRUE
		mov     esi,offset origonal_registers
		mov     edi,offset registers_save
		mov     ecx,(SIZEOF registers_save)/4
		rep     movsd
	.endif

	;***james: ensure selected line is put at top.
	mov     selected_line,0
	mov     eax,registers_save.prg_EIP
	mov     selected_EIP,eax
	mov     screen_EIP_value,eax
	;***

	call    refresh_screen
	jmp    load_all_regs


;*** james addition
Run_Until_Here:
	cmp Until_Here,0
	jz  ruh_begin
	cmp Until_Here,1
	jz  ruh_run
	cmp Until_Here,2
	jz  ruh_end

ruh_begin:
	mov eax,selected_EIP
	cmp eax,registers_save.prg_EIP
	je  main_loop       ; cannot do anything if same already

	mov Until_Here_EIP,eax
	mov Until_Here,1
	jmp set_brkpt

ruh_run:
	mov Until_Here,2
	jmp run_program

ruh_end:
	mov Until_Here,0
	mov eax,Until_Here_EIP
	mov selected_EIP,eax
	jmp set_brkpt

show_current_inst:
	mov     selected_line,0
	mov     eax,registers_save.prg_EIP
	mov     selected_EIP,eax
	mov     screen_EIP_value,eax
	jmp main_loop


move_to_code:
	mov which_window,CODE_W
	jmp main_loop

chg_code_offset:
	call _scan2hex
	test al,CTL
	jz   main_loop         ;;disable this test if non-CTL op is ok

	mov   selected_line,0
	ror   ecx,4
	mov   ebx,selected_EIP
	shld  ebx,ecx,4
	mov   selected_EIP,ebx
	mov   screen_EIP_value,ebx
	jmp   main_loop

;*  removed
;chg_code_offset_del:
;       mov   selected_line,0
;       mov   ebx,selected_EIP
;       shr   ebx,4
;       mov   selected_EIP,ebx
;       mov   screen_EIP_value,ebx
;       jmp   main_loop

dec_code_offset:
	mov     eax,-1
    jmp @f

inc_code_offset:
	mov     eax,+1
@@:
;       mov   selected_line,0      ;;* enable this if we want to start
;       mov   ebx,selected_EIP     ;;  counting from selected_line
	mov     ebx,screen_EIP_value ;;  instead of screen_EIP_value

	add   ebx,eax
    .if (ebx==-1)       ; if new EIP value wraps around then force to zero
       xor  ebx,ebx
    .endif
	mov   selected_EIP,ebx
	mov   screen_EIP_value,ebx
	jmp   main_loop


;***

; The Break Point mangaging routine 
;                          F2 key
set_brkpt:
	mov     eax,selected_EIP
	mov     ecx,Number_brkpts
	mov     edi,offset BreakPoint_EIP
	repne scasd
	je  Deleate_brkpt
	mov     eax,-1
	mov     ecx,Number_brkpts
	mov     edi,offset BreakPoint_EIP
	repne scasd
	je insert_a_brkpt

	    ; show that no more break points can be used
		mov     edx,offset brkpts_are_full_mesg
		call    print_message_box
		jmp main_loop

brkpts_are_full_mesg db 'No more than ',Number_brkpts_string,' Breakpoints can be assigned $'



Deleate_brkpt:
		sub     edi,offset BreakPoint_EIP+4

		; take away the break point 
		mov     BreakPoint_EIP[edi],-1
		shr     edi,2
		mov     dl,BreakPoint_oldopcode[edi]
		mov     eax,selected_EIP
		mov     [eax],dl        ; restore byte in the instruction
		jmp main_loop




insert_a_brkpt:
	sub     edi,offset BreakPoint_EIP+4
	mov     eax,selected_EIP
	mov     dx,[eax]                ; save byte in the instruction
	cmp     dl,0cch    ; not allowed to put brk pts on top of brk pts
	je stupid_person
	cmp     dx,03CDh
	je stupid_person
	mov     BreakPoint_EIP[edi],eax
	shr     edi,2
	mov     BreakPoint_oldopcode[edi],dl
	mov     byte ptr [eax],0CCH            ; but in a INT 3

	jmp main_loop

stupid_person:
	mov     edx,offset mesg_1234
	call    print_message_box
	jmp main_loop
mesg_1234       db 'Are you stupid?  You can''t put a Breakpoint on a Breakpoint $'






;
back_step:
	mov     eax,BacklogRegPTR_head
	.if     BacklogRegPTR_tail  != EAX
		sub     eax, SIZEOF program_reg
		jge @f
		 mov eax,SIZEOF registers_saved_backlog - SIZEOF program_reg
	    @@: mov        BacklogRegPTR_head,eax

		; copy all regs into back log 
		mov        esi,BacklogRegPTR_head
		mov        BacklogRegPTR_head,eax
		add        esi,offset registers_saved_backlog
		mov        edi,offset registers_save
		mov        ecx,(SIZEOF program_reg ) /4
		rep        movsd
	.else
		jmp main_loop
	.endif

	pop     es
	pop     fs
	popad
    jmp         load_all_regs


load_all_regs PROC PRIVATE
	.IF ( FPU_installed )
	frstor  registers_save.fpu_envir                ; load 108 bytes
    .ENDIF
	mov     eax,registers_save.prg_eax
	mov     ebx,registers_save.prg_ebx
	mov     ecx,registers_save.prg_ecx
	mov     edx,registers_save.prg_edx
	mov     edi,registers_save.prg_edi
	mov     esi,registers_save.prg_esi
	mov     ebp,registers_save.prg_ebp
	mov     esp,registers_save.prg_esp
	mov     ss,registers_save.prg_ss
	mov     es,registers_save.prg_es
	mov     fs,registers_save.prg_fs
	mov     gs,registers_save.prg_gs

	mov     ds,registers_save.prg_ds
	push    cs:registers_save.prg_eflags
	push    cs:registers_save.prg_cs
	push    cs:registers_save.prg_EIP
	jmp     Handle_Debug_Exception

    ;
    ; note: its safe to recursivly call the Handle_Debug_Exception procedure
    ; without poping the saved registers becase we are restoring the
    ; oringal stack pointer, esp.


load_all_regs ENDP




;; Register Window Management 
reg_up:
	.if reg_selected == 0
	    mov reg_selected,8
	.else
	    dec reg_selected
	.endif
	jmp     main_loop

reg_dn:
	.if reg_selected == 8
	    mov reg_selected,0
	.else
	    inc reg_selected
	.endif
	jmp     main_loop

chg_reg:
	call _scan2hex
	test al,SHF       ;;disable this if non-shift operation is ok
	jz   main_loop
	movzx ebx,reg_selected
	ror ecx,4
	shld registers_save.prg_eax[ebx*4],ecx,4
	mov Keep_Frame_Ptr,TRUE
	jmp load_all_regs

chg_reg_del:
	test al,SHF       ;;disable this if non-shift operation is ok
	jz   main_loop
	movzx ebx,reg_selected
	shr registers_save.prg_eax[ebx*4],4
	mov Keep_Frame_Ptr,TRUE
	jmp load_all_regs

inc_reg:
	;;test al,SHF       ;;enable this if non-shift operation is a must
	;;jz   main_loop
	movzx ebx,reg_selected
	inc registers_save.prg_eax[ebx*4]
	mov Keep_Frame_Ptr,TRUE
	jmp load_all_regs

dec_reg:
	;;test al,SHF       ;;enable this if shift operation is a must
	;;jz   main_loop
	movzx ebx,reg_selected
	dec registers_save.prg_eax[ebx*4]
	mov Keep_Frame_Ptr,TRUE
	jmp load_all_regs

move_to_regs:
	mov     which_window,REGS_W
	jmp     main_loop

;; Stack Frame Window Management 

Frame_Up:
	add Frame_Ptr,4
	jmp main_loop

Frame_Down:
	sub Frame_Ptr,4
	jmp main_loop

Frame_ESP :
	mov eax,registers_save.prg_esp
	mov Frame_Ptr,eax
	jmp main_loop

Frame_EBP:
	mov eax,registers_save.prg_ebp
	mov Frame_Ptr,eax
	jmp main_loop

;; Flag Window Management 
flag_up:
	.if flag_selected == 0 
	    mov flag_selected,7
	.else
	    dec flag_selected
	.endif
	jmp     main_loop

flag_dn:
	.if flag_selected == 7
	    mov flag_selected,0
	.else
	    inc flag_selected
	.endif
	jmp     main_loop

flag_map_table label word
   dw   0000000000001b,0000001000000b,0000010000000b,0100000000000b
   dw   0000000000100b,0000000010000b,0001000000000b,0010000000000b

toggle_flag:
   movzx esi,flag_selected
   movzx eax,flag_map_table[esi*2]
   xor   registers_save.prg_eflags,eax
   jmp  main_loop

set_flag:
   movzx esi,flag_selected
   movzx eax,flag_map_table[esi*2]
   or    registers_save.prg_eflags,eax
   jmp  main_loop

reset_flag:
   movzx esi,flag_selected
   movzx eax,flag_map_table[esi*2]
   not   eax
   and   registers_save.prg_eflags,eax
   jmp  main_loop

move_to_flag:
   mov  which_window,FLAG_W
   jmp  main_loop

;; Data Window Management 
move_to_data:
	mov     which_window,DATA_W
	jmp     main_loop

data_scroll_up:
	sub     Data_Offset,4
	jmp     main_loop

data_scroll_dn:
	add     Data_Offset,4
	jmp     main_loop

data_pgup:
	sub     Data_Offset,30h
	jmp     main_loop

data_pgdn:
	add     Data_Offset,30h
	jmp     main_loop


data_up:
	mov     bl,4
	jmp     short data_upleft
data_left:
	mov     bl,1
data_upleft:
	sub     data_selected,bl
	jns     main_loop
	add     data_selected,4
	sub     Data_Offset,4
	jmp     main_loop

data_dn:
	mov     bl,4
	jmp     short data_dnright
data_right:
	mov     bl,1
data_dnright:
	mov     al,data_selected
	add     al,bl
       .if al >= max_data_select
	  sub al,4
	  add Data_Offset,4
       .endif
	mov     data_selected,al
	jmp     main_loop

chg_data:
	call _scan2hex
	test al,CTL
	jnz  chg_Data_Offset

	test al,SHF            ;;disable this test if non-shift op is ok
	jnz  chg_data_value
	jmp  main_loop

chg_data_value:
	movzx   esi,data_selected
	add     esi,Data_Offset
	mov     al,cl

	mov     ecx,esi
	add     ecx,Program_Addr
	Call    Test_location           ; Test location DS:[ECX]
	.If testing_EA_TEXT == TRUE     ;we can read the char
	   mov     testing_EA_TEXT,FALSE
	   shl     byte ptr [esi],4
	   or      byte ptr [esi],al
	.endif
	jmp     main_loop

chg_Data_Offset:
	ror ecx,4
	movzx ebx,data_selected
	add   ebx,Data_Offset
	shld  ebx,ecx,4
	mov   Data_Offset,ebx
	mov   data_selected,0
	jmp main_loop

chg_data_del:
	movzx ebx,data_selected
	add   ebx,Data_Offset
	shr   ebx,4
	mov   Data_Offset,ebx
	mov   data_selected,0
	jmp   main_loop

dec_data:
	mov @@_inc_opcode1,0EFEh  ;;dec byte ptr [esi]
	mov @@_inc_opcode2,0DFFh  ;;dec [mem]
	jmp short inc_dec_data    ;;flush pipeline
inc_data:
	mov @@_inc_opcode1,06FEh  ;;inc byte ptr [esi]
	mov @@_inc_opcode2,05FFh  ;;inc [mem]
	jmp short inc_dec_data    ;;flush pipeline
inc_dec_data:
	test al,CTL
	jnz  inc_Data_Offset

	;;test al,SHF            ;;enable this test if shift op is a must
	;;jnz  inc_data_value
	;;jmp  main_loop

inc_data_value:
	movzx   esi,data_selected
	add     esi,Data_Offset

	mov     ecx,esi
	add     ecx,Program_Addr
	Call    Test_location           ; Test location DS:[ECX]
	.If testing_EA_TEXT == TRUE     ;we can read the char
	   mov     testing_EA_TEXT,FALSE
@@_inc_opcode1 label word
	   inc     byte ptr [esi]
	   ;dec     byte ptr [esi]
	.endif
	jmp     main_loop

inc_Data_Offset:
@@_inc_opcode2 label word
	inc Data_Offset
	;dec Data_Offset
	jmp main_loop



Handle_Debug_Exception ENDP







END





















