#include <conio.h>	/* for getch() */
#include <stdio.h>      /* for standard I/O */

#include "tgdlp4.h"     /* don't forget to include tgdlp4sc.obj in your project */
#include "tgdsupp.h"    /* don't forget to include tgdsuppc.obj in your project */

#define ERR_NO 0
#define ERR_BADVGA 1

main()
{ ubyte colors[]={ 0,0,0, 48,48,48, 0,0,48, 48,0,0 };
  word polygon1[]={ 0,256, 255,256, 128,383 };
  word polygon2[]={ 0,511, 255,511, 128,384 };

  /* initialize graphics driver */
  if (vgalp4()) { printf("?No VGA card or VGA card with less than 256KB installed\n"); return(ERR_BADVGA); };

  /* set new screenmode (why not 256x256?) */
  waittof(); screenmode(SM_256x256);

  /* set the colors after a waittof() to prevent snow on the screen */
  waittof(); rgb6(0,3,colors);

  /* clear the screen using color 2: 0,0,48 = blue */
  pen(PEN_B,2); clearreg();

  /* displayed area is (0,256)-(255,511) of the virtual screen
   * draw two polygons in it.
   */
  pen(PEN_F,3); drawpoly(3,polygon1); drawpoly(3,polygon2);

  /* finally, print some text */
  /* BM_SOLID prints the text with bg color 0, fg color 1 */
  bltmode(BM_SOLID);
  txtcrsr(0,504);
  prttext("Hello world... Press a key!     ");

  /* wait for a key */
  if (!getch()) getch();

  /* switch back to text mode */
  co80();

  return(ERR_NO);
}
