/**********************************************

	VGA Routines for TextMode V0.2
	Copyright Reglage (C) 1994

	No BIOS Call Guaranteed! :-)

	VGA_T.c

**********************************************/

#include "VGA.h"
#include "VGA_T.h"

UBYTE far * T_bscreen=(UBYTE far *) 0xb8000000;
UWORD far * T_screen=(UWORD far *) 0xb8000000;
UWORD T_attr=15<<8;
UBYTE T_width=80;
UWORD T_offset=0;

UBYTE	*hexbyte="0123456789ABCDEF";

UBYTE T_ColTable[16]={	0x00,0x01,0x02,0x03,
								0x04,0x05,0x14,0x07,
								0x38,0x39,0x3a,0x3b,
								0x3c,0x3d,0x3e,0x3f
							};


/**********************************************

	Set Screen Start in Memory (Offset)

**********************************************/

void T_ScreenOffset(UWORD ByteOffset)
{
	T_offset=ByteOffset;
	asm{
//		cli;

		mov	dx,0x3d4;
		mov	bx,ByteOffset;
		mov	ah,bh;
		mov	al,0x0c;		//	Register 0Ch, Startaddress High
		out	dx,ax;

		mov	ah,bl;
		inc	al;			//	Register 0Dh, Startaddress Low
		out	dx,ax;

//		sti;
	}
}


/**********************************************

	Set Number of Columns on Screen

	(Virtual Number of Bytes / Scanline)

**********************************************/

void T_ScreenWidth(UBYTE width)
{
	T_width=width;
	asm{
		mov	ah,width;
		shr	ah,1;
		mov	al,0x13;
		mov	dx,0x3d4;
		out	dx,ax;
	}
}

/**********************************************

	Set Horizontal PEL Panning Register

	>Text mode: no more than 1 character!

**********************************************/

void T_HorizontalFine(UBYTE X)
{
	V_HorizontalFine(X);
}

/**********************************************

	Set Palette Color at Index Col

**********************************************/

void T_SetPal(UBYTE Col, struct Palette *Pal)
{
	V_SetPal(T_ColTable[Col],Pal->R,Pal->G,Pal->B);
}


/**********************************************

	Get Palette Color at Index Col

**********************************************/

void T_GetPal(UBYTE Col, struct Palette *Pal)
{
	V_GetPal(T_ColTable[Col],&Pal->R,&Pal->G,&Pal->B);
}


/**********************************************

	Set Cursor Type	0: Invisible
							1:	Full
							2:	Normal

	Change to NO BIOS CALL!
	Let the BIOS library do it's stuff.

**********************************************/

void T_SetCursor(UBYTE type)
{
	UBYTE cstart, cend;

	switch(type)
	{
		case 0:	cstart=0x20;	cend=0;	break;
		case 1:	cstart=0;		cend=7;	break;
		case 2:	cstart=6;		cend=7;	break;
	}

	asm{
		mov	ch,cstart;
		mov	cl,cend;
		mov	ah,1;
		int	0x10;
	}
}


/**********************************************

	Set Cursor Position

	Bug: Does not work with T_width other than 80!
	Correction: Use VGA ports to change address pointer for Cursor! :)

**********************************************/

void T_SetCursorPos(UBYTE x,UBYTE y)
{
/*	asm{						//	VGA BIOS Version :-)
		mov	ah,0x02;
		mov	bh,0x00;
		mov	dl,x;
		mov	dh,y;
		int	0x10;
	}
*/
	UWORD	total;

	total=x+y*T_width;	//	Calculate Address for Cursor

	asm{
		mov	dx,0x3d4;	//	Port 0x3d4
		mov	bx,total;
		mov	ah,bh;
		mov	al,0x0e;		//	index 0x0e: Upper 8 bits of CursorAddr
		out	dx,ax;
		mov	ah,bl;
		mov	al,0x0f;		//	index 0x0f:	Lower 8 bits of CursorAddr
		out	dx,ax;
	}
}

/**********************************************

	Get Cursor Position

**********************************************/

void T_GetCursorPos(UBYTE *x,UBYTE *y)
{
	UWORD	total;

	asm{
		mov	dx,0x3d4;
		mov	al,0x0e;
		out	dx,al;
		in		al,dx;
		mov	bh,al;

		mov	al,0x0f;
		out	dx,al;
		in		al,dx;
		mov	bl,al;

		mov	total,bx;
	}
	*y=total/T_width;
	*x=total%T_width;
}


/**********************************************

	Set Height of Characters (0-0x1f)

**********************************************/

void T_CharHeight(UBYTE height)
{
	asm{
		mov	dx,0x3d4;	//	Inport 0x3d4 index 0x09 ( ->al )
		mov	al,0x09;
		out	dx,al
		in		al,dx;

		and	al,0xe0;		//	Mask necessary bits
		or		al,height;	//	Or the height bits
		xchg	al,ah;
		mov	al,0x09;		//	Output to 0x3d4 index 0x09 ( <-ah )
		out	dx,ax;
	}
}


/**********************************************

	Clears _ALL_ Text Screens

**********************************************/

void T_ClearScreen(UWORD attri)
{
	UWORD i=0;

	T_attr=attri<<8;
	while(i<0x7fff)
	{
		T_screen[i]=T_attr;
		i++;
	}
}


/**********************************************

	Outputs a Character at X/Y (should be inline :-( )

**********************************************/

void T_CharXY(UBYTE tkn,UBYTE x,UBYTE y)
{
	T_screen[x+y*T_width]=T_attr+tkn;
}


/**********************************************

	Get Attribute at X/Y

**********************************************/

UWORD T_GetAttr(UBYTE x,UBYTE y)
{
	return T_screen[x+y*T_width]&0xff00;
}


/**********************************************

	Draw Box at X1/Y1-X2/Y2 with Style:
											0:	Single
											1:	Double

**********************************************/

void T_DrawBox(UBYTE x1,UBYTE y1,UBYTE x2,UBYTE y2,UBYTE style)
{
	UBYTE i;

	UWORD far *scr1;
	UWORD far *scr2;
	UWORD temp;

	UWORD ly1=y1*T_width;
	UWORD ly2=y2*T_width;

	T_screen[x1+ly1]=(style?'':'')+T_attr;
	T_screen[x2+ly1]=(style?'':'')+T_attr;
	T_screen[x1+ly2]=(style?'':'')+T_attr;
	T_screen[x2+ly2]=(style?'':'')+T_attr;

	scr1=T_screen+ly1;
	scr2=T_screen+ly2;
	temp=(style?'':'')+T_attr;
	for(i=x1+1;i<x2;i++)
	{
		scr1[i]=temp;
		scr2[i]=temp;
	}
	temp=(style?'':'')+T_attr;
	for(i=y1+1;i<y2;i++)
	{
		T_screen[x1+i*T_width]=temp;
		T_screen[x2+i*T_width]=temp;
	}
}


/**********************************************

	Draw Filled Box at X1/Y1-X2/Y2 with Style:
													0:	Single
													1:	Double

**********************************************/

void T_FillBox(UBYTE x1,UBYTE y1,UBYTE x2,UBYTE y2,UBYTE style,UBYTE fillchar)
{
	UBYTE i,y;

	UWORD far *scr1;
	UWORD temp;
	UWORD fc=fillchar+T_attr;

	UWORD ly1=y1*T_width;
	UWORD ly2=y2*T_width;

	T_screen[x1+ly1]=(style?'':'')+T_attr;	//	Line 1
	scr1=T_screen+ly1;
	temp=(style?'':'')+T_attr;
	for(i=x1+1;i<x2;i++)
		scr1[i]=temp;
	T_screen[x2+ly1]=(style?'':'')+T_attr;

	temp=(style?'':'')+T_attr;					//	Lines... |---|
	for(y=y1+1;y<y2;y++)
	{
		scr1=T_screen+y*T_width;
		scr1[x1]=temp;
		for(i=x1+1;i<x2;i++)
			scr1[i]=fc;
		scr1[i]=temp;
	}

	T_screen[x1+ly2]=(style?'':'')+T_attr;	//	Last line
	scr1=T_screen+ly2;
	temp=(style?'':'')+T_attr;
	for(i=x1+1;i<x2;i++)
		scr1[i]=temp;
	T_screen[x2+ly2]=(style?'':'')+T_attr;
}


/**********************************************

	Fill Box at X1/Y1-X2/Y2 with T_attr

**********************************************/

void T_AttrBox(UBYTE x1,UBYTE y1,UBYTE x2,UBYTE y2)
{
	UBYTE far *scr;
	UWORD x,y,lx1,lx2;
	UBYTE attri=T_attr>>8;

	lx1=x1*2+1;
	lx2=x2*2+2;
	for(y=y1;y<=y2;y++)
	{
		scr=T_bscreen+y*T_width*2;
		for(x=lx1;x<lx2;x+=2)
			scr[x]=attri;
	}
}


/**********************************************

	Writes string at X/Y

**********************************************/

void T_String(UBYTE x,UBYTE y,char *string)
{
	UWORD i;
	UWORD far *scr=T_screen+y*T_width+x;

	i=0;
	while(string[i])
	{
		scr[i]=string[i]+T_attr;
		i++;
	}
}


/**********************************************

	Display Byte as HEX at X/Y with mode: (see code)

**********************************************/

void T_OutByte(UBYTE x,UBYTE y,UBYTE byt,UBYTE mode)
{
	UWORD far *scr=&T_screen[y*T_width+x];

	if(!byt&&mode)		//	Mode 1 should draw '--' if byt==zero
	{
		scr[0]='-'+T_attr;
		scr[1]='-'+T_attr;
	}
	else
	{
		scr[0]=hexbyte[(byt&0xf0)>>4]+T_attr;
		scr[1]=hexbyte[byt&0x0f]+T_attr;
	}
}
