/**********************************************

	Example #01 for the Reglage VGA-Library

		TEXT MODE
		Palette Experimenting

	V1.0 - Reglage (C) 1994

**********************************************/

#include "Keyb.h"
#include "VGA.h"
#include "VGA_T.h"


/**********************************************

	main() ... Just a little test!

**********************************************/

int main(void)
{
	struct Palette OldPalette[16];
	struct Palette NewPalette[16]=
	{
		{ 0x00,0x00,0x00 },
		{ 0x08,0x00,0x1c },
		{ 0x00,0x1c,0x08 },
		{ 0x08,0x18,0x1c },
		{ 0x20,0x00,0x00 },
		{ 0x1c,0x04,0x1c },
		{ 0x20,0x14,0x18 },
		{ 0x1a,0x1a,0x1a },
		{ 0x0e,0x0e,0x0e },
		{ 0x08,0x18,0x3f },
		{ 0x00,0x3a,0x00 },
		{ 0x00,0x3a,0x3a },
		{ 0x3a,0x00,0x00 },
		{ 0x3f,0x00,0x30 },
		{ 0x3f,0x38,0x10 },
		{ 0x3f,0x3f,0x3f }
	};

	UWORD i,x,y;

	V_SetMode(3);						// Set TextMode 80X25

	for(i=0;i<16;i++)
	{
		T_GetPal(i,&OldPalette[i]);//	Store Old Palette
		T_SetPal(i,&NewPalette[i]);//	Setup New Palette
	}

	T_SetCursor(0);					//	Set Cursor Invisible

	for(y=0;y<8;y++)					//	Output Color Table
		for(x=0;x<16;x++)
		{
			T_attr=(x<<8)+(y<<12);				//	Set Attribute
			T_OutByte(x*2+25,y+5,x+y*16,0);	//	Write Attribute #
		}

	T_attr=0x1e00;						//	Set Nice Attribute Color
											//	and Write Nice Text
	T_String(22,0," Copyright (C) 1994 Reglage Software ");

	T_attr=0x8c00;						//	Flash text...
	T_String(32,16,"Press the ANY Key");

	K_EatKbHit();						//	Eat Keypress
	while(K_KbHit());					//	Wait for Keypress
	K_EatKbHit();						//	Eat Keypress

	T_String(32,16,"                 ");
	for(i=0;i<16;i++)
	{
		T_SetPal(i,&OldPalette[i]);//	Restore Original Palette
	}

	T_SetCursor(2);					//	Restore Cursor
	T_SetCursorPos(0,16);			//	Set New Cursor Position

	return 0;
}
