
/************************************************************************
**                                                                     **
**  Mouse Routines for Borland C/C++ V3.0 written by Patrik Wallstrom  **
**                                                                     **
**  Only TEXT Mode supported so far... (But try graphics though...)    **
**                                                                     **
**  Rewritten 13/2-94 using inline assembler instead of DOS.H...       **
**  Rewritten 26/7-94 using new 'standardized' function names... :-)   **
**  Rewritten 26/7-94 - Comments                                       **
**                                                                     **
************************************************************************/


#include "mouse.h"


/**********************************************

	Initialize Mouse

**********************************************/

UWORD M_Init(void)
{
	asm	xor	ax,ax;
	asm	int	MOUSE;

	return _AX;
}


/**********************************************

	Reset Mouse

**********************************************/

UWORD M_Reset(void)
{
	asm	mov	ax,0x21;
	asm	int	MOUSE;

	return _AX;
}


/**********************************************

	Display Mouse Pointer

**********************************************/

void M_Display(void)
{
	asm	mov	ax,0x01;
	asm	int	MOUSE;
}


/**********************************************

	Hide Mouse Pointer

**********************************************/

void M_Hide(void)
{
	asm	mov	ax,0x02;
	asm	int	MOUSE;
}


/**********************************************

	Read Mouse Pointer X/Y Position

**********************************************/

UWORD M_ReadXY(UWORD *_MouseX, UWORD *_MouseY)
{
	asm	mov	ax,0x03;
	asm	int	MOUSE;

//	asm	mov	*_MouseX,cx;
//	asm	mov	*_MouseY,dx;

	*_MouseX=_CX;
	*_MouseY=_DX;

	return _BX;
}


/**********************************************

	Set Mouse Pointer X/Y Position

**********************************************/

void M_SetXY(UWORD _MouseX, UWORD _MouseY)
{
	asm	mov	ax,0x04;
	asm	mov	cx,_MouseX;
	asm	mov	dx,_MouseY;
	asm	int	MOUSE;
}


/**********************************************

	Limit Mouse Pointer Movement

**********************************************/

void M_LimitXY(UWORD _MouseX1, UWORD _MouseY1, UWORD _MouseX2, UWORD _MouseY2)
{
	asm	mov	ax,0x07
	asm	mov	cx,_MouseX1;
	asm	mov	dx,_MouseX2;
	asm	int	MOUSE;

	asm	mov	ax,0x08;
	asm	mov	cx,_MouseY1;
	asm	mov	dx,_MouseY2;
	asm	int	MOUSE;
}


/**********************************************

	Set double speed threshold

**********************************************/

void M_Threshold(UWORD _MouseXX)
{
	asm	mov	ax,0x13;
	asm	mov	dx,_MouseXX;
	asm	int	MOUSE;
}


/**********************************************

	Set Mouse Sensitivity

**********************************************/

void M_Sensitivity(UWORD _MouseX,UWORD _MouseY)
{
	asm	mov	ax,0x0f;
	asm	mov	cx,_MouseX;
	asm	mov	dx,_MouseY;
	asm	int	MOUSE;
}
