/* joinspr.c - join two sprite files
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

/*
** The first file you give is put in the outout file before the second.
**
*/

#include <stdio.h>
#include <unistd.h>


int main(int argc, char *argv[])
{
  FILE *f1,*f2,*out;
  int i,j;
  unsigned short n1,n2,total;
  unsigned char w,h;

  if(argc!=4){
	      printf("joinspr - join two sprite files together.\n");
	      printf("Usage: joinspr <infile1> <infile 2> <outfile> \n");
	      printf("Where: <infile1>  = 1st file to get sprites from (include extn)\n");
	      printf("       <infile2>  = 2nd file to get sprites from (include extn)\n");
	      printf("       <outfile>  = file to put output into (include .SPR extn)\n");
	      exit(-1);
  }

  if((f1=fopen(argv[1],"rb"))==NULL){
     printf(" ERROR: Could not open file %s for reading.",argv[1]);
     exit(-1);
  }

  if((f2=fopen(argv[2],"rb"))==NULL){
     printf(" ERROR: Could not open file %s for reading.",argv[2]);
     exit(-1);
  }

  if((out=fopen(argv[3],"wb"))==NULL){
     printf(" ERROR: Could not open file %s for writing.",argv[2]);
     exit(-1);
  }

  
  /* get number of sprites in each file */
  fread(&n1,sizeof(unsigned short),1,f1);
  fread(&n2,sizeof(unsigned short),1,f2);

  total = n1+n2;

  fwrite(&total,sizeof(unsigned short),1,out);


  /* copy out first sprite file */
  for(i=0;i<n1;i++){
      w=fgetc(f1);
      h=fgetc(f1);

      fputc(w,out);
      fputc(h,out);
      
      for(j=0;j<w*h;j++){
	  fputc(fgetc(f1),out);
      }

      w=fgetc(f1); /* no of bounding rects */
      fputc(w,out);

      for(j=0;j<w;j++){
	  fputc(fgetc(f1),out);   /* write each rectangle out */
	  fputc(fgetc(f1),out);
	  fputc(fgetc(f1),out);
	  fputc(fgetc(f1),out);
      }

  }

  /* copy out second */
  for(i=0;i<n2;i++){
      w=fgetc(f2);
      h=fgetc(f2);

      fputc(w,out);
      fputc(h,out);
      
      for(j=0;j<w*h;j++){
	  fputc(fgetc(f2),out);
      }

      w=fgetc(f2); /* no of bounding rects */
      fputc(w,out);

      for(j=0;j<w;j++){
	  fputc(fgetc(f2),out);   /* write each rectangle out */
	  fputc(fgetc(f2),out);
	  fputc(fgetc(f2),out);
	  fputc(fgetc(f2),out);
      }

  }

  /* close 'em and go */
  fclose(f1);
  fclose(f2);
  fclose(out);

  return (0);      
}
