/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

#include <stdlib.h>
#include <grx20.h>
#include <jlib.h>

static int __jlib_previous_mode;  /* holds previous mode */

/* define this here to save us including old compatable header */
#define make_fake_context(w,h,mem,where) (                                        \
    GrCreateFrameContext(                                                       \
	GR_frameRAM8,                                                      \
	(w),(h),                                                \
	(char **)0                                                      \
	,                                                              \
	(where)                                                         \
    )                                                                           \
)

/* set mode and initialise fake context */
int screen_set_video_mode(void)
{
 int i;

 __jlib_previous_mode = GrCurrentMode(); /* save current mode */


 if(GrSetMode(GR_width_height_color_graphics,SCREEN_WIDTH,SCREEN_HEIGHT,SCREEN_NUM_COLORS)==0){
    return 0;
 }

  __jlib_planesize  = GrFramePlaneSize(GR_frameRAM8,SCREEN_WIDTH,SCREEN_HEIGHT);

  if(__jlib_planesize <= 0L) return(0);
  /* should possibly check upper bound of plane size here */

 /* create fake context for full screen blits */
 __jlib_fake_context = make_fake_context(SCREEN_WIDTH,SCREEN_HEIGHT,NULL,NULL);
 
 if(__jlib_fake_context == NULL){

    JLIB_PRINT_DEBUG_INFO("Couldn't initialise context.\n");
    return 0;
 }

 /* create fake partial buffer for partial screen blits */
 __jlib_fake_partial_context = calloc(1,sizeof(GrContext));

 if(__jlib_fake_partial_context == NULL){
    JLIB_PRINT_DEBUG_INFO("Couldn't initialise context.\n");
    return 0;
 }

 /* this causes a seg fault under linux - look into it! */
#ifdef 0
 /* free the memory grx allocated */
 for(i=0;i<4;i++){
     if(__jlib_fake_context->gc_baseaddr[0] != NULL){
       free(__jlib_fake_context->gc_baseaddr[0]);
     }
 }
#endif

 return 1; /* mode set ok */
}


/* restore text mode */
void screen_restore_video_mode(void)
{
 GrSetMode(__jlib_previous_mode);

}

/*+------------------------------------------------------------------------+*/
/*|Return the current page number ( always 1 in this case)                 |*/
/*+------------------------------------------------------------------------+*/

int screen_get_page(void)
{
 return 1;
}

/*+------------------------------------------------------------------------+*/
/*|Show the current drawing page. ( Has no effect in this mode.)           |*/
/*+------------------------------------------------------------------------+*/

void screen_show_page(int page)
{
 /* do nothing */
}


void screen_wait_vsync(void)
{
 /* not supported yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color                                      | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_fill (UBYTE color) 
{
 GrClearScreen((int)color);

}


/*+------------------------------------------------------------------------+ */
/*|Clear the screen.                                                       | */
/*+------------------------------------------------------------------------+ */ 

void screen_clear (void) 
{
 GrClearScreen(0);

}


