/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See "readme.jon" for more details.
*/

#include <jlib.h>
#include <grx20.h>

/*+------------------------------------------------------------------------+*/
/*|blit a fullscreen buffer to the screen                                  |*/
/*+------------------------------------------------------------------------+*/
/*|This routine is just a normal blit that assumes the buffer is the same  |*/
/*|size as the screen.                                                     |*/
/*+------------------------------------------------------------------------+*/

JINLINE void screen_blit_fs_buffer(buffer_rec *buff)
{
 /* 'fake' the blit as a context to context blit */

  /* replace thier pointers with pointers to our own data */
 __jlib_fake_context->gc_baseaddr[0] = B_BUFF_PTR(buff);
 __jlib_fake_context->gc_baseaddr[1] = B_BUFF_PTR(buff)+__jlib_planesize;
 __jlib_fake_context->gc_baseaddr[2] = B_BUFF_PTR(buff)+(2*__jlib_planesize);
 __jlib_fake_context->gc_baseaddr[3] = B_BUFF_PTR(buff)+(3*__jlib_planesize);

 GrBitBltNC(NULL,0,0,__jlib_fake_context,0,0,SCREEN_MAX_X,SCREEN_MAX_Y,GrWRITE);

}


#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

#ifndef ABS
#define ABS(a)     (((a)<0) ? -(a) : (a))
#endif


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen without clipping.                   |*/
/*+------------------------------------------------------------------------+*/
/* this routine needs optimising - I might get to it when the libgrx internals
** are stable enough for me to hard code the grx routines I currently call,
** without some of the stuff we don't need done - jpg
*/
void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			  USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2)
{
 int our_width,our_height,i,our_psize;
 char *ourmem[4];

 if(sbx2 < sbx1){
    _SWAP(sbx2,sbx1);
 }
 our_width = sbx2 - sbx1;

 if(sby2 < sby1){
    _SWAP(sby2,sby1);
 }
 our_height = sby2 - sby1;

 our_psize = GrPlaneSize(our_width,our_height);

 ourmem[0] = B_BUFF_PTR(sbuff);
 ourmem[1] = B_BUFF_PTR(sbuff)+our_psize;
 ourmem[2] = B_BUFF_PTR(sbuff)+(2*our_psize);
 ourmem[3] = B_BUFF_PTR(sbuff)+(3*our_psize);

 /* fill in the correct details for the blit */
 GrCreateFrameContext(GR_frameRAM8,B_X_SIZE(sbuff),B_Y_SIZE(sbuff),ourmem,__jlib_fake_partial_context);

 GrBitBltNC(NULL,x,y,__jlib_fake_partial_context,sbx1,sby1,sbx2,sby2,GrWRITE);

}


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen with clipping.                      |*/
/*+------------------------------------------------------------------------+*/

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2)
{
 int our_width,our_height,i,our_psize;
 char *ourmem[4];

 if(sbx2 < sbx1){
    _SWAP(sbx2,sbx1);
 }
 our_width = sbx2 - sbx1;

 if(sby2 < sby1){
    _SWAP(sby2,sby1);
 }
 our_height = sby2 - sby1;

 /* calculate plane size and memory plane pointers */
 our_psize = GrPlaneSize(our_width,our_height);

 ourmem[0] = B_BUFF_PTR(sbuff);
 ourmem[1] = B_BUFF_PTR(sbuff)+our_psize;
 ourmem[2] = B_BUFF_PTR(sbuff)+(2*our_psize);
 ourmem[3] = B_BUFF_PTR(sbuff)+(3*our_psize);

 /* fill in the correct details for the blit */
 GrCreateFrameContext(GR_frameRAM8,B_X_SIZE(sbuff),B_Y_SIZE(sbuff),ourmem,__jlib_fake_partial_context);

 /* blit using grx */
 GrBitBlt(NULL,x,y,__jlib_fake_partial_context,sbx1,sby1,sbx2,sby2,GrWRITE);
}

