/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

#include <malloc.h>
#include <stdio.h>
#include <pc.h>
#include <jlib.h>

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */


/*+------------------------------------------------------------------------+*/
/*|set a DAC color register                                                |*/
/*+------------------------------------------------------------------------+*/

JINLINE void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
 UBYTE a;

 outportb(0x3c8, col);
 a = inportb(0x80);
 outportb(0x3c9, red>>2);
 a = inportb(0x80);
 outportb(0x3c9, green>>2);
 a = inportb(0x80);
 outportb(0x3c9, blue>>2);

}

/*+------------------------------------------------------------------------+*/
/*|set a block of DAC color registers                                      |*/
/*+------------------------------------------------------------------------+*/

void screen_block_set_pal(UBYTE *pal)
{
 int i;

 for(i=0;i<=255;i++){
     screen_put_pal(i,pal[i*3],pal[i*3+1],pal[i*3+2]);
 }

}


/*+------------------------------------------------------------------------+*/
/*|set all DAC color registers to zero                                     |*/
/*+------------------------------------------------------------------------+*/

void screen_blank_pal(void)
{
 int i;

 for(i=255;i>=0;i--){
     screen_put_pal(i,0,0,0);
 }

}


/*+------------------------------------------------------------------------+*/
/*|load a palette from a file                                              |*/
/*+------------------------------------------------------------------------+*/

#define SIZEOFPAL 768

UBYTE *screen_load_pal(char *fname)
{
 UBYTE *tmp;
 FILE *fp;

 /* allocate memory for the palette */
 if((tmp = (UBYTE *)malloc(SIZEOFPAL*sizeof(UBYTE)))==NULL){
    JLIB_SPRINTF(JLIB_MESSAGE_STRING,"Malloc Failed at screen_load_pal line %d\n",__LINE__);
    JLIB_PRINT_MESSAGE_STRING;

    return (UBYTE *)NULL;
 }

 /* open file */
 if((fp = fopen(fname,"rb"))==NULL){
    JLIB_SPRINTF(JLIB_MESSAGE_STRING,"Couldn't open palette file %s\n",fname);
    JLIB_PRINT_MESSAGE_STRING;

    return (UBYTE *)NULL;
 }

 /* read in the palette */
 fread(tmp,(sizeof(UBYTE)*SIZEOFPAL),1,fp);

 /* give if back */
 return tmp;
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette in                                                       |*/
/*+------------------------------------------------------------------------+*/

#define PALSIZE 255

void delay(unsigned msec);  /* where is this prototyped? */

void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE*3];

  memset(temp_pal,(int)0,PALSIZE*3);

  for(i=1;i<64;i++){
      for(j=0;j<(PALSIZE*3);j++){
	  temp_pal[j] = pal[j] * i / 64;
      }

      screen_block_set_pal(temp_pal);
      delay(delaytime);
  }
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette out                                                      |*/
/*+------------------------------------------------------------------------+*/

void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE*3];

  /* copy the palette into our local copy */
  FAST_SHORT_COPY(pal,temp_pal,(PALSIZE*3));

  for(i=64;i>0;i--){
      for(j=0;j<(PALSIZE*3);j++){
	  temp_pal[j] = pal[j] * i / 64;
      }

      screen_block_set_pal(temp_pal);
      delay(delaytime);
  }

}

