/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for details.
*/

/* THE FOLLOWING CODE IS DJGPP SPECIFIC */

/* this routine represents a quick optimisation on using _bcopy for every
** copying operation.  it is,  however,  not itself optimised.
** later implementations may well include a version of this code that utilises
** 4 byte alignment for movsb,  movsw and movsd copies where appropriate.
*/

.globl __blast 

.align 4, 0x90

__blast:
	pushl   %ebp
	movl    %esp,%ebp

	pushl   %esi
	pushl   %edi
	pushl   %eax
	pushl   %ebx
	pushl   %ecx

	cld

	movl    12(%ebp),%eax
	movl    8(%ebp),%ebx
	addl    %ebx,%eax
	rorl    $1,%eax
	jnc aligned_addresses

.align 4, 0x90
	movl    12(%ebp),%edi
	movl    8(%ebp),%esi
	movl    16(%ebp),%ecx
	rep
	movsb

	jmp done

.align 4, 0x90
aligned_addresses:
	rorl    $1,%ebx
	jnc even_adresses
	movl    12(%ebp),%edi
	movl    8(%ebp),%esi
	movl    $1,%ecx
	rep
	movsb

	movl    16(%ebp),%ecx
	decl    %ecx
	shrl    $1,%ecx
	rep
	movsw

	movl    16(%ebp),%ecx
	decl    %ecx
	rorl    $1,%ecx
	jnc done

	movl    $1,%ecx
	rep
	movsb
	jmp done

.align 4, 0x90
even_adresses:
	movl    12(%ebp),%edi
	movl    8(%ebp),%esi
	movl    16(%ebp),%ecx
	shrl    $1,%ecx
	rep
	movsw

	movl    16(%ebp),%ecx
	rorl    $1,%ecx
	jnc done

	movl    $1,%ecx
	rep
	movsb

done:
	popl   %ecx
	popl   %ebx
	popl   %eax
	popl   %edi
	popl   %esi

	leave
	ret
