/*
   **
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for more details.
 */

#include <dos.h>
#include <pc.h>
#include <jlib.h>

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */

#define MOUSE_INTERRUPT 0x33


/* used to check initialisation state */
static int __jlib_mouse_initted = 0;



/*+--------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                        | */
/*+--------------------------------------------------------------------------+ */
/*|this routine should always be called FIRST to initialize the mouse        | */
/*+--------------------------------------------------------------------------+ */
int mouse_present (void)
{
   union REGS r;
      
   if(__jlib_mouse_initted == 1){
      return 1; /* don't re-initialise */
   }

   __jlib_mouse_initted = 1;

   r.x.ax = 0x0000;
   int86 (MOUSE_INTERRUPT, &r, &r);

   if (r.x.ax == 0xffff)
     {
	return MOUSE_PRESENT;
     }
   else
     {
	return MOUSE_ABSENT;
     }
}

/*+--------------------------------------------------------------------------+ */
/*|show the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
   union REGS r;

   if(__jlib_mouse_initted == 0){
      return; /* do nothing */
   }

   r.x.ax = 0x0001;
   int86 (MOUSE_INTERRUPT, &r, &r);
}


/*+--------------------------------------------------------------------------+ */
/*|hide the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
   union REGS r;

   if(__jlib_mouse_initted == 0){
      return; /* do nothing */
   }

   r.x.ax = 0x0002;
   int86 (MOUSE_INTERRUPT, &r, &r);
}

/*+--------------------------------------------------------------------------+ */
/*|read pointer coordinates                                                  | */
/*+--------------------------------------------------------------------------+ */
void mouse_get_status (int *x_pos, int *y_pos, int *b_status)
{
   union REGS r;

   if(__jlib_mouse_initted == 0){
      return; /* do nothing */
   }

   r.x.ax = 0x0003;

   int86 (MOUSE_INTERRUPT, &r, &r);
   *x_pos = (int)(((USHORT)r.x.cx >> 1)&0xffff);/* halve the returned coordinate */
   *y_pos = (int)((USHORT)r.x.dx & 0xffff);
   *b_status = (int)(USHORT)r.x.bx;
}


/*+--------------------------------------------------------------------------+ */
/*|change pointer coordinates                                                | */
/*+--------------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{
   union REGS r;

   if(__jlib_mouse_initted == 0){
      return; /* do nothing */
   }

   r.x.ax = 0x0004;
   r.x.cx = x;
   r.x.dx = y;

   int86 (MOUSE_INTERRUPT, &r, &r);
}


/*+--------------------------------------------------------------------------+ */
/*|shut down the mouse                                                       | */
/*+--------------------------------------------------------------------------+ */
void mouse_closedown (void)
{
   if(__jlib_mouse_initted == 0){
      return; /* don't re-shutdown */
   }

   __jlib_mouse_initted = 0;

   mouse_hide_pointer ();
}
