/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for more details.
 */  

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */ 

#include <dos.h>
#include <jlib.h>
#include <go32.h>

unsigned int _jlib_off;          /* dos memory offset */

unsigned short _jlib_sel;        /* dos memory selector */

static UBYTE __jlib_previous_mode=0x3;       /* previous text mode - default */

/*+------------------------------------------------------------------------+ */ 
/*|use the bios to set video mode  13h                                     | */ 
/*+------------------------------------------------------------------------+ */ 

int screen_set_video_mode (void) 
{
   
      union REGS r;

      /* save text mode */
      r.h.ah = 0x0f;
      
      int86 (0x10,&r,&r);
      
      __jlib_previous_mode = r.h.al;
      
      /* set mode 13h */
      r.x.ax = 0x13;
   
      int86 (0x10, &r, &r);
   
      jdosmemsetup ();          /* set up dos memory access via global variables */

      return 1;                 /* successful setup */
   
}




/*+------------------------------------------------------------------------+ */ 
/*|use the bios to set video mode  (text)                                  | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_restore_video_mode (void) 
{
   
      union REGS r;
      
      r.x.ax = (unsigned short)__jlib_previous_mode;
   
      int86 (0x10, &r, &r);
   
}


/*+------------------------------------------------------------------------+ */ 
/*|Return the current page number ( always 1 in this case)                 | */ 
/*+------------------------------------------------------------------------+ */ 

int screen_get_page (void) 
{
   
      return 1;
   
}


/*+------------------------------------------------------------------------+ */ 
/*|Show the current drawing page. ( Has no effect in this mode.)           | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_show_page (int page) 
{
   /* do nothing */ 
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color                                      | */ 
/*+------------------------------------------------------------------------+ */ 

#define do_screen_fill(col)            \
  asm volatile(                         "\n\
     pushw %%es \n \
     movw __jlib_sel, %%es \n \
     push %%ecx \n \
     movl $0xA0000, %%edi \n \
     movl $16000, %%ecx \n \
     movb %0,%%al  \n \
     shll $8,%%eax \n \
     movb %0,%%al  \n \
     shll $8,%%eax \n \
     movb %0,%%al \n \
     shll $8,%%eax \n \
     movb %0,%%al \n \
     rep \n \
     stosl \n \
     pop %%ecx \n \
     popw %%es "\
     :                               /* NOTHING */ \
     :" g " (col)       \
     :"di", "ax", "cx")

void screen_fill (UBYTE color) 
{
 do_screen_fill(color); 
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 

void screen_clear (void) 
{
 do_screen_fill(0); 
}

