/* jio.h - jlib device independant file input and output */

#ifndef __JIO_H__  /* only include file once */
#define __JIO_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include <limits.h>
#include <jlib.h>

/* in this implementation the lowest bytes are written first. 
 * this stuff is really just for the jlib image format stuff + reading pcxs,
 * It wasn't written with anything else in mind,  so its not very 
 * general purpose.
 */ 

/* get the correct type of a 32 bit number to cast correctly */
#if (UINT_MAX == 0xFFFFFFFFU)
#define _J_32_BIT unsigned int
# elif (ULONG_MAX == 0xFFFFFFFFUL)
#define _J_32_BIT unsigned long
# else
#error Type of 32 bit number is not known in jio.h!
#endif


/* these two are for elementary types (int,short,char) where size <= 4 */
int jio_read_elementary_type(FILE *fp,void *type,size_t size);
int jio_write_elementary_type(FILE *fp,void *type,size_t size);


#ifdef __cplusplus
}
#endif 

#endif /* __JIO_H__ */
