/* jio.c - jlib device independant file input and output */

#include "jio.h"

/* write an elementary type (int,short,char) where size <= 4 */
int jio_write_elementary_type(FILE *fp,void *type,size_t size)
{
  switch(size){
 
     case 1:{
         UBYTE c = *(UBYTE *)type;

         fputc(c,fp);
         
         if(ferror(fp)){
            return 0;
         }
         
         return 1;
         break;
     }
   
     case 2:{
         USHORT c = *((USHORT *)type);

         fputc((UBYTE)(c & 0xff),fp);

         fputc((UBYTE)((c >> 8) & 0xff),fp);
         
         if(ferror(fp)){
            return 0;
         }

         return 1;
         break;
     }

     case 4:{
         _J_32_BIT c = *((_J_32_BIT*)type);

         fputc((UBYTE)(c & 0xff),fp);

         fputc((UBYTE)((c >> 8)  & 0xff),fp);
        
         fputc((UBYTE)((c >> 16) & 0xff),fp);

         fputc((UBYTE)((c >> 24)  & 0xff),fp);
         
         if(ferror(fp)){
            return 0;
         }

         return 1;
         break;
     }
   
     default:
         /* anything other than 1,2, or 4 bytes to be written is an error */
         return 0;
  }
}



/* read an elementary type (int,short,char) where size <= 4 */
int jio_read_elementary_type(FILE *fp,void *type,size_t size)
{
  switch(size){
 
     case 1:{
         UBYTE c;

         c=fgetc(fp);
         
         if(ferror(fp)){
            return 0;
         }

         *(UBYTE *)type = c;
         
         return 1;
         break;
     }
   
     case 2:{
         USHORT c=0;

         c += (USHORT)fgetc(fp);

         c |= (USHORT)(fgetc(fp) << 8);
         
         if(ferror(fp)){
            return 0;
         }

         *((USHORT *)type) = c;
         return 1;
         break;
     }

     case 4:{
         _J_32_BIT c=0;

         c += (_J_32_BIT)fgetc(fp);

         c |= (_J_32_BIT)(fgetc(fp) << 8);

         c |= (_J_32_BIT)(fgetc(fp) << 16);

         c |= (_J_32_BIT)(fgetc(fp) << 24);

         if(ferror(fp)){
            return 0;
         }
                  
         *((_J_32_BIT*)type) = c;

         return 1;
         break;
     }
   
     default:
         /* anything other than 1,2, or 4 bytes to be read is an error */
         return 0;
  }

}


