 /*
   **
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for more information.
 */  

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

typedef struct PCX_HEADER
  {
     UBYTE manufacturer;
     UBYTE version;
     UBYTE encoding;
     UBYTE bits_per_pixel;
     SHORT xmin, ymin;
     SHORT xmax, ymax;
     SHORT hres;
     SHORT vres;
     UBYTE palette16[48];
     UBYTE reserved;
     UBYTE color_planes;
     SHORT bytes_per_line;
     SHORT palette_type;
     UBYTE filler[58];
  } pcx_header;



image * image_load_pcx (char *filename) 
{
   
      FILE * infile;
   
      image * timg;
   
      int i, c;

   
      pcx_header pcxhead;
   
      
      JLIB_PRINT_DEBUG_INFO ("Entering image_load_pcx()\n");
   
      
   /* grab mem for header record */ 
      if ((timg = (image *) malloc (sizeof (image))) == NULL)
     {
	
	   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_pcx line %d\n", __LINE__);
	
	   JLIB_PRINT_MESSAGE_STRING;
	
	   
	   return (image *) NULL;
	
     }
   
      
   /* grab mem for palette */ 
      if ((timg->palette = (UBYTE *) malloc (768 * sizeof (UBYTE))) == NULL)
     {
	
	   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_pcx line %d\n", __LINE__);
	
	   JLIB_PRINT_MESSAGE_STRING;
	
	   
	   return (image *) NULL;
	
     }
   
      
   /* Open the file */ 
      if ((infile = fopen (filename, "rb")) == NULL)
     {
	
	   JLIB_PRINT_DEBUG_INFO ("Couldn't open file.\n");
	
	   
	   free (timg->palette);
	
	   return (image *) NULL;
	
     }
   
      
   /* read in header record */ 
      fseek (infile, 0L, 0);

   jio_read_elementary_type(infile,&pcxhead.manufacturer,sizeof(UBYTE));
   jio_read_elementary_type(infile,&pcxhead.version,sizeof(UBYTE));
   jio_read_elementary_type(infile,&pcxhead.encoding,sizeof(UBYTE));
   jio_read_elementary_type(infile,&pcxhead.bits_per_pixel,sizeof(UBYTE));
   
   jio_read_elementary_type(infile,&pcxhead.xmin,sizeof(SHORT));
   jio_read_elementary_type(infile,&pcxhead.ymin,sizeof(SHORT));
   jio_read_elementary_type(infile,&pcxhead.xmax,sizeof(SHORT));
   jio_read_elementary_type(infile,&pcxhead.ymax,sizeof(SHORT));
   jio_read_elementary_type(infile,&pcxhead.hres,sizeof(SHORT));
   jio_read_elementary_type(infile,&pcxhead.vres,sizeof(SHORT));

   for(i=0;i<48;i++){
      jio_read_elementary_type(infile,&pcxhead.palette16[i],sizeof(UBYTE));
   }      

   jio_read_elementary_type(infile,&pcxhead.reserved,sizeof(UBYTE));
   jio_read_elementary_type(infile,&pcxhead.color_planes,sizeof(UBYTE));
   jio_read_elementary_type(infile,&pcxhead.bytes_per_line,sizeof(SHORT));
   jio_read_elementary_type(infile,&pcxhead.palette_type,sizeof(SHORT));

   for(i=0;i<58;i++){
      jio_read_elementary_type(infile,&pcxhead.filler[i],sizeof(UBYTE));
   }      
      
   /* set width and height */ 
      timg->width = (pcxhead.xmax - pcxhead.xmin) + 1;
   
      timg->height = (pcxhead.ymax - pcxhead.ymin) + 1;
   
      
      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "Width and Height are %d and %d\n", timg->width, timg->height);
   
      JLIB_PRINT_MESSAGE_STRING;
   
      
   /* grab memory for buffer */ 
      if ((timg->data = (UBYTE *) malloc ((timg->width * timg->height) * sizeof (UBYTE))) == NULL)
     {
	
	   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "malloc failed at image_load_pcx line %d\n", __LINE__);
	
	   JLIB_PRINT_MESSAGE_STRING;
	
	   
	   free (timg->palette);
	
	   free (timg);
	
	   return (image *) NULL;
	
     }
   
      
   /* get the RLE data into the buffer */ 
      for (i = 0; i < (timg->width * timg->height);)
     {
	
	   unsigned int x;

	
	   
	   c = fgetc (infile) & 0xff;
	
	   
	   if ((c & 0xc0) == 0xc0)
	  {
	     
		x = c & 0x3f;
	     
		c = fgetc (infile);
	     
		while (x--)
	       {
		  
		     timg->data[i] = c;
		  
		     i++;
		  
	       }
	     
	  }
	
	   else
	  {
	     
		timg->data[i] = c;
	     
		i++;
	     
	  }
	
     }
   
      
   /* Get the check marker for 256-colour files */ 
      fseek (infile, -769L, 2);
   
      
      c = fgetc (infile);
   
      
      if (c != 0x0C)
     {
	
	   JLIB_PRINT_DEBUG_INFO ("Checksum incorrect\n");
	
	   free (timg->data);
	
	   free (timg->palette);
	
	   free (timg);
	
	   fclose (infile);
	
	   return (image *) NULL;
	
     }
   
      
   /* Read in the 256 colour palette */ 
      if ((c = fread (timg->palette, 1, 768, infile)) != 768)
     {
	
	   JLIB_PRINT_DEBUG_INFO ("Palette read failed\n");
	
	   free (timg->data);
	
	   free (timg->palette);
	
	   free (timg);
	
	   fclose (infile);
	
	   return (image *) NULL;
	
	   
     }
   
      
      fclose (infile);
   
      
      JLIB_PRINT_DEBUG_INFO ("Leaving image_load_pcx()\n");
   
      
   /* return a pointer to the image */ 
      return timg;
   
}
