
/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */
#include <string.h>
#include <jlib.h>


/*+------------------------------------------------------------------------+ */
/*|draw a rect with corners x1, y1 to x2 , y2 in color c without clipping  | */
/*+------------------------------------------------------------------------+ */

JINLINE void buff_draw_rectNC (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width;
   USHORT bwidth;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_rectNC()\n");

   if (x1 > x2) {
      x2 ^= x1;
      x1 ^= x2;			/* swap ends around */
      x2 ^= x1;
   }

   if (y1 > y2) {
      y2 ^= y1;
      y1 ^= y2;			/* swap ends around */
      y2 ^= y1;
   }

   width = x2 - x1;

   bwidth = B_X_SIZE (buff);

   buffer += ((unsigned int)bwidth * (unsigned int) y1) + x1;

   for (; y2 > y1; y2--) {
      memset (buffer, (int) c, (size_t) width + 1);	/* this is NOT a cludge! */
      buffer += bwidth;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_rectNC()\n");
}


/*+------------------------------------------------------------------------+ */
/*|draw a rect with corners x1, y1 to x2 , y2 in color c with clipping     | */
/*+------------------------------------------------------------------------+ */


JINLINE void buff_draw_rect (buffer_rec * buff, USHORT x1, USHORT y1, USHORT x2, USHORT y2, UBYTE c)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   USHORT width;
   USHORT bwidth = B_X_SIZE (buff), bheight = B_Y_SIZE (buff);


   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_rect()\n");

   if (x1 > x2) {
      x2 ^= x1;
      x1 ^= x2;			/* swap ends around */
      x2 ^= x1;
   }

   if (y1 > y2) {
      y2 ^= y1;
      y1 ^= y2;			/* swap ends around */
      y2 ^= y1;
   }

   /* test coordinates for "don't draw" clipping */
   if ((x1 > bwidth) || (y1 > bheight)) {
      return;
   }

   buffer += ((unsigned int)bwidth * (unsigned int)y1) + x1;

   /* test coordinates to clip area drawn */
   if (x2 > bwidth) {
      width = bwidth - x1;
   }
   else {
      width = x2 - x1;
   }

   if (y2 > bheight) {
      y2 = bheight;
   }

   width++;

   for (; y2 > y1; y2--) {
      memset (buffer, (int) c, (size_t) width);
      buffer += bwidth;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_rect()\n");
}
