/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */
#include <stdlib.h>
#include <jlib.h>

/*+------------------------------------------------------------------------+ */
/*|blit a portion of a buffer to another buffer without clipping           | */
/*+------------------------------------------------------------------------+ */

#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

JINLINE void buff_blit_buff_toNC (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
     buffer_rec * sbuff, USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2)
{
   int v_iterations;
   unsigned int h_len;

   UBYTE *src = B_BUFF_PTR (sbuff), *dest = B_BUFF_PTR (dbuff);
   USHORT sbuffx = B_X_SIZE (sbuff), dbuffx = B_X_SIZE (dbuff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_blit_buff_toNC()\n");

   /* sort coordinates if needed */
   if (sbx2 < sbx1) {
      _SWAP (sbx1, sbx2);
   }
   if (sby2 < sby1) {
      _SWAP (sby1, sby2);
   }

   src += ((unsigned int)sby1 * (unsigned int) sbuffx) + sbx1;
   dest += ((unsigned int)dbfy * (unsigned int)dbuffx) + dbfx;

   v_iterations = (sby2 - sby1);	/* number of times to repeat horiz. blit */
   h_len = (sbx2 - sbx1);	/* length of horizontal blit */

   switch (get_best_copy_method ((void *) src, (void *) dest, (unsigned int) h_len)) {

   case ALIGNMENT_STATE_1:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_1 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_2:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_2 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_3:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_3 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_4:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_4 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_5:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_5 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_6:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_6 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_7:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_7 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_8:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_8 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   default:
      JLIB_PRINT_DEBUG_INFO ("Unknown value returned from get_best_copy_method()\n");
      exit (0);
      break;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_blit_buff_toNC()\n");
}

/*+------------------------------------------------------------------------+ */
/*|blit a portion of a buffer to another buffer with clipping              | */
/*+------------------------------------------------------------------------+ */

#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

JINLINE void buff_blit_buff_to (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
     buffer_rec * sbuff, USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2)
{
   int v_iterations;
   unsigned int h_len;

   UBYTE *src = B_BUFF_PTR (sbuff), *dest = B_BUFF_PTR (dbuff);
   USHORT sbuffx = B_X_SIZE (sbuff), dbuffx = B_X_SIZE (dbuff), dbuffy = B_Y_SIZE (dbuff);

   JLIB_PRINT_DEBUG_INFO ("Entering buff_blit_buff_to()\n");

   /* sort coordinates if needed */
   if (sbx2 < sbx1) {
      _SWAP (sbx1, sbx2);
   }
   if (sby2 < sby1) {
      _SWAP (sby1, sby2);
   }

   /* test coordinates for "don't draw" clipping */
   if ((dbfx > dbuffx) || (dbfy > dbuffy)) {
      return;
   }

   src += ((unsigned int)sby1 * (unsigned int)sbuffx) + sbx1;
   dest += ((unsigned int)dbfy * (unsigned int)dbuffx) + dbfx;

   v_iterations = (sby2 - sby1);	/* number of times to repeat horiz. blit */
   h_len = (sbx2 - sbx1);	/* length of horizontal blit */

   /* test coordinates to clip area drawn */
   if (dbfx + h_len > dbuffx) {
      h_len = dbuffx - dbfx;
   }
   if (dbfy + v_iterations > dbuffy) {
      v_iterations = dbuffy - dbfy;
   }

   switch (get_best_copy_method ((void *) src, (void *) dest, (unsigned int) h_len)) {

   case ALIGNMENT_STATE_1:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_1 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_2:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_2 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_3:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_3 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_4:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_4 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_5:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_5 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_6:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_6 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_7:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_7 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   case ALIGNMENT_STATE_8:
      for (; v_iterations != 0; v_iterations--) {
	 MEM_COPY_ALIGN_8 (src, dest, h_len);
	 src += sbuffx;
	 dest += dbuffx;
      }
      break;

   default:
      JLIB_PRINT_DEBUG_INFO ("Unknown value returned from get_best_copy_method()\n");
      exit (0);
      break;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_blit_buff_to()\n");
}

/*+------------------------------------------------------------------------+ */
/*|blit a portion of an image to a buffer with clipping                    | */
/*+------------------------------------------------------------------------+ */

/* note: this routine relies on the arrangement of memory in buffers remaining
   **      same as memory in images.  This is therefore a devious way of performing
   **      this function, and it will die if the buffer or image structs are
   **      substantially changed.  You have been warned,  Jon!
 */

JINLINE void buff_blit_img_to (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
	    image * img, USHORT imx1, USHORT imy1, USHORT imx2, USHORT imy2)
{
   buffer_rec fake_buff;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_blit_img_to()\n");

   /* fake the image -> buffer copy as a buff to buff copy */
   fake_buff.width = img->width;
   fake_buff.height = img->height;
   fake_buff.buffer = img->data;

   /* do blit */
   buff_blit_buff_to (dbuff, dbfx, dbfy, &fake_buff, imx1, imy1, imx2, imy2);

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_blit_img_to()\n");
}

/*+------------------------------------------------------------------------+ */
/*|blit a portion of an image to a buffer without clipping                 | */
/*+------------------------------------------------------------------------+ */

/* note: this routine relies on the arrangement of memory in buffers remaining
   **      same as memory in images.  This is therefore a devious way of performing
   **      this function, and it will die if the buffer or image structs are
   **      substantially changed.  You have been warned,  Jon!
 */

JINLINE void buff_blit_img_toNC (buffer_rec * dbuff, USHORT dbfx, USHORT dbfy,
	    image * img, USHORT imx1, USHORT imy1, USHORT imx2, USHORT imy2)
{
   buffer_rec fake_buff;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_blit_img_toNC()\n");

   /* fake the image -> buffer copy as a buff to buff copy */
   fake_buff.width = img->width;
   fake_buff.height = img->height;
   fake_buff.buffer = img->data;

   /* do blit */
   buff_blit_buff_toNC (dbuff, dbfx, dbfy, &fake_buff, imx1, imy1, imx2, imy2);


   JLIB_PRINT_DEBUG_INFO ("Leaving buff_blit_img_toNC()\n");
}
