#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>
#include "maketrig.h"

#define NUM_ANGLES 4000

void main()
{
 int i,radius,count=20;
 int *sin_table;
 int *cos_table;
 buffer_rec *offscreen;
 
 sin_table = create_sin_table(NUM_ANGLES);
 cos_table = create_cos_table(NUM_ANGLES);

 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 
 if(offscreen == NULL){
    printf("Error: Not enough memory! \n");
    exit(0);
 }
 
 screen_set_video_mode();

 do{
    for(radius=10;radius<100;radius++){
	/* draw circle */
	for(i=0;i<NUM_ANGLES;i++){
	    buff_draw_point(offscreen,100+FAST_OFFSET(i,radius,sin_table),100+FAST_OFFSET(i,radius,cos_table),15);
	}
	screen_blit_fs_buffer(offscreen);
	
	/* blank circle */
	for(i=0;i<NUM_ANGLES;i++){
	    buff_draw_point(offscreen,100+FAST_OFFSET(i,radius,sin_table),100+FAST_OFFSET(i,radius,cos_table),0);
	}
    }
 }while(count--);

 sin_table = destroy_trig_table(sin_table);
 cos_table = destroy_trig_table(cos_table);

 screen_restore_video_mode();
}

