/* stubmain.c - sample driver using fastmem functions. */
#include <stdio.h>
#include "fastmem.h"

#define NUM_ITEMS 20

typedef struct{
      char *name;
      int age;
      char *address;
}id_record;

void main()
{
 int i;
 fast_mem *fmem;
 id_record **temp;

 temp = malloc((NUM_ITEMS+5)*sizeof(void *));

 fmem = fastmem_init(NUM_ITEMS,sizeof(id_record));
 printf("init done.\n");

 for(i=0;i<NUM_ITEMS+5;i++){
     temp[i]= (id_record *)fastmem_allocate(fmem);
     if(temp[i] != (id_record *)NULL){
	temp[i]->age = i;
	printf("i = %d, blocks left = %d\n",i,fastmem_blocks_remaining(fmem));
	printf("allocated.. age = %d\n",temp[i]->age);
     }
     else{
       printf("not allocated - no more room.\n");
     }
     fgetc(stdin);
 }

 for(i=0;i<NUM_ITEMS+5;i++){
     if(temp[i] == (id_record *)NULL){
	printf("this one wasn't allocated.\n");
     }
     else{
	temp[i] = (id_record *)fastmem_deallocate(fmem,(void *)temp[i]);

	if(temp[i] != (id_record *)NULL){
	   printf("this one wasn't deallocated properly.\n");
	}
	else{
	   printf("i = %d, blocks left = %d\n",i,fastmem_blocks_remaining(fmem));
	}
     }
     fgetc(stdin);
 }

 fmem = fastmem_destroy(fmem);

 if(fmem != (fast_mem *)NULL){
    printf("Destroy did not work.\n");
 }
 else{
   printf("Memory destroyed OK.\n");
 }

}
