/* demo8.c - test polygon drawing routines.
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

/* this just draws a polygon - nothing special */

#include <jlib.h>

int main(void)
{
 buffer_rec *offscreen;
 int i;
 int lcoords[] = { 80 , 150 , 220, 100 };
 int rcoords[] = { 100 , 100 , 150, 150 };
 
 /* initialise screen sized buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* check that initialisation was OK */
 if(offscreen == NULL){
    printf("ERROR:could not initialise buffer.\n");
    printf("press any key to exit.\n");
    fgetc(stdin);
    exit(0);
 }

 /* set up the screen */
 screen_set_video_mode();
 screen_put_pal(15,255,255,255);
 screen_put_pal(35,50,100,50);

 /* draw the filled poly + the hollow outline over te top */
 buff_convex_polyNC(offscreen,4,lcoords,rcoords,35);
 screen_blit_fs_buffer(offscreen);

 buff_draw_pointNC(offscreen,80,100,35);
 buff_draw_pointNC(offscreen,150,100,35);
 buff_draw_pointNC(offscreen,220,150,35);
 buff_draw_pointNC(offscreen,100,150,35);
 screen_blit_fs_buffer(offscreen);

 fgetc(stdin);

 buff_hollow_polyNC(offscreen,4,lcoords,rcoords,15);
 
 
 /* blit the buffer to the screen and wait for a keypress */
 screen_blit_fs_buffer(offscreen);
 fgetc(stdin);


 
 /* return to text mode and exit */
 screen_restore_video_mode();
 return(0);
}
