/* demo11.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/


/* Run this demo with a command line parameter to see the bounding rectangles
** of the sprites.  Use up,down,left,right keys to move one of the sprites to
** touch the other.  If they are touching you will see an x in the top left
** corner of the screen.  Press escape or q to quit.
*/


#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <jlib.h>


#define NUM_SPRITES 1
#define NUM_ITERATIONS 500

#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )

int main(int argc,char **argv)
{
 int i;
 unsigned char *pal;
 sprite_system *demo_sprites;
 buffer_rec *offscreen;
 USHORT animation[4] = {0,1,2,1};
    int t,frame;
    UBYTE *rects;
 
 
 if(!KEYBOARD_AVAILABLE){
    puts("This demo is only available to targets with keyboard support.");
    exit(0);
 } 

#if KEYBOARD_AVAILABLE == 1 
 /* init stuff*/
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 demo_sprites = sprite_init(NUM_SPRITES+1,64);
 pal = screen_load_pal("demo11.pal");
 sprite_load("demo11.spr",demo_sprites);
 screen_set_video_mode();

 srand(time(NULL));

 screen_block_set_pal(pal);

 kb_init();
 
 /* set up sprite movements */
 for(i=0;i<NUM_SPRITES;i++){
     sprite_set_xy(demo_sprites,i,RANDOM(B_X_SIZE(offscreen)-SPR_MAX_X)/2+SPR_MAX_X,
				  RANDOM(B_Y_SIZE(offscreen)-SPR_MAX_Y)/2+SPR_MAX_Y);
     sprite_set_an_frame(demo_sprites,i,RANDOM(4));
     sprite_set_move_info(demo_sprites,i,0,-(RANDOM(4))-1,-(RANDOM(4))-1);
     sprite_set_anim_info(demo_sprites,i,RANDOM(3)+1,4,animation);
     sprite_turn_on(demo_sprites,i);
 }
 
     sprite_set_xy(demo_sprites,1,RANDOM(B_X_SIZE(offscreen)-SPR_MAX_X)/2+SPR_MAX_X,
				  RANDOM(B_Y_SIZE(offscreen)-SPR_MAX_Y)/2+SPR_MAX_Y);
     sprite_set_an_frame(demo_sprites,1,RANDOM(4));
     sprite_set_anim_info(demo_sprites,1,RANDOM(3)+1,4,animation);
     sprite_set_move_info(demo_sprites,1,0,-(RANDOM(4))-1,-(RANDOM(4))-1);
 
     sprite_turn_on(demo_sprites,1);


 for(i=0;i<NUM_ITERATIONS;i++){

   sprite_update_all_anim_and_move(demo_sprites);

    buff_clear(offscreen);

   buff_save_all_sprites(demo_sprites,offscreen);

  /* randomly shove the sprite somewhere if it goes offscreen */
  for(i=0;i<2;i++){
     if((SPR_GET_XPOS(demo_sprites,i) > B_X_SIZE(offscreen)+SPR_MAX_X) ||
       (SPR_GET_XPOS(demo_sprites,i) < SPR_MAX_X-20) ||
       (SPR_GET_YPOS(demo_sprites,i) < SPR_MAX_Y-20) ||
       (SPR_GET_YPOS(demo_sprites,i) > B_Y_SIZE(offscreen)+SPR_MAX_Y)){
        sprite_set_xy(demo_sprites,i,RANDOM(B_X_SIZE(offscreen)-SPR_MAX_X)/2+SPR_MAX_X,
				  RANDOM(B_Y_SIZE(offscreen)-SPR_MAX_Y)/2+SPR_MAX_Y);
        sprite_set_an_frame(demo_sprites,i,RANDOM(4));
        sprite_set_move_info(demo_sprites,i,RANDOM(2)+1,-(RANDOM(4))-1,-(RANDOM(4))-1);
        sprite_set_anim_info(demo_sprites,i,RANDOM(3)+1,4,animation);
        sprite_turn_on(demo_sprites,i);
     }
  }

   /* check the 2 sprites for intersecting - draw an x if they do */  
   if(sprite_do_intersect(demo_sprites,0,1)){
      buff_draw_charNC(offscreen,'X',0,0,15);
   }
   else{
      buff_draw_rectNC(offscreen,0,0,CHAR_WIDTH('X'),CHAR_HEIGHT('X'),0);
   }
   


   buff_draw_all_sprites(demo_sprites,offscreen);

  if(argc > 1){   
   /* draw bounding rects */
    rects = demo_sprites->sprite_data[demo_sprites->sprites[0]->frame]->rect_coords;

     for(t= demo_sprites->sprite_data[demo_sprites->sprites[0]->frame]->no_rects; t != 0; t--){
       UBYTE a,b,c,d;
       a=*rects;rects++;
       b=*rects;rects++;
       c=*rects;rects++;
       d=*rects;rects++;
       
       buff_draw_box(offscreen,SPR_GET_XPOS(demo_sprites,0)+a-SPR_MAX_X,SPR_GET_YPOS(demo_sprites,0)+b-SPR_MAX_Y,
             SPR_GET_XPOS(demo_sprites,0)+c-SPR_MAX_X,  SPR_GET_YPOS(demo_sprites,0)+d-SPR_MAX_Y,15);
     }

    rects = demo_sprites->sprite_data[demo_sprites->sprites[1]->frame]->rect_coords;

     for(t= demo_sprites->sprite_data[demo_sprites->sprites[1]->frame]->no_rects; t != 0; t--){
       UBYTE a,b,c,d;
       a=*rects;rects++;
       b=*rects;rects++;
       c=*rects;rects++;
       d=*rects;rects++;
       
       buff_draw_box(offscreen,SPR_GET_XPOS(demo_sprites,1)+a-SPR_MAX_X,SPR_GET_YPOS(demo_sprites,1)+b-SPR_MAX_Y,
             SPR_GET_XPOS(demo_sprites,1)+c-SPR_MAX_X,  SPR_GET_YPOS(demo_sprites,1)+d-SPR_MAX_Y,15);
     }
  }
 


   screen_blit_fs_buffer(offscreen);
   buff_rest_all_sprites(demo_sprites,offscreen);

   if(kb_keydown(KEY_UP)){
      sprite_set_xy(demo_sprites,1,SPR_GET_XPOS(demo_sprites,1),SPR_GET_YPOS(demo_sprites,1)-1);
   }
   if(kb_keydown(KEY_DOWN)){
      sprite_set_xy(demo_sprites,1,SPR_GET_XPOS(demo_sprites,1),SPR_GET_YPOS(demo_sprites,1)+1);
   }

   if(kb_keydown(KEY_LEFT)){
      sprite_set_xy(demo_sprites,1,SPR_GET_XPOS(demo_sprites,1)-1,SPR_GET_YPOS(demo_sprites,1));
   }
   if(kb_keydown(KEY_RIGHT)){
      sprite_set_xy(demo_sprites,1,SPR_GET_XPOS(demo_sprites,1)+1,SPR_GET_YPOS(demo_sprites,1));
   }
   if(kb_keydown(KEY_Q)||kb_keydown(KEY_ESC)){
      break;
   }

   

 };

 kb_closedown();
 
 screen_restore_video_mode();

#endif /* KEYBOARD_AVAILABLE */
 
 return(1);

}
