
    IDEAL
    MODEL SMALL
    STACK 200h
    p386
    ASSUME CS:@CODE, DS:@DATA
    JUMPS

 DATASEG


VGASeg      dw  0a000h              ;Vga Segment in High Memmory

XSize       dw  ?                   ;Picture X and Y
YSize       dw  ?

FileHandle  dw  ?                   ;Save the file handle in case we need it

Header      db  18 DUP(0)           ;Buffer for header

TmpPal      db  768 DUP(0)          ;We will load the TGA palette here 
                                    ; before we swap it to RGB
Palette     db  768 DUP(0)          ;Space for the final palette

Credits     db  "TGA Viewer by VLA",10,13,"$"
FileError   db  "File Not Found ",10,13,"$"


 CODESEG


; External procedure from CLSUB.OBJ

 EXTRN   GetCommandLine:PROC

    
    ; File:     CLSUB.ASM
    ;
    ; 
    ; Proc:     GetCommandLine
    ;
    ;       Gets a filename off the command line and stores
    ;  it at [cs:dx], and adds the 5 byte extension at [cs:bx]
    ;
    ;  Ex.   C:\> viewtga vlagold2
    ;  Ex.
    ;  Ex.   cs:dx  -> FileName     db 13 DUP (' ') 
    ;  Ex.   cs:bx  -> Extension    db ".tga",0
    ;  Ex.
    ;  Ex.   cs:dx  -> FileName     db "vlagold2.tga",0
    ;
    ; Entry: 
    ;
    ;   ES      = PSP SEG  (ES points to this at entry of your program )
    ;                      (otherwise use Int 21h Service 51h to get it)
    ;   CS:DX   = pointer to filename area
    ;   CS:BX   = pointer to 5 byte 0 terminating Extension to add
    ;
    ; Return: 
    ;
    ;   AX      = length of command line
    ; 
    ;
    

;These are needed in the CodeSeg by GetCommandLine

FileName    db  13 DUP(' ')
Extension   db  ".tga",0

    
    ;PROC ClearVGA
    ;
    ;   Move Palette Color 0 into all offsets on the screen
    ;
    ;Entry:     None
    ;Return:    None
    
PROC ClearVGA
    push    ax cx di es             ;Save the registers we will use

    mov     es,[VGASeg]             ;Move the segment to the VGA seg
    xor     ax,ax                   ;Put 0's in both ah and al
    xor     di,di                   ;Start at offset 0
    mov     cx,1000h/2              ;1000h bytes in VGA seg /2 = words
    rep     lodsw                   ;load cx words in ax to [es:di]

    pop     es di cx ax             ;Restore our registers
    ret         
ENDP ClearVGA

    
    ; Write a specified palette chunk
    
    ; IN: DS:SI = Address of palette
    ;        CX = Number of colors to write (NOT *3)
    ;        AL = Starting palette index
    ;
    ;OUT: None
    
PROC WritePalette
    push    dx cx si
    mov     dx,cx                   ;CX * 3, but faster than using MUL or IMUL
    add     cx,cx
    add     cx,dx
    mov     dx,03c8h                ;Hardware port for write palette
    out     dx,al                   ;Starting at
    inc     dx                      ;Next port writes it in
    cld                             ;Move up through ds:si
    rep outsb                       ;Store byte from ds:si to port dx
    pop     si cx dx
    ret
ENDP



Start:
    mov     ax,@Data                ;Set ds to DataSeg
    mov     ds,ax

    mov     ax,13h                  ;320x200x256 mode
    int     10h
    
    mov     si,offset TmpPal        ;Clear the Palette
    mov     cx,256
    mov     al,0
    call    WritePalette

    call    ClearVGA                ;Clear the Screen
    
    mov     dx,offset FileName      ;cs:dx filename
    mov     bx,offset Extension     ;cs:bx extension
    call    GetCommandLine          ;Get the FileName

    cmp     ax,1
    jle     @@FileError

    mov     ax,cs                   ;filename is in the cs
    mov     ds,ax
    mov     dx,offset FileName      ;ds:dx filename
    mov     ah,3dh
    mov     al,11000010b            ;Attribute (Normal)
    int     21h                     ;Load the File
    jc      @@FileError

    mov     bx,ax
    mov     ax,@Data                ;Switch back to dataseg
    mov     es,ax
    mov     ds,ax
    mov     [FileHandle],bx         ;Save the handle
    
    mov     dx,offset Header
    mov     cx,18
    
    mov     ah,3fh                  ;Load in the 18 byte TGA Header
    int     21h
    
    mov     si,offset Header
    add     si,12                   ;12th byte is XSize
    mov     ax,[ds:si]
    mov     [XSize],ax
    
    add     si,2                    ;14th byte is YSize
    mov     ax,[ds:si]
    mov     [YSize],ax

    mov     cx,768                  ;256 Colors, 3 bytes per color
    mov     dx,offset TmpPal        ;   This is TGA Palette BGR 
    mov     ah,3fh                  ;   needs to be swapped to RGB
    int     21h
    jc      @@FileError

    
    mov     ax,[XSize]              ;Get picture size from X * Y
    mov     cx,[YSize]
    mul     cx
    mov     cx,ax                   ;Load that many bytes
    mov     ds,[VGASeg]             ;Directly to the VGASeg
    mov     dx,0
    mov     ah,3fh
    int     21h
    jc      @@FileError

    mov     ax,@Data                ;Ready to Swap the palette
    mov     ds,ax
    mov     si,offset TmpPal
    mov     di,offset Palette
    mov     cx,256                  ;256 colors

@@PaletteFlip:
    mov     al,[ds:si]              ; We load the Blue into al
    inc     si
    mov     ah,[ds:si]              ; Green to ah
    inc     si
    mov     bl,[ds:si]              ; Red to bl
    inc     si

    shr     al,2                    ;TGA palette is multiplied by 4
    shr     ah,2                    ;shr al,2 divides al by 4
    shr     bl,2                    ;do this to all the colors
    
    mov     [es:di],bl              ;Flip the order back to RGB
    inc     di
    mov     [es:di],ah              ;So we can load it directly to the
    inc     di
    mov     [es:di],al              ;VGA Palette
    inc     di

    loop    @@PaletteFlip           ;Loop until we do all the colors

    mov     si,offset Palette       ;Info needed to load the palette
    mov     cx,256
    mov     al,0

    call    WritePalette            ;Move it to the VGA Palette
    
    mov     ah,0                    ;Wait for Key Press
    int     16h

    mov     ah,1                    ;Grab the Key
    int     16h

@@Done:
    mov     bx,0                    ;Switch back to text mode
    mov     ah,0                    ;first video page
    mov     al,3
    int     10h    
    
    mov     dx,offset Credits       ;Print the credits
    mov     ah,9
    int     21h

    mov     bx,[FileHandle]         ;Close the file
    mov     ah,3eh
    int     21h
    
    jmp     @@Bye

@@FileError:
    mov     ax,@Data
    mov     ds,ax

    mov     bx,0                    ;Switch to text mode
    mov     ah,0
    mov     al,3
    int     10h    
    
    mov     dx,offset FileError     ;Tell the user it did find it
    mov     ah,9                    ; (most likely)
    int     21h

@@Bye:
    mov     ah,4ch                  ;See ya...
    int     21h
END Start


