#ifndef _REALDOS
#define _REALDOS

#include    <dos.h>
#include    <string.h>

#define     RP_SEG(A) ((unsigned)A>>4)
#define     RP_OFF(A) ((unsigned)A&15)

void    *AllocDosmem(int size) ;
#pragma  aux    AllocDosmem=     \
      " shr     ebx,4           "\
      " inc     ebx             "\
      " mov     ax, 0100h       "\
      " int     31h             "\
      " mov     ebx,0           "\
      " mov     bx,ax           "\
      " shl     ebx,4           "\
      " mov     [ebx],dx        "\
      " add     ebx,2           "\
        modify [eax edx]         \
        value  [ebx]             \
        parm   [ebx]             \

void    FreeDosmem(void *mem) ;
#pragma  aux    FreeDosmem =     \
      " sub     ebx,2           "\
      " mov     dx,[ebx]        "\
      " mov     ax, 0101h       "\
      " int     31h             "\
        modify [dx ax]           \
        parm   [ebx];

struct REGSs {
    long    edi, esi, ebp, reserved, ebx, edx, ecx, eax;
    short   flags, es, ds, fs, gs, ip, cs, sp, ss;
} ;

inline  void    int386xemul(int num, union REGS *in, union REGS *out, struct SREGS *ad)
{
    union    REGS  r;
    struct   SREGS sr;
    segread(&sr);

    REGSs    RMI;
    memset(&RMI, 0, sizeof(REGSs));
    RMI.eax = in->w.ax;
    RMI.ebx = in->w.bx;
    RMI.ecx = in->w.cx;
    RMI.edx = in->w.dx;
    RMI.edi = in->w.di;
    RMI.esi = in->w.si;
    RMI.es = ad->es;
    RMI.ds = ad->ds;

    r.w.ax = 0x0300;
    r.h.bl = num;               // interrupt number
    r.h.bh = 0;                 // flags
    r.w.cx = 0;                 // number of words to copy from protected mode to real mode stack
    sr.es = FP_SEG (&RMI);      // segment of real mode call structure
    r.x.edi = FP_OFF (&RMI);    // offset of real mode call structure
    int386x (0x31, &r, &r, &sr);

    out->w.ax = RMI.eax;
    out->w.bx = RMI.ebx;
    out->w.cx = RMI.ecx;
    out->w.dx = RMI.edx;
    out->w.si = RMI.esi;
    out->w.di = RMI.edi;
}

#endif
