#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>
#include <conio.h>
#include <time.h>
#include "command.h"
#include "global.h"
#include "cutter.inc"

int num_balls;
int speed;

int main (int argc, char *argv[])
{
    if ((color_blk      = (char far *) farcalloc (800,   sizeof (char)))==NULL)
        return FALSE;
    if ((obj            = (char far *) farcalloc (32000, sizeof (char)))==NULL)
        return FALSE;
    if (argc>1) {
        num_balls = atoi (argv[1]);
        speed   = atoi (argv[2]);
    }
    else {
        num_balls=25;
        speed=5;
    }
    if (num_balls>250)
        num_balls=250;
    if (speed>50)
        speed=50;
    SetMode ();

    LoadObjects ("cut.obj", object, obj);
    LoadPalette ("intro.plt");
    SetPalette (color_blk);

    MainControlLoop();
    escape();
    puts ("    ķ");
    puts ("      The Graphic Cutter v1.0   Is a shareware scripting language        ");
    puts ("          used in cutting computer graphics and putting them into user   ");
    puts ("          applications.                                                  ");
    puts ("    Ķ");
    puts ("      The CUTTER.ZIP may be found at:                                    ");
    puts ("      Internet:         e-mail:  wolfman@xmission.com                    ");
    puts ("      ftp.wuarchive.wustl.edu  pub/msdos_uploads/games/programming/utils ");
    puts ("      BBS support:      Istar Terra                  (801)-571-6919      ");
    puts ("      Business number:  Soleil Software              (801)-466-4072      ");
    puts ("                        273 East Whitlock Ave  #B                        ");
    puts ("                        Salt Lake City, Ut 84115                         ");
    puts ("      Graphic Cutter registration is $15 + shipping and handling.        ");
    puts ("    Ľ");

    farfree (color_blk);
    farfree (obj);
    return 0;
}

void MainControlLoop (void)
{

    int x[250], y[250];
    char x_inc[250],y_inc[250];
    char type[250];
    char add[250];
    register unsigned char inc;
    int half=(num_balls)-(num_balls/4);

    if (half<3)
        half=num_balls/2;
    if (num_balls<=1)
        half=0;

    randomize();
    for (inc=0; inc<num_balls; inc++) {
        x[inc]=20+random(280);
        y[inc]=20+random(170);
        x_inc[inc]=random(2)-2;
        y_inc[inc]=random(2)-2;
        type[inc]=BLGRAY+random(4);
        add[inc]=random(speed)+1;
        x_inc[inc]=(random(3)>1) ? -add[inc]:add[inc];
        y_inc[inc]=(random(3)>1) ? -add[inc]:add[inc];
    }

    while (!kbhit()) {
        Flip();
        EraseObj (0,0,80,200,DrawTo);
        WriteObj (260,180,DrawTo, object[soleil]);
        for (inc=0; inc<num_balls; inc++) {

            x[inc]+=x_inc[inc];
            y[inc]+=y_inc[inc];

            if (x[inc]>=280) {
                x[inc]=280;
                x_inc[inc]=-add[inc];
            }
            else
                if (x[inc]<=5) {
                    x[inc]=5;
                    x_inc[inc]=add[inc];
                }
            if (y[inc]>=170) {
                y[inc]=170;
                y_inc[inc]=-add[inc];
            }
            else
                if (y[inc]<=5) {
                    y[inc]=5;
                    y_inc[inc]=add[inc];
                }
            if (inc==half) {
                PutObj (20,60,DrawTo, object[let_G]);
                PutObj (45,72,DrawTo, object[let_r]);
                PutObj (63,72,DrawTo, object[let_a]);
                PutObj (82,72,DrawTo, object[let_p]);
                PutObj (104,60,DrawTo, object[let_h]);
                PutObj (128,61,DrawTo, object[let_i]);
                PutObj (145,72,DrawTo, object[let_c]);
                PutObj (170,60,DrawTo, object[let_C]);
                PutObj (194,72,DrawTo, object[let_u]);
                PutObj (216,65,DrawTo, object[let_t]);
                PutObj (234,65,DrawTo, object[let_t]);
                PutObj (250,72,DrawTo, object[let_e]);
                PutObj (270,72,DrawTo, object[let_r]);
            }
            PutObj(x[inc],y[inc],DrawTo,object[type[inc]]);
        }
    }
}
