// Title      : Cel2spr - autodesk animator cel to sprite maker
// Programmer : Phil Carlisle (Zoombapup // CodeX // Mage)

#include <stdio.h>

#define DEBUG

struct CelHeader {
        unsigned short id;       // 1 word identifier
        unsigned short width;    // word width
        unsigned short height;   // word height
        unsigned char other[26]; // pad out the header
        unsigned char colourmap[768]; // colour data
    };
       
        
        


void main(int argc, char **argv) {

    struct CelHeader chead;
    FILE *celfile,*sprname;
    int datasize;    
    unsigned char plane1data[16000];
    unsigned char plane2data[16000];
    unsigned char plane3data[16000];
    unsigned char plane4data[16000];
    int planedata;
    unsigned char chardatasize;
    // main pep
    printf("\ncel2spr - Internal Utility - (C) Phil Carlisle 1994\n\n");

    // check the command line for number of args..
    if (argc < 3) {
      printf("Incorrect number of parameters\n");
      printf("Usage: Cel2spr <CELFILENAME> <SPRITEFILENAME>\n");
      exit();
    } /* if */

    // its a proper command line now open the cel file...
    printf("Celfilename is ->%s \n",argv[1]);
    celfile = fopen(argv[1],"r+b"); // open the goddam file
    if (celfile==NULL)
    {
        printf("cannot open celfile, please check filename!\n");
        exit();
    };
    
    // and open the sprite file
    printf("Spritefilename is ->%s \n",argv[2]);
    sprname = fopen(argv[2],"w+b"); // open the goddam file
    if (sprname==NULL)
    {
        printf("cannot open spritefile, please check filename!\n");
        exit();
    };
    
    // ok its open! now what??
    rewind(celfile);     // set position to beggining of celfile
    fread(&chead,sizeof(struct CelHeader),1,celfile);     // read the header
    fwrite(&chead.width,sizeof(chead.width),1,sprname);   // write width 
    fwrite(&chead.height,sizeof(chead.height),1,sprname); // write height   
    
    // ok, so celfile points to start of the data
    datasize=(chead.width*chead.height);
    
    // print the info...
    printf("Sprite Width  -> %hd \n",chead.width);
    printf("Sprite Height -> %hd \n",chead.height);
    printf("Datasize -> %d",datasize);

#ifdef debug
//    
#endif    
    // setup plane data
    for (planedata=0;planedata<(datasize/4);planedata++)
    {
    fread(&plane1data[planedata],sizeof(chardatasize),1,celfile);   // read the data byte
    fread(&plane2data[planedata],sizeof(chardatasize),1,celfile);   // read the data byte
    fread(&plane3data[planedata],sizeof(chardatasize),1,celfile);   // read the data byte
    fread(&plane4data[planedata],sizeof(chardatasize),1,celfile);   // read the data byte
    }
    
    
    // finally write the data        
    fwrite(&plane1data,(datasize/4),1,sprname); // write height   
    fwrite(&plane2data,(datasize/4),1,sprname); // write height   
    fwrite(&plane3data,(datasize/4),1,sprname); // write height   
    fwrite(&plane4data,(datasize/4),1,sprname); // write height   
#ifdef debug
//    
#endif    
    
    // finally close the goddam files :)
    fclose(celfile);          
    fclose(sprname);
} /* main */
