;=============================================================================
; 386p.inc - The 386 Protected Mode structures and definitions.
;
; Copyright (C) 1992-93, Dennis Marer               File created: 12/21/92
;                                                   Last modified: 1/27/93
;
; Description:
;  This file defines the structures and equates for use in setting up and
;  using the 386 Protected Mode.  This includes all types of descriptors,
;  Task State Segments (TSS), and so on.  Note that the 286 versions of
;  each of these are not supported.
;
; Portability:
;  Requires Turbo Assembler 1.0 (TASM) or better to be assembled.
;  Dependent on a 386 or later microprocessor.
;  No other platform or hardware dependencies.
;
; Modifications:
;  DPM, 1/27/93 Finished the first revision of this file.
;=============================================================================



;=============================== Descriptors =================================



;-----------------------------------------------------------------------------
; seg_descr/gate_descr - Normal segment and gate descriptor structures, each
;  of which has a slightly different format.  In each, the flags found in
;  the 'limit_16' field can be setup and masked using the LIM_ macros,
;  and the flags and values in the 'access' field with the AC*_ macros.
;
; Normal code or data segment, TSS, or LDT descriptor:
;
;       31                              15                               0
;       +-------------------------------+-------------------------------+
;       | Base                          | Limit                         | 0
;       | 15-0                          | 15-0                          |
;       +---------------+-+-+-+-+-------+-+-+-+-+-+-+-+-+---------------+
;       | Base          |G|D|0|0| Limit |P|DPL|S|  see  | Base          | +4
;       | 31-24         | |B| | | 19-16 | |   | | below | 23-16         |
;       +---------------+-+-+-+-+-------+-+-+-+-+-+-+-+-+---------------+
;
;           TSS or LDT segment (S=0):       Normal segment (S=1):
;           +---+---+---+---+               +---+----+---+---+
;           | Type          |               | E |ED/C|W/R| A |
;           +---+---+---+---+               +---+----+---+---+
;
; All system gate descriptors:
;
;       31                              15                              0
;       +-------------------------------+-------------------------------+
;       | Selector                      | Offset                        | 0
;       |                               | 15-0                          |
;       +-------------------------------+-+---+-+-+-+-+-+-+-+-+---------+
;       | Offset                        |P|DPL|0| Type  |0|0|0| Words   | +4
;       | 31-16                         | |   | |       | | | | 4-0     |
;       +-------------------------------+-+---+-+-+-+-+-+-+-+-+---------+
;
;-----------------------------------------------------------------------------

seg_descr   struc
   limit_0      dw      0               ; Segment limit, bits 15-0
   base_0       dw      0               ; Segment base, bits 15-0
   base_16      db      0               ; Segment base, bits 23-16
   access       db      0               ; Access rights
   limit_16 db      0               ; Segment limit, bits 19-16
   base_24      db      0               ; Segment base, bits 31-24
seg_descr   ends

gate_descr  struc
   offset_0 dw      0               ; Offset, bits 15-0
   selector dw      0               ; Selector value
   words        db      0               ; Word count, bits 4-0
   access       db      0               ; Access rights
   offset_16    dw      0               ; Offset, bits 31-16
gate_descr  ends



;-----------------------------------------------------------------------------
; The following equates are used to create and examine descriptors.  The
;  LIM_ equates apply to the 'limit_16' field.  The AC_ equates apply to
;  all descriptors with an 'access' field.  The ACD_ equates apply only to
;  data descriptors, where the ACC_ equates apply to code descriptors.
;  Finally, the ACT_ equates define the system descriptor types.  (Anything
;  except code and data descriptors.)
;-----------------------------------------------------------------------------

LIM_PAGE            equ     080h                ; Page (byte) granular
LIM_32BIT           equ     040h                ; 32-bit (16-bit) segment
LIM_LIMIT           equ     00Fh                ; Limit 16-19 mask

AC_MAPPED           equ     080h                ; Segment is (not) mapped
AC_DPL              equ     060h                ; Descriptor priority mask
AC_DPL0             equ     000h                ; Descriptor priority level 0
AC_DPL1             equ     020h                ; Descriptor priority level 1
AC_DPL2             equ     040h                ; Descriptor priority level 2
AC_DPL3             equ     060h                ; Descriptor priority level 3
AC_USER             equ     010h                ; User (code or data) task
AC_CODE             equ     008h                ; Code (data) segment
AC_ACCESS           equ     001h                ; Segment was (not) accessed
ACD_DOWN            equ     004h                ; Data expands down (up)
ACD_WRITE           equ     002h                ; Data (not) writeable
ACC_CONFORM         equ     004h                ; Code (not) conforming
ACC_READ            equ     002h                ; Code (not) readable

ACT_MASK            equ     00Fh                ; System descriptor types
ACT_LDT             equ     002h                ; Local descriptor table type
ACT_TASK            equ     005h                ; Task gate type
ACT_A386            equ     009h                ; 386 TSS types
ACT_B386            equ     00Bh
ACT_CALL386         equ     00Ch                ; 386 gate types
ACT_INT386          equ     00Eh
ACT_TRAP386         equ     00Fh



;=========================== Task State Segments =============================



;-----------------------------------------------------------------------------
; tss386 - A 386 Protected Mode Task State Segment.  Any amount of data may
;  exist between the I/O bitmap offset value and the I/O bitmap, defineable
;  by the operating system.  Here, no extra memory is assumed, and the
;  I/O bitmap is fully defined (8192 bytes) for full access.
;-----------------------------------------------------------------------------

tss386          struc
   t3BackLink   dw      ?                       ; Previous TSS backlink
                dw      0                       ; Reserved
   t3ESP0       dd      ?                       ; Stack 0 pointer (CPL=0)
   t3SS0        dw      ?                       ; Stack 0 segment
                dw      0                       ; Reserved
   t3ESP1       dd      ?                       ; Stack 1 pointer (CPL=1)
   t3SS1        dw      ?                       ; Stack 1 segment
                dw      0                       ; Reserved
   t3ESP2       dd      ?                       ; Stack 2 pointer (CPL=2)
   t3SS2        dw      ?                       ; Stack 2 segment
                dw      0                       ; Reserved
   t3CR3        dd      ?                       ; CR3
   t3EIP        dd      ?                       ; Instruction pointer
   t3EFlags dd      ?                       ; Extended flags
   t3EAX        dd      ?                       ; Task general registers
   t3ECX        dd      ?
   t3EDX        dd      ?
   t3EBX        dd      ?
   t3ESP        dd      ?
   t3EBP        dd      ?
   t3ESI        dd      ?
   t3EDI        dd      ?
   t3ES     dw      ?                       ; Task segment registers
                dw      0                       ; Reserved
   t3CS     dw      ?
                dw      0                       ; Reserved
   t3SS     dw      ?
                dw      0                       ; Reserved
   t3DS     dw      ?
                dw      0                       ; Reserved
   t3FS     dw      ?
                dw      0                       ; Reserved
   t3GS     dw      ?
                dw      0                       ; Reserved
   t3LDT        dw      ?                       ; Task local descriptor table
                dw      0                       ; Reserved
   t3Trap       dw      ?                       ; Holds debug trap bit (T)
   t3IOOfs      dw      2+$-tss386              ; I/O map address offset
   t3IOMap      db      2000h dup (000h)        ; Give full I/O access
                db      0FFh                    ; Terminator
tss386          ends
