Comment #
!Implode
  Explanation  : this function nicely packs block of memory
  Expects      : ESI - pointer to block to be packed
                  EDI - pointer to destination (eeer, remember to alloc mem!)
                  ECX - size of source block
  Returns      : EAX - size of packed block
                  at packed block
                  DWORD : packed size
                  DWORD : unpacked size
                  BYTE*packed size : data
  Screwed regs : who knows ? all !
#
Implode            PROC NEAR
                   ; input : ESI - source
                   ;       : EDI - destination
                   ;       : ECX - source length
                   ; returns packed size in EAX

                   MOV   [EDI+4],ECX
                   ADD   EDI,8
                   ADD   ECX,ESI
                   MOV   @@SorceLen,ECX
                   MOV   @@Source,ESI
                   MOV   @@SorceP256,256
                   ADD   @@SorceP256,ESI
                   MOV   @@Destination,EDI

                   CLD
                   MOV   AH,16
                   MOV   EBP,EDI
                   ADD   EDI,2

@@PackLoop:        CMP   ESI,@@SorceLen
                   JAE   @@GoodBye
                   LODSB  ; get byte we wanna compare
                   MOV   EBX,-256
                   CMP   ESI,@@SorceP256
                   JA    @@Skip1
                   MOV   EBX,ESI
                   SUB   EBX,@@Source
                   DEC   EBX
                   NEG   EBX
@@Skip1:
                   XOR   CL,CL                  ; found string len is 0
                   JMP   @@CompareIn

@@CompareLoop:     INC   EBX
@@CompareIn:       OR    EBX,EBX                  ; is BX 0
                   JZ    @@CompareOver          ; if so, compare is over
                   CMP   CL,9
                   JZ    @@CompareOver          ; maximum string len is 10 bytes
                   CMP   AL,BYTE PTR [EBX+ESI-1]
                   JNZ   @@CompareLoop
                   PUSH  EAX
                   PUSH  ESI
                   MOV   AH,1                   ; one byte is equal

@@StrCompLoop:     CMP   ESI,@@SorceLen         ; are we still in range ?
                   JAE   @@StrCompEnd
                   CMP   AH,9
                   JZ    @@StrCompEnd
                   LODSB
                   CMP   AL,BYTE PTR [EBX+ESI-1]
                   JNZ   @@StrCompEnd
                   INC   AH
                   JMP   SHORT @@StrCompLoop
@@StrCompEnd:      CMP   AH,CL
                   JBE   @@Skip2
                   MOV   CL,AH
                   MOV   CH,BL
@@Skip2:
                   POP   ESI
                   POP   EAX
                   JMP   @@CompareLoop

@@CompareOver:     SUB   CL,2
                   JAE   @@StoreFull

@@StoreEmpty:      CLC
                   CALL  @@StoreBit
                   STOSB
                   JMP   @@PackLoop

@@StoreFull:       MOV   AL,CH
                   MOVZX ECX,CL
                   ADD   ESI,ECX
                   INC   ESI
                   STC
                   CALL  @@StoreBit
                   SHL   CL,5
                   REPT  3
                   SHL   CL,1
                   CALL  @@StoreBit
                   ENDM
                   STOSB
                   JMP   @@PackLoop

;-----------------------------------------------------------------------
@@StoreBit:        RCL   DX,1
                   DEC   AH
                   JNZ   @@SkipStoringWord

                   MOV   WORD PTR [EBP],DX
                   MOV   EBP,EDI
                   ADD   EDI,2
                   MOV   AH,16
@@SkipStoringWord:
                   RET
;-----------------------------------------------------------------------
@@GoodBye:         CMP   AH,16
                   JZ    @@ProcExit
                   MOV   CL,AH
                   OR    CL,CL
                   JZ    @@Skip3
                   SHL   DX,CL
@@Skip3:           MOV   WORD PTR [EBP],DX
@@ProcExit:        MOV   EAX,EDI
                   MOV   EDI,@@Destination
                   SUB   EAX,EDI
                   SUB   EDI,8
                   MOV   [EDI],EAX
                   RET

@@SorceLen         DD      ?
@@Source           DD      ?
@@Destination      DD      ?
@@SorceP256        DD      ?

Implode            ENDP

Comment #
!Explode
  Explanation  : quickly unpacks packed chunk
  Expects      : ESI - pointer to packed data (to this little two dwords header)
                  EDI - pointer where to unpack
  Returns      : nothing
  Screwed regs : all
#
Explode            PROC NEAR
                   ; ESI - packed stuff
                   ; EDI - unpacked stuff

                   MOV   ECX,[ESI+4]
                   ADD   ESI,8
                   MOV   EBX,-1
                   ADD   ECX,EDI
                   MOV   @@SorceLen,ECX
                   XOR   ECX,ECX

                   CLD
                   LODSW
                   MOV   DX,AX
                   MOV   AH,16

@@ExplodeLoop:     CMP   EDI,@@SorceLen
                   JAE   @@GoodBye
                   CALL  @@GetBit
                   JC    @@MoreComplicated
                   MOVSB
                   JMP   SHORT @@ExplodeLoop
@@MoreComplicated: REPT  3
                   CALL  @@GetBit
                   RCL   CL,1
                   ENDM
                   ADD   ECX,2
                   LODSB
                   MOV   BL,AL
@@StrCpy:          MOV   AL,[EBX+EDI]
                   STOSB
                   LOOP  @@StrCpy
                   JMP   SHORT @@ExplodeLoop

;-----------------------------------------------------------------------
@@GetBit:          SHL   DX,1
                   DEC   AH
                   JNZ   @@Skip1
                   LODSW
                   MOV   DX,AX
                   MOV   AH,16
@@Skip1:           RET
;-----------------------------------------------------------------------
@@GoodBye:
                   RET

@@SorceLen         DD   ?

Explode            ENDP

Comment #
!ExplodeFile
  Explanation  : unpacks data from diskfile to memory
  Expects      : EBX - file handle, set at data beginning
  Returns      : CF = 0, EAX - pointer to unpacked data, ECX - unpacked data len
                  CF = 1, EAX = 0, ECX = 0
  Screwed regs : EBX,EDX,ESI,EDI,EBP
#
ExplodeFile        PROC  NEAR
                   MOV   @@FileHandle,EBX
                   MOV   @@BuffPos,DiskBufferSize
                   MOV   EDX,O @@PackedSize
                   MOV   ECX,8
                   CALL  FileRead

                   MOV   EAX,@@SorceLen
                   CALL  malloc
                   JZ    @@badexit

                   MOV   EDI,EAX
                   MOV   @@Res,EAX
                   ADD   @@SorceLen,EAX
                   MOV   EBX,-1
                   CLR   ECX

                   CLD
                   CALL  @@GetByte
                   MOV   DL,AL
                   CALL  @@GetByte
                   MOV   DH,AL
                   MOV   AH,16

@@ExplodeLoop:     CMP   EDI,@@SorceLen
                   JAE   @@GoodBye
                   CALL  @@GetBit
                   JC    @@MoreComplicated
                   CALL  @@GetByte
                   STOSB
                   JMP   SHORT @@ExplodeLoop
@@MoreComplicated: REPT  3
                   CALL  @@GetBit
                   RCL   CL,1
                   ENDM
                   ADD   ECX,2
                   CALL  @@GetByte
                   MOV   BL,AL
@@StrCpy:          MOV   AL,[EBX+EDI]
                   STOSB
                   LOOP  @@StrCpy
                   JMP   SHORT @@ExplodeLoop

;-----------------------------------------------------------------------
@@GetBit:          SHL   DX,1
                   DEC   AH
                   JNZ   @@Skip1
                   CALL  @@GetByte
                   MOV   DL,AL
                   CALL  @@GetByte
                   MOV   DH,AL
                   MOV   AH,16
@@Skip1:           RET
;----------------------------------------------------------------------
@@GetByte:         PUSHFD
                   MOV   ESI,@@BuffPos
                   CMP   ESI,DiskBufferSize
                   JNZ   @@GetItNow
; here we must read from disk
                   PUSHAD
                   MOV   EBX,@@FileHandle
                   MOV   ECX,DiskBufferSize
                   CMP   @@PackedSize,ECX
                   JAE   @@SizeOK
                   MOV   ECX,@@PackedSize
@@SizeOK:          SUB   @@PackedSize,ECX
                   MOV   RI_EBX,EBX
                   MOV   RI_ECX,ECX
                   MOVZX EDX,W DiskBufferReal
                   MOV   RI_EDX,EDX
                   MOV   DX,W DiskBufferReal+2
                   MOV   RI_DS,DX
                   MOV   RI_AH,3FH
                   CALL  CallInt21
                   POPAD
                   CLR   ESI
                   MOV   @@BuffPos,ESI
@@GetItNow:        ADD   ESI,DiskBuffer
                   MOV   AL,[ESI]
                   INC   @@BuffPos
                   POPFD
                   RET
;-----------------------------------------------------------------------
@@GoodBye:         MOV   EAX,@@Res
                   MOV   ECX,@@SorceLen
                   SUB   ECX,EAX
                   CLC
@@druut:
                   RET
@@badexit:         CLR   EAX
                   CLR   ECX
                   STC
                   JMP   SHORT @@druut
@@BuffPos          DD    DiskBufferSize
@@Res              DD    ?
@@FileHandle       DD    ?
@@PackedSize       DD    ?
@@SorceLen         DD    ?
ExplodeFile        ENDP


