EXEHDR             STRUC
exeSIG             DW   ?
exePartPag         DW   ?
exePageCnt         DW   ?
exeReloCnt         DW   ?
exeHdrSize         DW   ?
exeMinMem          DW   ?
exeMaxMem          DW   ?
exeReloSS          DW   ?
exeSP              DW   ?
exeCkSum           DW   ?
exeIP              DW   ?
exeReloCS          DW   ?
exeTablOfs         DW   ?
exeOverlay         DW   ?
exeFill            DB   32D DUP (?)
exePE              DD   ?
EXEHDR             ENDS

PEHDR              STRUC
peSIG              DD   ?
peCPU              DW   ?
peObjects          DW   ?
peDate             DD   ?
peReserved0        DD   ?
peReserved1        DD   ?
peHdrSize          DW   ?
peFlags            DW   ?

peReserved2        DW   ?
peLMajor           DB   ?
peLMinor           DB   ?
peReserved3        DD   ?
peReserved4        DD   ?
peReserved5        DD   ?
peEntryPointRVA    DD   ?
peReserved6        DD   ?
peReserved7        DD   ?
peImageBase        DD   ?
peObjectAlign      DD   ?
peFileAlign        DD   ?
peOSMajor          DW   ?
peOSMinor          DW   ?
peUserMajor        DW   ?
peUserMinor        DW   ?
peSubSysMajor      DW   ?
peSubSysMinor      DW   ?
peReserved8        DD   ?
peImageSize        DD   ?
peHeaderSize       DD   ?
peFileCkSum        DD   ?
peSubSystem        DW   ?
peDLLFlags         DW   ?
peStackReserve     DD   ?
peStackCommit      DD   ?
peHeapReserve      DD   ?
peHeapCommit       DD   ?
peReserved9        DD   ?
peInteresting      DD   ?
peExportTableRVA   DD   ?
peExportSize       DD   ?
peImportTableRVA   DD   ?
peImportSize       DD   ?
peResourceTableRVA DD   ?
peResourceSize     DD   ?
peExceptionTableRVA DD   ?
peExceptionSize    DD   ?
peSecurityTableRVA DD   ?
peSecuritySize     DD   ?
peFixupTableRVA    DD   ?
peFixupSize        DD   ?
peDebugTableRVA    DD   ?
peDebugSize        DD   ?
peImageDescRVA     DD   ?
peImageDescSize    DD   ?
peMachineRVA       DD   ?
peMachineSize      DD   ?
peTLSRVA           DD   ?
peTLSSize          DD   ?
PEHDR              ENDS

OBJTAB             STRUC
oteName            DB   8 DUP (?)
oteVirtualSize     DD   ?
oteRVA             DD   ?
otePhysicalSize    DD   ?
otePhysicalOfs     DD   ?
oteReserved0       DD   ?
oteReserved1       DD   ?
oteReserved2       DD   ?
oteFlags           DD   ?
OBJTAB             ENDS

IDIRE              STRUC
idFlags            DD   ?
idStamp            DD   ?
idVerMajor         DW   ?
idVerMinor         DW   ?
idNameRVA          DD   ?
idLookupTableRVA   DD   ?
;idAddressTableRVA  DD   ?
; weird specs claim it exist and it doesnt
IDIRE              ENDS

EXDIR              STRUC
edFlags            DD   ?
edStamp            DD   ?
edVerMajor         DW   ?
edVerMinor         DW   ?
edNameRVA          DD   ?
edOrdinalBase      DD   ?
edEATEntries       DD   ?
edNamePtrs         DD   ?
edAddressTableRVA  DD   ?
edNamePtrTableRVA  DD   ?
edOrdinalTableRVA  DD   ?
EXDIR              ENDS

kernstruc          MACRO addy,lbl
                   LOCAL nextone

                   DD    O nextone
                   DD    addy
                   DB    lbl
                   DB    0
nextone:
                   ENDM

KernelFunctions    LABEL BYTE
kernstruc          BackToReality,'BackToReality'
kernstruc          Code32Base,'Code32Base'
kernstruc          Code16Base,'Code16Base'
kernstruc          PSPBase,'PSPBase'
kernstruc          EnvBase,'EnvBase'
kernstruc          SegA000,'SegA000'
kernstruc          SegB800,'SegB800'
kernstruc          FileMode,'FileMode'
kernstruc          KernelEnd,'KernelEnd'

kernstruc          FileOpen,'FileOpen'
kernstruc          FileCreate,'FileCreate'
kernstruc          FileClose,'FileClose'
kernstruc          FileRead,'FileRead'
kernstruc          FileWrite,'FileWrite'
kernstruc          FileSeek,'FileSeek'
kernstruc          FileTell,'FileTell'
kernstruc          FileSize,'FileSize'
kernstruc          FileDelete,'FileDelete'
kernstruc          FileRename,'FileRename'

kernstruc          dllLoad,'dllLoad'
kernstruc          dllKill,'dllKill'
kernstruc          dllGetProcAddr,'dllGetProcAddr'

kernstruc          Implode,'Implode'
kernstruc          Explode,'Explode'
kernstruc          ExplodeFile,'ExplodeFile'

kernstruc          _RES_Init,'_RES_Init'
kernstruc          _RES_Done,'_RES_Done'
kernstruc          _RES_Load,'_RES_Load'
kernstruc          DOSDisplayString,'DOSDisplayString'

kernstruc          SineGen,'SineGen'
kernstruc          Random,'Random'
kernstruc          RandomAbs,'RandomAbs'
kernstruc          RandSeed,'RandSeed'
kernstruc          RndLo,'RndLo'
kernstruc          RndHi,'RndHi'

kernstruc          DisplayEAX,'DisplayEAX'
kernstruc          DisplayEAXDec,'DisplayEAXDec'
kernstruc          EAXToHex,'EAXToHex'
kernstruc          DisplayECXSpaces,'DisplayECXSpaces'
kernstruc          DisplayNullString,'DisplayNullString'
kernstruc          DisplayCursor,'DisplayCursor'
kernstruc          DisplayChar,'DisplayChar'
kernstruc          NextLine,'NextLine'
kernstruc          KlearTextScreen,'KlearTextScreen'
kernstruc          CursorPtr,'CursorPtr'
kernstruc          TextAttr,'TextAttr'

kernstruc          Lo_MaxAvail,'Lo_MaxAvail'
kernstruc          Lo_Alloc,'Lo_Alloc'
kernstruc          Lo_Free,'Lo_Free'
kernstruc          Hi_MaxAvail,'Hi_MaxAvail'
kernstruc          Hi_Alloc,'Hi_Alloc'
kernstruc          Hi_Free,'Hi_Free'
kernstruc          malloc,'malloc'
kernstruc          free,'free'
kernstruc          HiHeapOrg,'HiHeapOrg'
kernstruc          HiHeapEnd,'HiHeapEnd'
kernstruc          HiFreeList,'HiFreeList'
kernstruc          LoHeapOrg,'LoHeapOrg'
kernstruc          LoHeapEnd,'LoHeapEnd'
kernstruc          LoFreeList,'LoFreeList'

kernstruc          SetGrMode,'SetGrMode'
kernstruc          CallInt,'CallInt'

kernstruc          SetIntVec,'SetIntVec'
kernstruc          GetIntVec,'GetIntVec'
kernstruc          EnableCallBack,'EnableCallBack'
kernstruc          DisableCallBack,'DisableCallBack'
kernstruc          SetIRQMasks,'SetIRQMasks'
kernstruc          GetIRQMasks,'GetIRQMasks'

kernstruc          Kbd_Get,'Kbd_Get'
kernstruc          Kbd_Pressed,'Kbd_Pressed'
kernstruc          Kbd_WaitReady,'Kbd_WaitReady'
kernstruc          Kbd_ShiftState,'Kbd_ShiftState'

kernstruc          DBG_Init,'DBG_Init'
kernstruc          DBG_InitS,'DBG_InitS'
kernstruc          DBG_SetTrap,'DBG_SetTrap'
kernstruc          DBG_InDebug,'DBG_InDebug'
kernstruc          DBG_Trap,'DBG_Trap'

; virtual registers for calling real mode procs
kernstruc          RI_Flags,'RI_Flags'
kernstruc          RI_EAX,'RI_EAX'
kernstruc          RI_AX,'RI_AX'
kernstruc          RI_AL,'RI_AL'
kernstruc          RI_AH,'RI_AH'
kernstruc          RI_EBX,'RI_EBX'
kernstruc          RI_BX,'RI_BX'
kernstruc          RI_BL,'RI_BL'
kernstruc          RI_BH,'RI_BH'
kernstruc          RI_ECX,'RI_ECX'
kernstruc          RI_CX,'RI_CX'
kernstruc          RI_CL,'RI_CL'
kernstruc          RI_CH,'RI_CH'
kernstruc          RI_EDX,'RI_EDX'
kernstruc          RI_DX,'RI_DX'
kernstruc          RI_DL,'RI_DL'
kernstruc          RI_DH,'RI_DH'
kernstruc          RI_ESI,'RI_ESI'
kernstruc          RI_SI,'RI_SI'
kernstruc          RI_EDI,'RI_EDI'
kernstruc          RI_DI,'RI_DI'
kernstruc          RI_EBP,'RI_EBP'
kernstruc          RI_BP,'RI_BP'
kernstruc          RI_IP,'RI_IP'
kernstruc          RI_CS,'RI_CS'
kernstruc          RI_DS,'RI_DS'
kernstruc          RI_ES,'RI_ES'

; stuff for paging mechanism

kernstruc          PagingOn,'PagingOn'
kernstruc          PageDirBase,'PageDirBase'
kernstruc          Page1stBase,'Page1stBase'
kernstruc          PageExtraBase,'PageExtraBase'
kernstruc          SetPagingOn,'SetPagingOn'

kernstruc          IRQMap,'IRQMap'
kernstruc          SelCode32,'SelCode32'
kernstruc          SelData32,'SelData32'
kernstruc          SelZero,'SelZero'
kernstruc          SystemFlag,'SystemFlag'
                   DD    0

; some helper functions

comment #
 case doesnt matter
 in
 ESI,EDI - strings
 out
 ZF=1 - equal
 ZF=0 - different
#
dllstrcmp          PROC  NEAR
                   PUSH  EAX
                   PUSH  ESI
                   PUSH  EDI
                   CLR   EAX
@@lp:              MOV   AL,[ESI]
; case check
                   CMP   AL,'a'
                   JB    @@case1
                   CMP   AL,'z'
                   JA    @@case1
                   SUB   AL,20H
@@case1:
                   INC   ESI
                   MOV   AH,[EDI]
; case check
                   CMP   AH,'a'
                   JB    @@case2
                   CMP   AH,'z'
                   JA    @@case2
                   SUB   AH,20H
@@case2:
                   INC   EDI
                   OR    EAX,EAX
                   JZ    @@druut ; equal, end
                   CMP   AL,AH
                   JZ    @@lp ; if not, not equal
@@druut:
                   POP   EDI
                   POP   ESI
                   POP   EAX
                   RET
dllstrcmp          ENDP


MAXDLLS            EQU   32
; header ptr, image ptr
dllinfotab         DD    2*MAXDLLS DUP(0)
DLLERR_OK          EQU   0 ; ok
DLLERR_MEM         EQU   1 ; memory/space problems
DLLERR_STRUC       EQU   2 ; file structure problems
DLLERR_NOENT       EQU   3 ; no such entity in dll system - dll or function wrong!

comment #
 EBX - ptr to dll name
 EAX - ptr to function name
#
dllGetProcAddr     PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI
                   MOV   EDI,EBX

                   MOV   ECX,MAXDLLS
                   MOV   EDX,O dllinfotab
@@DllSearchLp:     CMP   D [EDX],0
                   JZ    @@NextPlease
                   MOV   ESI,[EDX]
                   MOV   ESI,[ESI.peExportTableRVA]
                   ADD   ESI,[EDX+4]
                   MOV   ESI,[ESI.edNameRVA]
                   ADD   ESI,[EDX+4]
                   CALL  dllstrcmp
                   JZ    @@DllFound
@@NextPlease:      ADD   EDX,8
                   LOOP  @@DllSearchLp
                   JMP   SHORT @@err
@@DllFound:
                   MOV   EDI,EAX ; function name
                   MOV   ESI,[EDX]
                   MOV   ESI,[ESI.peExportTableRVA]
                   ADD   ESI,[EDX+4]
                   MOV   ECX,[ESI.edNamePtrs]
                   MOV   EBX,[ESI.edOrdinalTableRVA]
                   ADD   EBX,[EDX+4]
                   MOV   ESI,[ESI.edNamePtrTableRVA]
                   ADD   ESI,[EDX+4]
@@SearchForName:   PUSH  ESI
                   MOV   ESI,[ESI]
                   ADD   ESI,[EDX+4]
                   CALL  dllstrcmp
                   POP   ESI
                   JZ    @@NameFound
                   ADD   ESI,4
                   ADD   EBX,2
                   LOOP  @@SearchForName
                   JMP   SHORT @@err
@@NameFound:       MOVZX EBX,W [EBX] ; ordinal
                   ; !!! what with ordinal base ! ?
                   MOV   ESI,[EDX]
                   MOV   ESI,[ESI.peExportTableRVA]
                   ADD   ESI,[EDX+4] ; image
                   MOV   ESI,[ESI.edAddressTableRVA]
                   ADD   ESI,[EDX+4] ; image
                   MOV   EAX,[ESI+EBX*4]
                   ADD   EAX,[EDX+4] ; image

@@druut:           POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
@@err:             XOR   EAX,EAX
                   JMP   @@druut
dllGetProcAddr     ENDP

dllLoad            PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI
                   MOV   @@stack,ESP
; input: eax - pointer to file loaded to memory
                   MOV   @@file,EAX
                   ADD   EAX,[EAX.exePE] ; ebx points now to pe header
                   MOV   @@pehdr,EAX
                   MOV   ESI,EAX
; lets find empty slot
                   MOV   ECX,MAXDLLS
                   MOV   EBX,O dllinfotab

@@TabSLp:          CMP   D [EBX],0
                   JZ    @@found
                   ADD   EBX,8
                   LOOP  @@TabSLp
                   MOV   EAX,DLLERR_MEM
                   JMP   @@error
@@found:
; now we have to alloc some memory
                   MOVZX EAX,[ESI.peHdrSize]
                   ADD   EAX,24 ; header
                   MOV   ECX,EAX
                   CALL  malloc
                   JNZ   @@memok1
                   MOV   EAX,DLLERR_MEM
                   JMP   @@error
@@memok1:          MOV   [EBX],EAX
                   MOV   EDI,EAX
                   PUSH  ESI
                   CLD
                   REP   MOVSB
                   POP   ESI
                   MOV   EAX,[ESI.peImageSize]
                   MOV   ECX,EAX
                   CALL  malloc
                   JNZ   @@memok2
                   MOV   EAX,[EBX]
                   CALL  free
                   MOV   EAX,DLLERR_MEM
                   JMP   @@error
@@memok2:          MOV   [EBX+4],EAX
                   MOV   @@image,EAX
; well, better clear it up
                   MOV   EDI,EAX
                   CLR   AL
                   CLD
                   REP   STOSB

                   MOV   EBX,ESI ; header
; now, load objects
                   ;MOV   ESI,EBX
                   MOVZX EAX,[EBX.peHdrSize]
                   LEA   ESI,[ESI+EAX+24] ; object table
                   MOVZX ECX,[EBX.peObjects]
@@ObjLoadLp:       PUSH  ECX
                   IFDEF DLLBUG
                   Say   'object name:'
                   PUSHAD
                   LEA   ESI,[ESI.oteName]
                   CALL  DisplayNullString
                   POPAD
                   NewLine
                   ENDIF

                   PUSH  ESI
                   MOV   ECX,[ESI.otePhysicalSize] ; size
                   MOV   EDI,[ESI.oteRVA]          ; dest = rva+image
                   ADD   EDI,@@image
                   MOV   ESI,[ESI.otePhysicalOfs]  ; src = file + physical ofs
                   ADD   ESI,@@file ; pe base
                   CLD
                   REP   MOVSB
                   POP   ESI

                   ADD   ESI,size OBJTAB
                   POP   ECX
                   LOOP  @@ObjLoadLp
; now process fixups
                   MOV   EDX,@@image ; delta
                   SUB   EDX,[EBX.peImageBase]

                   MOV   ESI,[EBX.peFixupTableRVA]
                   ADD   ESI,@@image ; fixups
                   PUSH  [EBX.peFixupSize]
@@FixupOutLp:      CMP   D [ESP],0
                   JZ    @@FixupEnd
                   MOV   EDI,[ESI] ; page
                   ADD   EDI,@@image
                   MOV   ECX,[ESI+4]
                   SUB   D [ESP],8
                   SUB   ECX,8
                   ADD   ESI,8
@@FixupInLp:       OR    ECX,ECX
                   JZ    @@FixupOutLp
                   MOVZX EAX,W [ESI]
                   SHR   EAX,12
                   IFDEF DLLBUG
                   PUSHAD
                   Say   'fixup:'
                   SayDec EAX
                   Say   'at addr:'
                   MOVZX EAX,W [ESI]
                   AND   EAX,0FFFH
                   SayValue EAX
                   NewLine
                   POPAD
                   ENDIF
                   OR    EAX,EAX ; nop
                   JZ    @@FixupCont
                   CMP   EAX,1 ; high
                   JNZ   @@Fix1
                   PUSH  EDI
                   MOVZX EAX,W [ESI]
                   AND   EAX,0FFFH
                   ADD   EDI,EAX
                   MOV   EAX,EDX
                   SHR   EAX,16
                   ADD   W [EDI],AX
                   POP   EDI
                   JMP   @@FixupCont

@@Fix1:            CMP   EAX,2  ; low
                   JNZ   @@Fix2
                   MOVZX EAX,W [ESI]
                   AND   EAX,0FFFH
                   ADD   W [EDI+EAX],DX
                   JMP   @@FixupCont

@@Fix2:            CMP   EAX,3  ; highlow
                   JNZ   @@Fix3
                   MOVZX EAX,W [ESI]
                   AND   EAX,0FFFH
                   ADD   D [EDI+EAX],EDX
                   JMP   @@FixupCont

@@Fix3:            ;ADD   ESP,4 ; stack! ; highadjust is stoopid
                   MOV   EAX,DLLERR_STRUC
                   JMP   @@error

@@FixupCont:       ADD   ESI,2
                   SUB   ECX,2
                   SUB   D [ESP],2
                   JMP   @@FixupInLp

@@FixupEnd:        ADD   ESP,4

; now process imports
                   MOV   EBX,@@pehdr
                   MOV   EBX,[EBX.peImportTableRVA]
                   ADD   EBX,@@image
@@ImpModLp:        MOV   EDI,[EBX.idNameRVA]
                   OR    EDI,EDI
                   JZ    @@ImportDone
                   MOV   ESI,O @@kernelname
                   ADD   EDI,@@image
                   CALL  dllstrcmp
                   ;JNZ   @@ImportDone ; for now we support only kernel imports!
                   JNZ   @@ImportFrom

                   MOV   ESI,[EBX.idLookupTableRVA]
                   ADD   ESI,@@image
@@KernImpLp:       CMP   D [ESI],0
                   JZ    @@ImportNext ; last
                   PUSH  ESI
                   MOV   ESI,[ESI]
                   ADD   ESI,@@image
                   ADD   ESI,2 ; skip the hint!
                   IFDEF DLLBUG
                   PUSHAD
                   Say   'looking for:'
                   CALL  DisplayNullString
                   POPAD
                   ENDIF
                   MOV   EDX,O KernelFunctions
@@KernSrchLp:      CMP   D [EDX],0
                   JZ    @@KernSrchFail
                   LEA   EDI,[EDX+8]
                   CALL  dllstrcmp
                   JZ    @@KernSrchFound
                   MOV   EDX,[EDX]
                   JMP   SHORT @@KernSrchLp
@@KernSrchFound:
                   POP   ESI
                   MOV   EDX,[EDX+4] ; function address
                   IFDEF DLLBUG
                   Say   ' found at: '
                   SayValue EDX
                   NewLine
                   ENDIF
                   MOV   [ESI],EDX
                   ADD   ESI,4
                   JMP   @@KernImpLp

@@KernSrchFail:    MOV   EAX,DLLERR_NOENT
                   ;ADD   ESP,4
                   JMP   @@error

@@ImportFrom:
                   ; ebx - import dir entry
                   ; edi - dll name
                   PUSH  EBX
                   MOV   ESI,[EBX.idLookupTableRVA]
                   ADD   ESI,@@image
                   MOV   EBX,EDI ; dll name
@@ImpLp:           MOV   EAX,[ESI]
                   OR    EAX,EAX
                   JZ    @@ImpEnd
                   ADD   EAX,@@image
                   ADD   EAX,2 ; skip hint
                   CALL  dllGetProcAddr
                   OR    EAX,EAX
                   JNZ   @@FuncFoundOK
                   ;ADD   ESP,4 ; ebx
                   MOV   EAX,DLLERR_NOENT
                   JMP   @@error
@@FuncFoundOK:     MOV   [ESI],EAX
                   ADD   ESI,4
                   JMP   @@ImpLp
@@ImpEnd:
                   POP   EBX
                   JMP   SHORT @@ImportNext


@@ImportNext:      ADD   EBX,size IDIRE
                   JMP   @@ImpModLp
@@ImportDone:
; no need for fuckin with exports here
                   MOV   EAX,DLLERR_OK
@@druut:
                   POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
@@error:           MOV   ESP,@@stack
                   JMP   @@druut
@@kernelname       DB    'kernel.dll',0
@@file             DD    ?
@@pehdr            DD    ?
@@image            DD    ?
@@stack            DD    ?
dllLoad            ENDP

; eax - ptr to dll name
dllKill            PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI
                   MOV   EDI,EAX

                   MOV   ECX,MAXDLLS
                   MOV   EDX,O dllinfotab
@@DllSearchLp:     CMP   D [EDX],0
                   JZ    @@NextPlease
                   MOV   ESI,[EDX]
                   MOV   ESI,[ESI.peExportTableRVA]
                   ADD   ESI,[EDX+4]
                   MOV   ESI,[ESI.edNameRVA]
                   ADD   ESI,[EDX+4]
                   CALL  dllstrcmp
                   JZ    @@DllFound
@@NextPlease:      ADD   EDX,8
                   LOOP  @@DllSearchLp
                   JMP   SHORT @@druut
@@DllFound:
                   CLR   EAX
                   XCHG  EAX,[EDX]
                   CALL  free
                   CLR   EAX
                   XCHG  EAX,[EDX+4]
                   CALL  free

@@druut:           POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   POP   EAX
                   RET
                   RET
dllKill            ENDP


