;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; hardware specific module player vars

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; module player functions

; in BL - amiga volume
GUS_VolRampTo      PROC  NEAR
                   ;JMP   GUS_SetVoiceVol
                   PUSH  ECX
                   PUSH  ESI
                   GUS_Command cm_Volume+80H
                   GUS_InW
                   MOVZX ESI,AX ; old volume

                   MOVZX EBX,BL
                   MOV   BX,GUSVolTbl[EBX*2] ; new volume
                   CMP   EBX,ESI
                   JZ    @@druut

                   GUS_Command cm_VolumeCtrl
                   GUS_OutB 3
                   CALL  GUS_Delay

                   XOR   CL,CL ; new command
                   CMP   EBX,ESI
                   JA    @@NoChangeDir
                   OR    CL,01000000B
                   XCHG  EBX,ESI
@@NoChangeDir:     GUS_Command cm_VolRampStart
                   MOV   EAX,ESI
                   GUS_OutW
                   GUS_Command cm_VolRampEnd
                   MOV   EAX,EBX
                   GUS_OutW
                   GUS_Command cm_VolumeCtrl
                   GUS_OutB CL
                   CALL  GUS_Delay
                   POP   ESI
                   POP   ECX
@@druut:
                   RET
GUS_VolRampTo      ENDP

GUS_AddSample      PROC  NEAR
                   ; ESI - address in core memory
                   ; ECX - length
                   ; AL - volume
                   ; AH - finetune
                   ; EBX - repeat
                   ; EDX - replen
                   PUSHAD
                   MOV   EBP,SampleInfoPtr
                   MOV   DS:[EBP.SI_Volume],AL
                   MOV   DS:[EBP.SI_FineTune],AH
                   MOV   DS:[EBP.SI_RepLen],EDX
                   MOV   EAX,GUS_Mem
                   MOV   DS:[EBP.SI_Addr],EAX
                   ADD   EBX,EAX
                   MOV   DS:[EBP.SI_Repeat],EBX
                   CMP   EDX,2
                   JZ    @@NoRepeat
                   LEA   EAX,[EBX+EDX] ; repeat + replen = end of sample :)
                   JMP   @@SaveRep
@@NoRepeat:        ADD   EAX,ECX ; sample end
@@SaveRep:         MOV   DS:[EBP.SI_End],EAX

                   ADD   SampleInfoPtr,(Size SampleInfo)
                   MOV   ECX,EAX
                   SUB   ECX,DS:[EBP.SI_Addr]
                   MOV   EDX,ESI
                   CALL  GUS_StuffSample
                   MOV   ESI,EDX
                   ADD   ESI,DS:[EBP.SI_Repeat]
                   SUB   ESI,DS:[EBP.SI_Addr]
                    ; if sample looped, then from beginning
                    ; of the loop
; now lets do some anticlick stuff
                   MOV   D @@zeros,0
                   MOV   D @@zeros+4,0
                   CMP   DS:[EBP.SI_RepLen],2
                   JNZ   @@DoAClick

                   MOV   ESI,EDX
                   ADD   ESI,DS:[EBP.SI_End]
                   SUB   ESI,DS:[EBP.SI_Addr]
                   MOV   AH,[ESI-1]
                   REPT  3
                   ROR   EAX,8
                   MOV   AH,AL
                   ENDM
                   MOV   D @@zeros,EAX
                   MOV   D @@zeros+4,EAX

                   MOV   ESI,O @@zeros
@@DoAClick:
                   MOV   ECX,8
                   CALL  GUS_StuffSample

                   MOV   EAX,SampleInfoPtr
                   SUB   EAX,O SamplesInfo
                   CLR   EDX
                   MOV   EBX,(Size SampleInfo)
                   DIV   EBX
                   MOV   @@r,EAX
                   POPAD
                   MOV   EAX,@@r
                   RET
@@zeros            DD    0,0
@@r                DD    0
GUS_AddSample      ENDP

GUS_FreeModule     PROC  NEAR
                   CALL  GUS_StopModule
                   MOV   EAX,FirstPattern
                   OR    EAX,EAX
                   JZ    @@druut
                   CALL  free
                   MOV   FirstPattern,0
@@druut:
                   RET
GUS_FreeModule     ENDP

GUS_DummyRET:      RET

GUS_Effect0:       RET ; arpeggio :)
GUS_Effect0T       PROC  NEAR
                   MOVZX EAX,CounterHI
                   MOV   CL,ArpeggioTbl[EAX]
                   MOV   EAX,[ESI.CI_Speed]
                   OR    CL,CL
                   JZ    @@ArpDone
                   MOVZX EBX,[ESI.CI_InfoByte]
                   OR    EBX,EBX
                   JZ    @@ArpDone
                   CALL  COMM_NoteFind
                   CMP   CL,2
                   JZ    @@Arp2
                   AND   BL,0FH
                   ADD   EAX,EBX
                   JMP   @@ArpPre
@@Arp2:            SHR   BL,4
                   ADD   EAX,EBX
@@ArpPre:          MOVZX EAX,W NoteTable[EAX*2-2]
@@ArpDone:         MOV   EBX,EAX
                   OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
@@druut:
                   RET
GUS_Effect0T       ENDP

GUS_Effect1        PROC  NEAR
                   ; portamento up
                   MOVZX EAX,[ESI.CI_InfoByte]
                   MOV   [ESI.CI_PortaSpeed],EAX
                   RET
GUS_Effect1        ENDP

GUS_Effect1T       PROC  NEAR
                   MOV   EBX,[ESI.CI_Speed]
                   SUB   EBX,[ESI.CI_PortaSpeed]
                   CMP   EBX,MinNote
                   JGE   @@SkipONE
                   MOV   EBX,MinNote
@@SkipONE:         MOV   [ESI.CI_Speed],EBX
                   OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
                   RET
GUS_Effect1T       ENDP

GUS_Effect2        PROC  NEAR
                   ; Portamento Down
                   MOVZX EAX,[ESI.CI_InfoBYTE]
                   MOV   [ESI.CI_PortaSpeed],EAX
                   RET
GUS_Effect2        ENDP

GUS_Effect2T       PROC  NEAR
                   MOV   EBX,[ESI.CI_Speed]
                   ADD   EBX,[ESI.CI_PortaSpeed]
                   CMP   EBX,MaxNote
                   JLE   @@SkipONE
                   MOV   EBX,MaxNote
@@SkipONE:         MOV   [ESI.CI_Speed],EBX
                   OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
                   RET
GUS_Effect2T       ENDP

GUS_Effect3        PROC  NEAR
                   ; Tone Portamento
                   ; slide to note
                   MOVZX EAX,[ESI.CI_InfoByte]
                   OR    EAX,EAX
                   JZ    @@druut
                   MOV   [ESI.CI_PortaSpeed],EAX
@@druut:
                   RET
GUS_Effect3        ENDP

GUS_Effect3T       PROC  NEAR
                   MOV   EBX,[ESI.CI_Speed]
                   CMP   [ESI.CI_PortaDest],EBX
                   JZ    @@ProcExit
                   JG    @@AddIt
                   SUB   EBX,[ESI.CI_PortaSpeed]
                   CMP   [ESI.CI_PortaDest],EBX
                   JLE   @@Proceed
                   MOV   EBX,[ESI.CI_PortaDest]
                   JMP   @@Proceed

@@AddIt:           ADD   EBX,[ESI.CI_PortaSpeed]
                   CMP   [ESI.CI_PortaDest],EBX
                   JGE   @@Proceed
                   MOV   EBX,[ESI.CI_PortaDest]
@@Proceed:         MOV   [ESI.CI_Speed],EBX
                   OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
@@ProcExit:
                   RET
GUS_Effect3T       ENDP

GUS_Effect4        PROC  NEAR
                   ; Vibrato
                   MOV   AL,[ESI.CI_InfoBYTE]
                   MOV   AH,AL
                   AND   AL,0FH
                   JZ    @@NoNewDepth
                   MOV   [ESI.CI_VibDepth],AL
@@NoNewDepth:      SHR   AH,4
                   OR    AH,AH
                   JZ    @@NoNewRate
                   SHL   AH,2
                   MOV   [ESI.CI_VibRate],AH
@@NoNewRate:
                   RET
GUS_Effect4        ENDP

GUS_Effect4T       PROC  NEAR
comment #
warning !
this vibrato uses only sine wave with no retrigger
#
                   MOVZX EBX,[ESI.CI_VibPos]
                   SHR   EBX,2
                   AND   BL,1FH
                   MOVZX EAX,B VibratoTable[EBX]
                   MUL   B [ESI.CI_VibDepth]
                   SHR   EAX,7
                   MOV   EBX,[ESI.CI_Speed]
                   CMP   [ESI.CI_VibPos],0
                   JL    @@VibNeg
                   ADD   EBX,EAX
                   JMP   @@Skip1
@@VibNeg:          SUB   EBX,EAX
@@Skip1:           OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod

                   MOV   AL,[ESI.CI_VibRate]
                   ADD   [ESI.CI_VibPos],AL

                   RET
GUS_Effect4T       ENDP

GUS_Effect5        PROC  NEAR
                   ; continue Portamento + Volume Slide
                   RET
GUS_Effect5        ENDP

GUS_Effect5T       PROC  NEAR
                   CALL  GUS_Effect3T
                   JMP   GUS_EffectAT
GUS_Effect5T       ENDP

GUS_Effect6        PROC  NEAR
                   ; Vibrato + Volume SLIDE
                   RET
GUS_Effect6        ENDP

GUS_Effect6T       PROC  NEAR
                   CALL  GUS_Effect4T
                   JMP   GUS_EffectAT
GUS_Effect6T       ENDP

GUS_Effect7        PROC  NEAR
                   ; Tremolo
                   MOV   AL,[ESI.CI_InfoByte]
                   MOV   AH,AL
                   AND   EAX,0F00FH
                   JZ    @@druut
                   OR    AH,AH
                   JZ    @@skip1
                   AND   [ESI.CI_TremoloCmd],00FH
                   OR    [ESI.CI_TremoloCmd],AH
@@skip1:           OR    AL,AL
                   JZ    @@skip2
                   AND   [ESI.CI_TremoloCmd],0F0H
                   OR    [ESI.CI_TremoloCmd],AL
@@skip2:

@@druut:
                   RET
GUS_Effect7        ENDP

GUS_Effect7T       PROC  NEAR
                   MOVZX EBX,[ESI.CI_TremoloPos]
                   SHR   BL,2
                   AND   BL,1FH
; sine only
                   MOVZX EAX,B VibratoTable[EBX]
                   MOV   AH,[ESI.CI_TremoloCmd]
                   AND   AH,0FH
                   MUL   AH
                   SHR   EAX,6
                   MOV   AH,[ESI.CI_Volume]
                   CMP   [ESI.CI_TremoloPos],0
                   JL    @@TremoloNeg
                   ADD   AH,AL
                   JMP   @@TremoloCheck
@@TremoloNeg:      SUB   AH,AL
@@TremoloCheck:    JAE   @@TremoloSkip
                   XOR   AH,AH
@@TremoloSkip:     CMP   AH,40H
                   JBE   @@TremoloOK
                   MOV   AH,40H
@@TremoloOK:
                   MOV   BL,AH
                   CALL  GUS_VolRampTo
                   ; now use this volume at AH!
                   MOV   AL,[ESI.CI_TremoloCmd]
                   SHR   AL,2
                   AND   AL,3CH
                   ADD   [ESI.CI_TremoloPos],AL
                   RET
GUS_Effect7T       ENDP

GUS_Effect8        PROC  NEAR
                   ; ??? NOT USED ??? yeah, not used
                   MOV   AL,[ESI.CI_InfoByte]
                   SHR   AL,4
                   MOV   [ESI.CI_Panning],AL
                   CALL  GUS_SetVoicePan
                   RET
GUS_Effect8        ENDP

GUS_Effect8T       PROC  NEAR
                   RET
GUS_Effect8T       ENDP

GUS_Effect9        PROC  NEAR
                   ; Sample Offset
                   XOR   EBX,EBX
                   MOV   BH,[ESI.CI_InfoBYTE]
                   ADD   EBX,[ESI.CI_Addr]
                   CMP   EBX,[ESI.CI_End]
                   JBE   @@SkipONE
                   MOV   EBX,[ESI.CI_End]
@@SkipONE:         MOV   [ESI.CI_Pos],EBX
                   RET
GUS_Effect9        ENDP

GUS_EffectA        PROC  NEAR
                   ; Volume Slide
                   RET
GUS_EffectA        ENDP

GUS_EffectAT       PROC  NEAR
                   MOV   AL,[ESI.CI_InfoBYTE]
                   MOV   AH,AL
                   AND   AL,0FH  ; AL - LO NIBBLE
                   SHR   AH,4    ; AH - HI NIBBLE
                   MOV   BL,[ESI.CI_Volume]
                   ADD   BL,AH
                   CMP   BL,40H
                   JBE   @@SkipONE
                   MOV   BL,40H
@@SkipONE:         SUB   BL,AL
                   JGE   @@SkipTWO
                   XOR   BL,BL
@@SkipTWO:         MOV   [ESI.CI_Volume],BL
                   CALL  GUS_VolRampTo
                   RET
GUS_EffectAT       ENDP

GUS_EffectB        PROC  NEAR
                   ; Position JUMP
                   ; JUMPS TO First ??? Row OF Pattern At position infobyte
                   MOV   PBreakPos,0
                   MOV   AL,[ESI.CI_InfoBYTE]
                   DEC   AL
                   MOV   Song_Position,AL
                   MOV   PosJumpFlag,TRUE
                   RET
GUS_EffectB        ENDP

GUS_EffectC        PROC  NEAR
                   ; SET Volume
                   MOV   BL,[ESI.CI_InfoBYTE]
                   CMP   BL,64
                   JA    @@Skip
                   MOV   [ESI.CI_Volume],BL
                   ;MOV   [ESI.CI_MixVol],BL
                   CALL  GUS_VolRampTo
@@Skip:            RET
GUS_EffectC        ENDP

GUS_EffectD        PROC  NEAR
                   ; Pattern BREAK
                   MOVZX EAX,[ESI.CI_InfoBYTE]
                   MOV   CL,AL
                   SHR   AL,4
                   MOV   AL,Mul10Table[EAX]
                   AND   CL,0FH
                   CMP   CL,9
                   JA    @@druut
                   ADD   AL,CL
                   CMP   AL,63
                   JA    @@druut
                   IMUL  EAX,ModuleChannels
                   SHL   EAX,2
                   MOV   PBreakPos,EAX
                   MOV   PosJumpFlag,TRUE
@@druut:           RET
GUS_EffectD        ENDP

GUS_EffectE        PROC  NEAR
                   ; a bunch of extended protracker commands
                   ; now supported
                   ; 1 fineslide up
                   ; 2 fineslide down
                   ; 6 pattern loop
                   ; A fine vol up
                   ; B fine vol down
                   ; E ptn delay

                   MOV   AL,[ESI.CI_InfoBYTE]
                   MOV   AH,AL
                   AND   EAX,0F00FH

                   CMP   AH,10H     ; fineslide up
                   JZ    @@FineSlideUp
                   CMP   AH,20H
                   JZ    @@FineSlideDown
                   CMP   AH,60H
                   JZ    @@LoopPattern
                   CMP   AH,0A0H
                   JZ    @@FineVolUp
                   CMP   AH,0B0H
                   JZ    @@FineVolDown
                   CMP   AH,0E0H
                   JZ    @@PatternDelay
                   RET

@@FineSlideUp:     XOR   AH,AH
                   MOV   EBX,[ESI.CI_Speed]
                   SUB   EBX,EAX
                   CMP   EBX,MinNote
                   JGE   @@fsnoteok
                   MOV   EBX,MinNote
@@fsnoteok:        MOV   [ESI.CI_Speed],EBX
                   OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
                   RET

@@FineSlideDown:   XOR   AH,AH
                   MOV   EBX,[ESI.CI_Speed]
                   ADD   EBX,EAX
                   CMP   EBX,MaxNote
                   JLE   @@fsnoteok
                   MOV   EBX,MaxNote
                   JMP   @@fsnoteok

@@LoopPattern:     CMP   AL,0
                   JZ    @@lpSet
                   CMP   [ESI.CI_LoopCounter],0FFH
                   JNZ   @@lpCont
                   MOV   [ESI.CI_LoopCounter],AL
@@lpCont:          DEC   [ESI.CI_LoopCounter]
                   CMP   [ESI.CI_LoopCounter],0FFH
                   JNZ   @@lpSetJump
                   MOV   [ESI.CI_LoopDivision],0
                   JMP   @@lpDone
@@lpSetJump:       MOV   ECX,[ESI.CI_LoopDivision]
                   MOV   Pattern_OFS,ECX
@@lpDone:          RET

@@lpSet:           MOV   EAX,Pattern_OFS
                   SUB   EAX,16
                   MOV   [ESI.CI_LoopDivision],EAX
                   JMP   @@lpDone

@@FineVolUp:       MOV   BL,[ESI.CI_Volume]
                   ADD   BL,AL
                   CMP   BL,64
                   JBE   @@volslok
                   MOV   BL,64
@@volslok:         MOV   [ESI.CI_Volume],BL
                   CALL  GUS_VolRampTo
                   RET

@@FineVolDown:     MOV   BL,[ESI.CI_Volume]
                   SUB   BL,AL
                   JAE   @@volslok
                   XOR   BL,BL
                   JMP   @@volslok

@@PatternDelay:    MOV   AH,Tempo
                   MUL   AH
                   ADD   CounterHI,AL
                   RET

GUS_EffectE        ENDP

GUS_EffectF        PROC  NEAR
                   ; Set Speed
                   MOV   AL,[ESI.CI_InfoBYTE]
                   CMP   AL,20H
                   JA    @@SetBPM
                   OR    AL,AL
                   JZ    @@druut
                   MOV   Tempo,AL
                   MOV   CounterHI,AL
                   JMP   @@druut
@@SetBPM:          MOV   BL,AL
                   CALL  GUS_SetBPM
@@druut:           RET
GUS_EffectF        ENDP

; effects issued at beginning of row
GUS_Effects        DD    O GUS_Effect0
                   DD    O GUS_Effect1
                   DD    O GUS_Effect2
                   DD    O GUS_Effect3
                   DD    O GUS_Effect4
                   DD    O GUS_Effect5
                   DD    O GUS_Effect6
                   DD    O GUS_Effect7
                   DD    O GUS_Effect8
                   DD    O GUS_Effect9
                   DD    O GUS_EffectA
                   DD    O GUS_EffectB
                   DD    O GUS_EffectC
                   DD    O GUS_EffectD
                   DD    O GUS_EffectE
                   DD    O GUS_EffectF

; effects repeated every tick
GUS_EffectsT       DD    O GUS_Effect0T
                   DD    O GUS_Effect1T
                   DD    O GUS_Effect2T
                   DD    O GUS_Effect3T
                   DD    O GUS_Effect4T
                   DD    O GUS_Effect5T
                   DD    O GUS_Effect6T
                   DD    O GUS_Effect7T
                   DD    O GUS_DummyRET
                   DD    O GUS_DummyRET
                   DD    O GUS_EffectAT
                   DD    O GUS_DummyRET
                   DD    O GUS_DummyRET
                   DD    O GUS_DummyRET
                   DD    O GUS_DummyRET
                   DD    O GUS_DummyRET

GUS_TickHandler    PROC  NEAR
                   DEC   CounterHI
                   JZ    GUS_InitPattern

                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,ModuleChannels
@@EffectLp:        PUSH  ECX
                   MOV   AL,B ModuleChannels
                   SUB   AL,CL
                   CALL  GUS_SelectVoice
                   CALL  D [ESI.CI_EffectProc]
                   ADD   ESI,Size ChannelInfo
                   POP   ECX
                   LOOP  @@EffectLp
                   JMP   @@druut

GUS_InitPattern:   MOV   AL,Tempo
                   MOV   CounterHI,AL
                   CMP   PosJumpFlag,TRUE
                   JZ    @@NextPosition
                   MOV   EBX,ModuleChannels
                   SHL   EBX,6+2
                   CMP   Pattern_OFS,EBX
                   JNZ   @@AnalyzeRow
                   MOV   PBreakPos,0
@@NextPosition:    MOV   EAX,PBreakPos
                   MOV   Pattern_OFS,EAX
                   MOV   AL,Song_Position
                   INC   AL
                   CMP   AL,SongLen
                   JB    @@Skip1
                   XOR   AL,AL
@@Skip1:           MOV   Song_Position,AL
                   MOVZX EAX,AL
                   MOVZX EAX,BYTE PTR SongOrder[EAX]
                   IMUL  EAX,ModuleChannels
                   SHL   EAX,6+2
                   ADD   EAX,FirstPattern
                   MOV   PatternBase,EAX
                   MOV   PosJumpFlag,FALSE

@@AnalyzeRow:      MOV   EDI,Pattern_OFS
                   ADD   EDI,PatternBase
                   MOV   EAX,ModuleChannels
                   SHL   EAX,2
                   ADD   Pattern_OFS,EAX

                   IFDEF DEBUG
                   Say   'GUS: '
                   ENDIF
                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,ModuleChannels
@@ChannelLp:       PUSH  ECX
                   MOV   AL,B ModuleChannels
                   SUB   AL,CL
                   CALL  GUS_SelectVoice

                   MOV   @@ReTrigFlg,FALSE
                   MOV   @@NewSampFlg,FALSE

                   MOVZX EAX,B [EDI+1] ; sample number
                   IFDEF DEBUG
                   CALL  DispAL
                   Say   ' '
                   ENDIF
                   OR    AL,AL
                   JZ    @@Freq
                   MOV   @@ReTrigFlg,TRUE
                   CMP   AL,[ESI.CI_OldSamp]
                   JZ    @@NoNewSample
                   MOV   @@NewSampFlg,TRUE
                   MOV   [ESI.CI_OldSamp],AL

@@NoNewSample:     DEC   AL
                   MOV   AH,Size SampleInfo
                   MUL   AH
                   LEA   EBX,SamplesInfo[EAX]

                   MOV   EAX,[EBX.SI_End]
                   MOV   [ESI.CI_End],EAX
                   MOV   EAX,[EBX.SI_Repeat]
                   MOV   [ESI.CI_Repeat],EAX
                   MOV   EAX,[EBX.SI_RepLen]
                   MOV   [ESI.CI_RepLen],EAX

                   MOV   AL,[EBX.SI_Volume]
                   MOV   [ESI.CI_Volume],AL
                   MOV   AL,[EBX.SI_FineTune]
                   SHL   AL,4
                   MOV   [ESI.CI_FineTune],AL
                   MOV   EAX,[EBX.SI_Addr]
                   MOV   [ESI.CI_Addr],EAX    ; current sample address
                   MOV   [ESI.CI_Pos],EAX    ; current sample address

@@Freq:            MOVZX ECX,BYTE PTR [EDI]  ; number of note
                   IFDEF DEBUG
                   PUSHAD
                   LEA   ESI,NoteText[ECX*4]
                   CALL  DisplayNullString
                   MOV   AL,' '
                   CALL  DisplayChar
                   POPAD
                   ENDIF
                   OR    ECX,ECX
                   JZ    @@FeelCommand

                   CMP   BYTE PTR [EDI+2],3 ; chek slide to note
                   JZ    @@SetPorta
                   CMP   BYTE PTR [EDI+2],5 ; chek contine slide
                   JZ    @@SetPorta
                   MOV   @@ReTrigFlg,TRUE
                   MOV   EAX,[ESI.CI_Addr]
                   MOV   [ESI.CI_Pos],EAX
                   MOVZX ECX,W NoteTable[ECX*2-2]
                   MOV   [ESI.CI_Speed],ECX

@@SetPorta:        MOVZX ECX,W NoteTable[ECX*2-2]
                   MOV   [ESI.CI_PortaDest],ECX

@@FeelCommand:     MOV   AL,[EDI+3]  ; Info byte
                   MOV   [ESI.CI_InfoByte],AL
                   MOVZX EBX,BYTE PTR [EDI+2]  ; Command byte

                   IFDEF DEBUG
                   MOV   AL,BL
                   CALL  DispAL
                   Say   ' '
                   MOV   AL,[EDI+3]
                   CALL  DispAL
                   Say   ' '
                   ENDIF
; do command

                   MOV   EAX,GUS_EffectsT[EBX*4]
                   MOV   [ESI.CI_EffectProc],EAX
                   CALL  D GUS_Effects[EBX*4]

; some changes,! here ! we !RETRIGGER note
                   CMP   @@ReTrigFlg,TRUE
                   JNZ   @@NoReTrig

                   CALL  GUS_StopVoice

                   MOV   EBX,[ESI.CI_Speed]
                   OR    BH,[ESI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
                   MOV   BL,[ESI.CI_Volume]
                   CALL  GUS_VolRampTo
                   
                   MOV   EBX,[ESI.CI_Pos]
                   CALL  GUS_SetSampleStart

                   CMP   @@NewSampFlg,TRUE
                   JNZ   @@DoPlay
                   MOV   EBX,[ESI.CI_End]
                   CALL  GUS_SetSampleEnd

                   MOV   EBX,[ESI.CI_Repeat]
                   CMP   [ESI.CI_RepLen],2
                   JNZ   @@PlayLooped
                   MOV   EBX,[ESI.CI_End]
                   DEC   EBX
@@PlayLooped:      CALL  GUS_SetSampleLoop
@@DoPlay:          CALL  GUS_PlayVoiceL
@@NoReTrig:
                   ADD   EDI,4
                   ADD   ESI,Size ChannelInfo
                   POP   ECX
                   LOOP  @@ChannelLp

                   IFDEF DEBUG
                   NewLine
                   ENDIF
@@druut:
                   RET
@@ReTrigFlg        DB    FALSE ; true if we need to retrigger note
@@NewSampFlg       DB    FALSE ; true if we need to change sample info in gus

GUS_TickHandler    ENDP

GUS_PlayModule     PROC  NEAR
                   MOV   BYTE PTR Tempo,6
                   MOV   BYTE PTR CounterHI,1
                   MOV   BYTE PTR Song_Position,129
                   MOV   PosJumpFlag,FALSE
                   MOV   EAX,ModuleChannels
                   SHL   EAX,6+2
                   MOV   Pattern_OFS,EAX
                   MOV   ECX,MixingChannels
                   MOV   ESI,O ChannelsInfo
@@InitChnLp:       MOV   [ESI.CI_Volume],0
                   MOV   [ESI.CI_EffectProc],O GUS_DummyRET
                   MOV   [ESI.CI_AfterDivF],0
                   MOV   [ESI.CI_AfterDivM],0
                   MOV   [ESI.CI_Speed],0
                   MOV   [ESI.CI_OldSamp],0

                   MOV   EAX,MixingChannels
                   SUB   EAX,ECX
                   CALL  GUS_SelectVoice
                   MOV   EAX,MixingChannels
                   SUB   EAX,ECX
                   MOV   AL,DefaultPanning[EAX]
                   MOV   [ESI.CI_Panning],AL
                   CALL  GUS_SetVoicePan

                   ADD   ESI,Size ChannelInfo
                   LOOP  @@InitChnLp

                   CALL  NEAR PTR GUS_InitPattern
                   MOV   ModPlaying,TRUE

                   RET
GUS_PlayModule     ENDP

GUS_StopModule     PROC  NEAR
                   CLI
                   MOV   ModPlaying,FALSE

                   MOV   ECX,MixingChannels
@@StopLp:          MOV   EAX,MixingChannels
                   SUB   EAX,ECX
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   LOOP  @@StopLp
                   STI
                   RET
GUS_StopModule     ENDP

; "unload" module, clear all samples, clear patterns
GUS_FreeMem        PROC  NEAR
                   CALL  GUS_StopModule ; it shouldnt, but who knows ?
                   CLI
                   MOV   EDI,O ChannelsInfo
                   MOV   ECX,(Size ChannelInfo)*14
                   CLD
                   CLR   EAX
                   REP   STOSB
                   STI
                   MOV   ECX,O SamplesInfo
                   XCHG  SampleInfoPtr,ECX
                   MOV   GUS_Mem,0
                   MOV   EAX,FirstPattern
                   OR    EAX,EAX
                   JZ    @@NoFree
                   CALL  free
@@NoFree:          MOV   FirstPattern,0
                   RET
GUS_FreeMem        ENDP

; in AL - voice number
; EBX - sample number (1...)
; ECX - volume (-1 = default volume)
; EDX - amiga period
GUS_PlaySample     PROC  NEAR
                   CLI
                   OR    EBX,EBX
                   JZ    @@druut
                   MOV   @@per,EDX
                   MOV   @@vol,ECX
                   MOVZX EDI,AL
                   MOV   EDX,Size ChannelInfo
                   IMUL  EDI,EDX
                   ADD   EDI,O ChannelsInfo
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   ESI,Size SampleInfo
                   DEC   EBX
                   IMUL  ESI,EBX
                   ADD   ESI,O SamplesInfo

                   MOV   EAX,[ESI.SI_End]
                   MOV   [EDI.CI_End],EAX
                   MOV   EAX,[ESI.SI_Repeat]
                   MOV   [EDI.CI_Repeat],EAX
                   MOV   EAX,[ESI.SI_RepLen]
                   MOV   [EDI.CI_RepLen],EAX

                   MOV   AL,[ESI.SI_Volume]
                   CMP   D @@vol, -1
                   JZ    @@SkipVol
                   MOV   AL,B @@vol
                   CMP   AL,64
                   JBE   @@SkipVol
                   MOV   AL,64
@@SkipVol:
                   MOV   [EDI.CI_Volume],AL
                   MOV   AL,[ESI.SI_FineTune]
                   SHL   AL,4
                   MOV   [EDI.CI_FineTune],AL
                   MOV   EAX,[ESI.SI_Addr]
                   MOV   [EDI.CI_Addr],EAX    ; current sample address
                   MOV   [EDI.CI_Pos],EAX    ; current sample address

                   MOV   EBX,@@per
                   MOV   [EDI.CI_Speed],EBX
                   OR    BH,[EDI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
                   MOV   BL,[EDI.CI_Volume]
                   CALL  GUS_VolRampTo
                   
                   MOV   EBX,[EDI.CI_Pos]
                   CALL  GUS_SetSampleStart

                   MOV   EBX,[EDI.CI_End]
                   CALL  GUS_SetSampleEnd

                   MOV   EBX,[EDI.CI_Repeat]
                   CMP   [EDI.CI_RepLen],2
                   JNZ   @@PlayLooped
                   MOV   EBX,[EDI.CI_End]
                   DEC   EBX
@@PlayLooped:      CALL  GUS_SetSampleLoop
                   CALL  GUS_PlayVoiceL

@@druut:           STI
                   RET
@@per              DD    ?
@@vol              DD    ?
GUS_PlaySample     ENDP

; AL - channel
; EBX - amiga period
GUS_SamplePeriod   PROC  NEAR
                   CLI
                   PUSH  EAX
                   MOVZX EAX,AL
                   MOV   EDI,Size ChannelInfo
                   IMUL  EDI,EAX
                   ADD   EDI,O ChannelsInfo
                   POP   EAX
                   CALL  GUS_SelectVoice
                   MOV   [EDI.CI_Speed],EBX
                   OR    BH,[EDI.CI_FineTune]
                   CALL  GUS_SetVoicePeriod
                   STI
                   RET
GUS_SamplePeriod   ENDP

GUSPBFlipFlop      DB    FALSE

GLOBAL GUS_Playback : NEAR
GUS_Playback       PROC  NEAR
                   CMP   GUSPBFlipFlop,TRUE
                   JNZ   @@refreshdone
                   MOV   AL,0
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,0
                   CALL  GUS_SetSampleStart
                   CALL  GUS_PlayVoiceL

                   MOV   AL,2
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,0
                   CALL  GUS_SetSampleStart
                   CALL  GUS_PlayVoiceL

                   MOV   AL,1
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,1024
                   CALL  GUS_SetSampleStart
                   CALL  GUS_PlayVoiceL

                   MOV   AL,3
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,1024
                   CALL  GUS_SetSampleStart
                   CALL  GUS_PlayVoiceL
@@refreshdone:
                   CALL  PlaybackCallback
                   ; in esi there is data provided for output
                   CMP   GUSPBFlipFlop,FALSE
                   JNZ   @@SecondChunk
; first chunk
; left channel
                   MOV   EBX,0
                   INC   ESI ; high byte
                   PUSH  ESI
                   MOV   ECX,HERTZ50 + 8
                   CALL  GUS_FastUpload
                   POP   ESI
; right channel
                   ADD   ESI,2
                   MOV   EBX,1024
                   MOV   ECX,HERTZ50 + 8
                   CALL  GUS_FastUpload
                   JMP   @@Done
@@SecondChunk:
; left channel
                   MOV   EBX,HERTZ50
                   INC   ESI ; high byte
                   PUSH  ESI
                   MOV   ECX,HERTZ50 + 8
                   CALL  GUS_FastUpload
; right channel
                   POP   ESI
                   ADD   ESI,2
                   MOV   EBX,1024+HERTZ50
                   MOV   ECX,HERTZ50 + 8
                   CALL  GUS_FastUpload
@@Done:
                   NOT   GUSPBFlipFlop

                   @@druut:
                   RET
GUS_Playback       ENDP


;GUS_PlaySample
GUS_PlaybackInit   PROC  NEAR
                   MOV   PlaybackCallback,EAX

; left channel
                   MOV   AL,0
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,161
                   CALL  GUS_SetVoicePeriod
                   MOV   BL,64
                   CALL  GUS_VolRampTo
                   MOV   EBX,0
                   CALL  GUS_SetSampleStart
                   MOV   EBX,2 * HERTZ50
                   CALL  GUS_SetSampleEnd
                   MOV   EBX,0
                   CALL  GUS_SetSampleLoop
                   MOV   AL,0
                   CALL  GUS_SetVoicePan
                   CALL  GUS_PlayVoiceL

                   MOV   AL,2
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,161
                   CALL  GUS_SetVoicePeriod
                   MOV   BL,64
                   CALL  GUS_VolRampTo
                   MOV   EBX,0
                   CALL  GUS_SetSampleStart
                   MOV   EBX,2 * HERTZ50
                   CALL  GUS_SetSampleEnd
                   MOV   EBX,0
                   CALL  GUS_SetSampleLoop
                   MOV   AL,0
                   CALL  GUS_SetVoicePan
                   CALL  GUS_PlayVoiceL

; rite channel
                   MOV   AL,1
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,161
                   CALL  GUS_SetVoicePeriod
                   MOV   BL,64
                   CALL  GUS_VolRampTo
                   MOV   EBX,1024
                   CALL  GUS_SetSampleStart
                   MOV   EBX,1024 + 2 * HERTZ50
                   CALL  GUS_SetSampleEnd
                   MOV   EBX,1024
                   CALL  GUS_SetSampleLoop
                   MOV   AL,15
                   CALL  GUS_SetVoicePan
                   CALL  GUS_PlayVoiceL

                   MOV   AL,3
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   MOV   EBX,161
                   CALL  GUS_SetVoicePeriod
                   MOV   BL,64
                   CALL  GUS_VolRampTo
                   MOV   EBX,1024
                   CALL  GUS_SetSampleStart
                   MOV   EBX,1024 + 2 * HERTZ50
                   CALL  GUS_SetSampleEnd
                   MOV   EBX,1024
                   CALL  GUS_SetSampleLoop
                   MOV   AL,15
                   CALL  GUS_SetVoicePan
                   CALL  GUS_PlayVoiceL
; start playback
                   MOV   PlaybackON,TRUE
                   RET
GUS_PlaybackInit   ENDP

GUS_PlaybackDone   PROC  NEAR
                   MOV   PlaybackON,FALSE
                   MOV   AL,0
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice

                   MOV   AL,2
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice

                   MOV   AL,1
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice

                   MOV   AL,3
                   CALL  GUS_SelectVoice
                   CALL  GUS_StopVoice
                   RET
GUS_PlaybackDone   ENDP

comment #
 ESI - address of 16bit, stereo sample in memory
 ECX - number of samples
 EBX - GUS mem addr, in first 64K
#
;comment |
GUS_FastUpload     PROC  NEAR
                   MOV   DX,GUSP_Command    ; 103H
                   MOV   AL,cm_DRAMAddrHi
                   OUT   DX,AL
                   XOR   AL,AL
                   ADD   DX,2 ; GUSP_DataHigh = 105H
                   OUT   DX,AL ; first 64K
                   SUB   DX,2 ; GUSP_Command = 103H
                   MOV   AL,cm_DRAMAddrLo
                   OUT   DX,AL
                   INC   DX ; GUSP_DataLow = 104H
@@OutLp:           MOV   EAX,EBX
                   INC   EBX
                   OUT   DX,AX  ; lo 16 butes of offset
                   ADD   DX,3 ; 107H = GUSP_DRAMIO
                   MOV   AL,[ESI]
                   ADD   ESI,4
                   OUT   DX,AL
                   SUB   DX,3 ; 104H = GUSP_DataLow
                   LOOP  @@OutLp
                   RET
GUS_FastUpload     ENDP

