/*
 this file was changed or created for the DOS32 library for DJGPP on 5.5.1997
 new created files are copyright 1997 by C.Lageman, see docs.doc for details
*/
#include "xconio.h"
/* Set screen scan lines and load appropriate font.
   SCAN_LINES and FONT are as required by Int 10h functions 12h and 11h */
static void
set_scan_lines_and_font(int scan_lines, int font)
{

  /* Set 200/350/400 scan lines.  */
  SETSCANLINES(scan_lines);

  /* Scan lines setting only takes effect when video mode is set.  */
  SETVIDMODE;

  /* Load a ROM BIOS font (0x11: 8x14, 0x12: 8x8, 0x14: 8x16).  */
  asm("movb $0x11,%%ah\n\
       movb $0,%%bl\n\
       int  $0x10"
      :
      : "a" (font)
      : "eax","ebx","ecx","edx","ebp");

  /* Enable intensity bit.  */
  asm("movw $0x1003,%%ax\n\
       movb $0,%%bl\n\
       int  $0x10"
      :
      :
      : "eax","ebx");
}

/* Stretch a 8x8 font to the 8x10 character box.  This is required to
   use 80x40 mode on a VGA or 80x35 mode on an EGA, because the character
   box is 10 lines high, and the ROM BIOS doesn't have an appropriate font.
   So we create one from the 8x8 font by adding an extra blank line
   from each side.  */
static void
maybe_create_8x10_font(void)
{
  unsigned char *p,*src,*dest;
  unsigned long i, j;

  _dos32_regs regs;
      
  /* Get the pointer to the 8x8 font table.  */
  p = (unsigned char *)malloc(2560); /* 256 chars X 8x10 pixels */
  if (p == (unsigned char *)0)
        {
          errno = ENOMEM;
          font_seg = -1;
          return;
        }
  regs.ebx = 3<<8;
  regs.eax = 0x1130;
  __dos32_call_realmode_int(0x10, &regs,0);
  src  =__real2flat( ( (unsigned)regs.es  << 16 ) + (regs.ebp & 0xffffU) );
  dest =__dos32_dos_buffer;

  /* Now copy the font to our table, stretching it to 8x10. */
  for (i = 0; i < 256; i++)
        {
          /* Fill first extra scan line with zeroes. */
          *(char *)(dest++) = 0;

          for (j = 0; j < 8; j++) *(char *)(dest++) = *(char *)(src++);


          /* Fill last extra scan line with zeroes. */
          *(char *)(dest++) = 0;
        }

}

/* Load the 8x10 font we created into character generator RAM.  */
static void
load_8x10_font(void)
{
  _dos32_regs regs;

  maybe_create_8x10_font();         /* create if needed */
  regs.es = __dos32_dos_buffer_seg;    /* pass pointer to our font in ES:BP */
  regs.ebp = 0;
  regs.edx = 0;                    /* 1st char: ASCII 0 */
  regs.ecx = 256;                  /* 256 chars */
  regs.ebx = 10 <<8;               /* 10 points per char */
                                   /* block 0 */
  regs.eax = 0x1110;
  __dos32_call_realmode_int(0x10, &regs,0);
}

/* Set screen scan lines and load 8x10 font.
   SCAN_LINES is as required by Int 10h function 12h. */
static void
set_scan_lines_and_8x10_font(int scan_lines)
{

  SETSCANLINES(scan_lines);

  /* Set video mode, so that scan lines we set will take effect.  */
  asm("int  $0x10"
      :
      : "a" (txinfo.currmode == 7 ? 7 : 3)
      : "eax");

  /* Load our 8x10 font and enable intensity bit.  */
  load_8x10_font();
  asm("movw $0x1003,%%ax\n\
       movb $0,%%bl\n\
       int  $0x10"
      :
      :
      : "eax","ebx");
}

/* Switch to screen lines given by NLINES.  */
void
_set_screen_lines(int nlines)
{
  switch (nlines)
    {

      case 25:
          if (adapter_type)
            {
              /* Set 350 scan lines for EGA, 400 for VGA.  */
              SETSCANLINES(adapter_type > 1 ? 2 : 1);

              /* Load ROM BIOS font: 8x14 for EGA, 8x16 for VGA.  */
              asm("movb $0x11,%%ah\n\
                   movb $0,%%bl\n\
                   int  $0x10"
                  :
                  : "a" (adapter_type > 1 ? 0x14 : 0x11)
                  : "eax","ebx","ecx","edx","esi","edi","ebp");

              /* Enable intensity bit.  */
              asm("movw $0x1003,%%ax;movb $0,%%bl;int $0x10" : : :"eax","ebx");
            }

          /* Set video mode.  */
          SETVIDMODE;
          break;
      case 28:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_font(2, 0x11);
          break;
      case 35:      /* EGA or VGA */
          if (adapter_type)
            set_scan_lines_and_8x10_font(1);
          break;
      case 40:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_8x10_font(2);
          break;
      case 43:      /* EGA or VGA */
          if (adapter_type)
            set_scan_lines_and_font(1, 0x12);
          break;
      case 50:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_font(2, 0x12);
          break;
    }

  _gettextinfo(&txinfo);
}
