/*
 this file was changed or created for the DOS32 library for DJGPP on 5.5.1997
 new created files are copyright 1997 by C.Lageman, see docs.doc for details
*/
#include "xconio.h"
int
cputs(const char *s)
{
  int     row, col,c;
  const unsigned char *ss = (const unsigned char *)s;
  short *viaddr;
  short sa = ScreenAttrib << 8;
  ScreenGetCursor(&row, &col);
  viaddr = (short *)VIDADDR(row,col);
  /* 
   * Instead of just calling putch; we do everything by hand here,
   * This is much faster. We don't move the cursor after each character,
   * only after the whole string is written, because ScreenSetCursor
   * needs to long because of switching to real mode needed with djgpp. 
   * You won't recognize the difference.
   */
  while ((c = *ss++))
  {
    /*  first, handle the character */
    if (c == '\n')
    {
      row++;
      viaddr += txinfo.screenwidth;
    }
    else if (c == '\r')
    {
      col = txinfo.winleft - 1;
      viaddr = (short *)VIDADDR(row,col);
    }
    else if (c == '\b')
    {
      if (col > txinfo.winleft-1) 
      {
	col--;
	viaddr--;
      }
      else if (row > txinfo.wintop -1)
      {
	/* 
	 * Turbo-C ignores this case. We want to be able to
	 * edit strings with backspace in gets after
	 * a linefeed, so we are smarter
	 */
	row--;
	col = txinfo.winright-1;
	viaddr = (short *)VIDADDR(row,col);
      }
    }
    else if (c == 0x07)
      bell();
    else {
      *viaddr = c | sa;
      viaddr++;
      col++;
    }
      
    /* now, readjust the window     */
      
    if (col >= txinfo.winright) {
      col = txinfo.winleft - 1;
      row++;
      viaddr = (short *)VIDADDR(row,col);
    }
      
    if (row >= txinfo.winbottom) {
      if (_wscroll)
      {
	ScreenSetCursor(txinfo.wintop-1,0); /* goto first line in window */
	delline();		/* and delete it */
      }
      row--;
      viaddr -= txinfo.screenwidth;
    }
  }
  
  ScreenSetCursor(row, col);
  txinfo.cury = row - txinfo.wintop + 2;
  txinfo.curx = col - txinfo.winleft + 2;
  return(*(--ss));
}
