/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/*
 * This is file GETDOS_V.C
 *
 * Copyright (c) 1994,95 Eli Zaretskii <eliz@is.elta.co.il>
 *
 * This software may be used freely so long as this copyright notice is
 * left intact.  There is no warranty on this software.
 *
 */


#include <dos.h>

/* Return OS version number, either true or ``simulated'' one.
   Global variables _OSMAJOR and _OSMINOR are ALWAYS set to whatever
   INT 21h/AX=30h returns.  Global _OS_FLAVOR is set to a string
   which identifies the OEM of DOS.
 */

/* From Ralph Brown's interrupt list, v.45.
   Note: some OEMs, like Novell NDOS 7, Compaq DOS 3.31 and possibly
         others return 0 OEM code, like IBM PC-DOS.  There is nothing
         I can do to overcome this.
*/
static struct _oem_info {
  unsigned char   oem_num;
  const    char * oem_name;
} dos_flavors[] = {
    {0,    "IBM PC-DOS"},
    {1,    "Compaq DOS"},
    {2,    "Microsoft DOS"},
    {4,    "AT&T DOS"},
    {5,    "Zenith DOS"},
    {6,    "Hewlett-Packard DOS"},
    {7,    "Groupe Bull DOS"},
    {0xd,  "Packard-Bell DOS"},
    {0x16, "DEC DOS"},
    {0x23, "Olivetti DOS"},
    {0x28, "Texas Instruments DOS"},
    {0x29, "Toshiba DOS"},
    {0x33, "Novell Win3 device ID"},
    {0x34, "MS Multimedia Win3 device ID"},
    {0x35, "MS Multimedia Win3 device ID"},
    {0x4d, "Hewlett-Packard DOS"},
    {0x5e, "RxDOS"},
    {0x66, "PTS-DOS"},
    {0x99, "GenSoft Embedded DOS"},
    {0xee, "DR-DOS"},
    {0xef, "Novell DOS"},
    {0xff, "Microsoft MS-DOS"},
    {0,    (char *)0}
};


unsigned short
_get_dos_version(int true_version)
{
  unsigned char     oem_number,ah,al,bh,bl;
  struct _oem_info *p = dos_flavors;

  /* If already have the info, return what we know. */
  if (_osmajor && !true_version)
    return (_osmajor << 8) + _osminor;
  asm("movw $0x3000,%%ax\n\
       int  $0x21\n\
       movb %%al,%b0\n\
       movb %%bh,%b2\n\
       movb %%ah,%b1"
       : "=qm" (al), "=qm" (ah), "=qm" (bh)
       :
       : "eax","ebx","ecx");
  _osminor = ah;
  _osmajor = al ? al : 1;     /* DOS 1.x returns 0 */

  oem_number = bh;
  for ( ; p->oem_name && p->oem_num != oem_number; ++p);

  if (p->oem_name)
    _os_flavor = p->oem_name;
  else
    _os_flavor = "??Unknown??";

  if (true_version)
    {
               /* in case 213306 isn't supported, BX stays 0 */
      asm("movw $0x3306,%%ax\n\
           xorl %%ebx,%%ebx\n\
           int  $0x21\n\
           lahf\n\
           movb %%bh,%b1\n\
           movb %%al,%b0\n\
           movb %%bl,%b2\n\
           movb %%ah,%b3"
          : "=qm" (al), "=qm" (bh), "=qm" (bl), "=qm" (ah)
          :
          : "eax","ebx","edx");

      /* Sanity checks suggested by Ralph Brown's Interrupt list. */
      if ( !(ah & 1) &&
           al != 0xff &&
           bh < 100 &&
           bl >= 5)
        return (bl << 8) + bh;
    }

  return (_osmajor << 8) + _osminor;
}
