/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <dos32api.h>
#include <dir.h>
#include <libc/dosio.h>


int
findnext(struct ffblk *ffblk)
{
  _dos32_regs r;

  if (ffblk == 0)
  {
    errno = EACCES;
    return -1;
  }

  if(_USE_LFN)
  {
    /* si = 1 indicates DOS style dates, 0 means Win32 type dates.
       DOS style dates are broken in some Win95 betas, build for either.
       Release works with DOS date, it's faster, so use it. */
    #define USEDOSDATE 1
    #if USEDOSDATE == 1
      #define _Win32_to_DOS (long)
    #else
      extern long _Win32_to_DOS(long long WinTime);
    #endif

    r.eax = 0x714f;
    r.ebx = ffblk->lfn_handle;
    if(!r.ebx)
    {
      errno = ENMFILE;
      return 1;
    }
    r.edi = 0;
    r.es  = __dos32_dos_buffer_seg;
    r.esi = USEDOSDATE;

    __dos32_call_realmode_int(0x21, &r, 0);
    if (!(r.flags & 1))
    {
      struct ffblklfn ffblk32;
      /* Recover results */
      memcpy(&ffblk32,__dos32_dos_buffer, sizeof(struct ffblklfn));

      ffblk->ff_attrib = (char)ffblk32.fd_attrib;
      *(long *)&ffblk->ff_ftime = _Win32_to_DOS(ffblk32.fd_mtime);
      ffblk->ff_fsize = ffblk32.fd_size;
      strcpy(ffblk->ff_name, ffblk32.fd_longname);
      *(long *)&ffblk->lfn_ctime = _Win32_to_DOS(ffblk32.fd_ctime);
      *(long *)&ffblk->lfn_atime = _Win32_to_DOS(ffblk32.fd_atime);

      return 0;
    }
    errno = __doserr_to_errno(r.eax);
    if (errno == ENMFILE)         /* call FindClose */
    {
      asm("movw $0x71a1,%%ax\n\
           int  $0x21\n\
           sbbl %%ebx,%%ebx"
           : "=a" (r.eax), "=b" (r.flags)
           : "b" (ffblk->lfn_handle)
           : "eax","ebx","cc");
      ffblk->lfn_handle = 0;
      if(r.flags & 1)
      {
        errno = __doserr_to_errno(r.eax);
        return -1;
      }
      return 1;
    }
    return -1;
  }
  else
  {
    #define _sizeof_dos_ffblk 44
    /* The 43 character ff block must be put to the DTA, make the call, then
       recover the ff block. */
    memcpy(__DOS32_DTA, ffblk, _sizeof_dos_ffblk);
    asm("movb $0x4f,%%ah\n\
         int  $0x21\n\
         sbbl %%ebx,%%ebx"
         : "=a" (r.eax), "=b" (r.flags)
         :
         : "eax","ebx","cc");
    if(r.flags & 1)
    {
      errno = __doserr_to_errno(r.eax);
      return -1;
    }
    /* Recover results */
    memcpy(ffblk,__DOS32_DTA, _sizeof_dos_ffblk);
    return 0;
  }
}
