/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdio.h>
#include <unistd.h>
#include <libc/file.h>
#include <fcntl.h>
#include <libc/dosio.h>

long
ftell(FILE *f)
{
  long tres;
  int adjust;
  int idx;

  if (f->_cnt < 0)
    f->_cnt = 0;
  if (f->_flag&_IOREAD)
  {
    adjust = - f->_cnt;
    if (__file_handle_modes[f->_file] & O_TEXT)	/* if a text file */
      for (idx=-adjust-1; idx>=0; idx--) /* for every char in buf */
	if (f->_ptr[idx] == '\n') /* if it's LF */
	  adjust--;		/* there was a CR also */
  }
  else if (f->_flag&(_IOWRT|_IORW))
  {
    adjust = 0;
    if (f->_flag&_IOWRT && f->_base && (f->_flag&_IONBF)==0)
    {
      adjust = f->_ptr - f->_base;
      if (__file_handle_modes[f->_file] & O_TEXT)
	for (idx=0; idx<adjust; idx++)
	  if (f->_base[idx] == '\n')
	    adjust++;
    }
  }
  else
    return -1;
  tres = lseek(fileno(f), 0L, 1);
  if (tres<0)
    return tres;
  tres += adjust;
  return tres;
}
