/*
** KEY.C   Keyboard Handler Demonstration Code
**
** Coded by : James P. Ketrenos
**
** 	You have permission to use this if you want.  You are not required
** 	to use it.  However, if it should cause harm to you, your computer,
**  your dog, or anyone/thing you know/have/own, I am not responsible.
**
**  By using this, or any file in this archive, you acknowledge that
**  fact and accept it.
**
** If you make money on a program that uses these routines, you, by using
** these routines, are required to contact me (see LL_KBD.DOC for info
** on contacting me) to work something out.  I'm not a hardnose, I just
** would like to know what my routines have been used for and such.
*/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "LL_KBD.H"
#include "ll_stat.h"

#define VER_ID  "0003.512"

printtype(char Key)
{
char    *Addr;
char    *Scrn;
    switch (Key)
    {
    case 0xE0:
            for (Addr="EXTENDED   ",
                Scrn=(char *)0x000b8000;
                *Addr;
                Addr++, Scrn+=2)
            {
                Scrn[0]=*Addr;
                Scrn[1]=0x0F;
            }
            break;
    case 0xF0:
            for (Addr="CONTROL    ",
                Scrn=(char *)0x000b8000;
                *Addr;
                Addr++, Scrn+=2)
            {
                Scrn[0]=*Addr;
                Scrn[1]=0x0F;
            }
            break;
    case 0x00:
            for (Addr="NUL        ",
            	Scrn=(char *)0x000B8000;
                *Addr;
                Addr++, Scrn+=2)
            {
                Scrn[0]=*Addr;
                Scrn[1]=0x0F;
            }
            break;
    }
}

int main()
{
char    Key=0;
int    	tmp=0;
char    *Scrn;
char    *Addr;

    status(ST_RESET,"KEY.LOG");
    status(ST_ECHO,"");
    status(ST_SHOW,"KEY (R) Logical Keyboard Routines v%s",VER_ID);
    status(ST_SHOW,"Copyright (C) 1994 by Logics Inc., All rights reserved.");
	status(ST_ECHO,"");
    status(ST_ECHO,"See KEY.NFO for important information.");
    status(ST_SHOW,"");

    status(ST_SHOW,"Initializing Keyboard Handler . . .");
    kbdInit();

    printf("\nBuffer demonstration:  Type 5 keys\n");
        tmp=kbdKeyHit();
        while (kbdKeyHit()<5)
        {
            if (kbdKeyHit()!=tmp)
                printf("%d",tmp=kbdKeyHit()); fflush(stdout);
        }
        printf("%d:",tmp=kbdKeyHit()); fflush(stdout);
        while (kbdKeyHit())
            printf("%c",kbdGetKey());
        printf("\n");

    printf("\nRefilling buffer with \"QWERT\", then flushing:\n");
        for (Addr="QWERT"; *Addr; Addr++)
        {
            printf("%c",*Addr); fflush(stdout);
            kbdPutKey(*Addr);
        }
        printf(":"); fflush(stdout);
        while (kbdKeyHit())
            printf("%c",kbdGetKey());
        printf("\n");

    printf("********************************** *****  ***   ***   **    *\n");
    printf("Multi-keypress demonstration:\n");
    printf("    This demonstrates the ability to track multiple keys being\n");
    printf("    pressed at the same time.  Occasionally a key might stick\n");
    printf("    on the top of the screen.  This occurs when the keyboard\n");
    printf("    ISR does not receive the keyrelease code from the I/O port.\n\n");
    printf("Press several keys at once . . .\n\n");
    printf("NOTE:  LEFT_SHIFT-ALT-CTRL will go to next section.\n");
        kbdSetMode(ABSOLUTE);
        Scrn=(char *)0x000B8000;
        while (!(kbdKeyIs(_L_SHIFT) &&
                (kbdKeyIs(_L_ALT) || kbdKeyIs(_R_ALT)) &&
                (kbdKeyIs(_L_CTRL) || kbdKeyIs(_R_CTRL)))
                )
        {
            for (tmp=0; tmp<=0x66; tmp++)
            {
                Scrn[tmp*2]=tmp;
                Scrn[tmp*2+1]=kbdFLAGS[tmp];
                kbdKeyClr(tmp);
            }
        }

    printf("********************************** *****  ***   ***   **    *\n");
    printf("You're ordered key strikes were [up to 256 of 'em]:\n");
    while (kbdKeyHit())
    {
        printf("%c",kbdGetKey());
        fflush(stdout);
    }

    printf("\n");
    printf("********************************** *****  ***   ***   **    *\n\n"); Key=0;
    printf("The four buffer modes will now be demonstrated:\n");
    printf("NOTE:   ESC will cancel current mode and continue to next mode.\n\n");
    printf("Mode #0:    Absolute Keystroke Mode\n");
    printf("Invoked by: kbdSetMode(ABSOLUTE)\n");
    printf("* System keys buffered?         YES\n");
    printf("* System+Keystrokes converted?  NO\n");
        kbdSetMode(ABSOLUTE);
        kbdKeyClr(_ESC);
        while (!kbdKeyWas(_ESC))
        {
            while (!kbdKeyHit());
            kbdSetNumLight(rand());
            kbdSetCapLight(rand());
            kbdSetScrlLight(rand());
            printf("%c",((Key=kbdGetKey())==27) ? '\n' : Key); fflush(stdout);
            if ((kbdKeyIs(_DEL) || kbdKeyIs(_C_DEL)) &&
                (kbdKeyIs(_L_ALT) || kbdKeyIs(_R_ALT)) &&
                (kbdKeyIs(_L_CTRL) || kbdKeyIs(_R_CTRL))
               )
                printf("\rHa!  You thought you could reboot!!!!!!\n");
            else
                printtype(Key);
        }
    printf("\n********************************** *****  ***   ***   **    *\n");
    Key=0;
    printf("Mode #1:    System Key Conversion Mode\n");
    printf("Invoked by: kbdSetMode(CONVERT)\n");
    printf("* System keys buffered?         YES\n");
    printf("* System+Keystrokes converted?  YES\n");
        kbdSetMode(CONVERT);
        kbdKeyClr(_ESC);
        while (!kbdKeyWas(_ESC))
        {
            while (!kbdKeyHit());
            kbdSetNumLight(rand());
            kbdSetCapLight(rand());
            kbdSetScrlLight(rand());
            printf("%c",((Key=kbdGetKey())==27) ? '\n' : Key); fflush(stdout);
            printtype(Key);
        }
    printf("\n********************************** *****  ***   ***   **    *\n");
    Key=0;
    printf("Mode #2:    No System Key Buffering Mode\n");
    printf("Invoked by: kbdSetMode(NOSYSTEM)\n");
    printf("* System keys buffered?         NO\n");
    printf("* System+Keystrokes converted?  NO\n");
        kbdSetMode(NOSYSTEM);
        kbdKeyClr(_ESC);
        while (!kbdKeyWas(_ESC))
        {
            while (!kbdKeyHit());
            kbdSetNumLight(rand());
            kbdSetCapLight(rand());
            kbdSetScrlLight(rand());
            printf("%c",((Key=kbdGetKey())==27) ? '\n' : Key); fflush(stdout);
            printtype(Key);
        }
    printf("\n********************************** *****  ***   ***   **    *\n");
    Key=0;
    printf("Mode #3:    No System Key Buffering, AND System Key Conversion\n");
    printf("Invoked by: kbdSetMode(CONVERT | NOSYSTEM)\n");
    printf("* System keys buffered?         NO\n");
    printf("* System+Keystrokes converted?  YES\n");
        kbdSetMode(CONVERT | NOSYSTEM);
        kbdKeyClr(_ESC);
        while (!kbdKeyWas(_ESC))
        {
            while (!kbdKeyHit());
            kbdSetNumLight(rand());
            kbdSetCapLight(rand());
            kbdSetScrlLight(rand());
            printf("%c",((Key=kbdGetKey())==27) ? '\n' : Key); fflush(stdout);
            printtype(Key);
        }

    printf("\n********************************** *****  ***   ***   **    *\n");
    status(ST_SHOW,"Resetting Keyboard Handler . . .");
    kbdReset();

    printf("\nFinished.  Please read LL_KBD.DOC for important information about\n");
    printf("using this library, and also about the  keystroke  mapping  in  use\n");
    printf("with these routines.\n\n");
    printf("Copyright (C) 1994 by Logics Inc.,  All rights reserved.\n");
    return  0;
}
