
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <socom\gravis.h>
#include <socom\mod.h>
#include <socom\dsm.h>
#include <socom\wav.h>

void  error( int errnum );

void  main( int argc, char** argv )
{
   AudioDevice*   audio = new Gravis;
   Module*        aMod;
   Sample*        s1 = new WAV( "b2.wav" );
   Sample*        s2 = new WAV( "b1.wav" );

   int   looping = 1;
   int   length;
   int   value;
   int   volume;
   int   voice1, voice2;

   length = strlen( argv[1] );

   if ( strcmpi( &argv[1][length-3], "mod" ) == 0 )
   {
      aMod = new MOD( argv[1] );
   }
   else if ( strcmpi( &argv[1][length-3], "dsm" ) == 0 )
   {
      aMod = new DSM( argv[1] );
   }
   else
   {
      aMod = 0;
   }

   if ( aMod != 0 )
   {
      if (( value = aMod->LoadModule()) == SOC_OK )
      {
         if ( audio->LoadModule( aMod, 2 ) == SOC_OK )
         {
            printf( "Use +/- to control master volume\n\n" );

            audio->Play( aMod );

            volume = aMod->GetMasterVolume();

            printf( "Sample 1 voice = %d\n", voice1 = audio->AllocVoice() );
            printf( "Sample 2 voice = %d\n", voice2 = audio->AllocVoice() );

            audio->LoadSample( s1 );
            audio->LoadSample( s2 );

            printf( "Samples ready to play on '1' and '2'\n\n" );

            while ( looping )
            {
               char  c;

               cprintf( "MVOL: %03d\r", volume );

               switch ( c = getch() )
               {
                  case  0x1B:
                     looping = 0;
                     break;
                  case  0x2B:
                     volume++;
                     break;
                  case  0x2D:
                     volume--;
                     break;
                  case  '1':
                     audio->PlaySample( voice1, 12, s1 );
                     break;
                  case  '2':
                     audio->PlaySample( voice2, 3, s2 );
                     break;
                  case  'q':
                     audio->Stop( aMod );
                     break;
                  case  's':
                     audio->Play( aMod );
                     break;
                  default:
                     break;
               }

               if ( volume < 0 )
               {
                  volume = 0;
               }
               else if ( volume > 255 )
               {
                  volume = 255;
               }

               aMod->SetMasterVolume( volume );
            }

            audio->Stop( aMod );

            audio->UnloadModule( aMod );
         }
         else
         {
            error( value );
         }
      }
      else
      {
         error( value );
      }
   }

   delete aMod;
   delete audio;
}

//
//
// Process an error message
//
//

void  error( int errnum )
{
   char* text;

   switch ( errnum )
   {
      case  SOC_NO_MEMORY:
         text = "Not enough system memory";
         break;
      case  SOC_NO_CARD:
         text = "No sound card found";
         break;
      case  SOC_NO_FREE_VOICES:
         text = "No free voices for digital playback";
         break;
      case  SOC_NO_DRAM:
         text = "Not enough on-board memory for DRAM base cards";
         break;
      case  SOC_CORRUPT_DRAM:
         text = "On-board memory is corrupt";
         break;
      case  SOC_TOO_MANY_VOICES:
         text = "Too many voices for audio device";
         break;
      case  SOC_NO_ENVVAR:
         text = "No sound card environment variable";
         break;
      case  SOC_NO_FILE:
         text = "File not found";
         break;
      case  SOC_SEEK_FAULT:
         text = "Error during file seek";
         break;
      case  SOC_READ_FAULT:
         text = "Error reading file";
         break;
      case  SOC_UNKNOWN_MOD:
         text = "Unknown module format";
         break;
      case  SOC_NO_WAV:
         text = "Not a WAV file";
         break;
      case  SOC_NO_MONO_WAV:
         text = "Not a mono WAV file";
         break;
      default:
         text = "Unknown error";
         break;
   }

   printf( "%s\n", text );
}

