
#ifndef  __SOCOM_H__
#define  __SOCOM_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Basic header file                                                         
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

typedef unsigned char   ubyte;
typedef char            byte;
typedef unsigned short  uword;
typedef short           word;
typedef unsigned long   ulong;
typedef int             bool;
typedef unsigned int    uint;

typedef void (*PFV)( void );
typedef void __interrupt __far (*PVI)( void );

//Ŀ
//                                                                           
// Enumerated types                                                          
//                                                                           
//

enum Boolean   {
   false = 0,
   true
};

enum SOCErrors {
   SOC_OK,                    // all is OK
   SOC_NO_MEMORY,             // not enough system RAM available
   SOC_NO_CARD,               // specified sound card does not exist
   SOC_NO_FREE_VOICES,        // no more available voices for digital playback
   SOC_NO_DRAM,               // not enough DRAM available for cards with DRAM
   SOC_CORRUPT_DRAM,          // on-board DRAM memory structure is corrupt
   SOC_TOO_MANY_VOICES,       // too many voices to mix for device driver
   SOC_NO_ENVVAR,             // no sound card environment variable
   SOC_NO_FILE,               // couldn't open file
   SOC_SEEK_FAULT,            // error during file seek
   SOC_READ_FAULT,            // read file error
   SOC_UNKNOWN_MOD,           // unrecognized module type
   SOC_NO_WAV,                // not a WAV file
   SOC_NO_MONO_WAV            // not a mono WAV file
};

enum SOCModuleTypes {
   SOC_MOD,
   SOC_DSM
};

// sample bit definitions
#define  SOC_16BIT   0x04
#define  SOC_LOOP    0x08

//Ŀ
//                                                                           
// Macros                                                                    
//                                                                           
//

void  scDisable( void );         // disable interrupts
void  scEnable( void );          // restore interrupt state
ulong scFlipWord( uword temp );  // flip a word and multiply by 2

#pragma aux scDisable  = "pushfd", "cli";
#pragma aux scEnable   = "popfd";
#pragma aux scFlipWord = "xchg ah,al", "add eax,eax" parm [eax];

#endif   // __SOCOM_H__
