
#ifndef  __MOD_H__
#define  __MOD_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// MOD - Header file                                                         
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\module.h>

//Ŀ
//                                                                           
// Class specification                                                       
//                                                                           
//

class MOD : public Module
{

 public:

   // Constructor
   MOD( char* fileName );

   // Copy constructor
   MOD( const MOD& aMod );

   // Destructor
   ~MOD( void );

   // Assignment operator
   MOD& operator =( const MOD& aMod );

   // Load module into memory
   int   LoadModule( void );

 private:

   // Find a period's DSM compatible note number
   ubyte FindNote( int period );

   // Read patterns into memory and convert notes to DSM notes
   int   ReadPatterns( void );

   // Read sample information structures
   int   ReadSampleInfo( void );

};

#endif   // __MOD_H__
