
#ifndef  __CHANNEL_H__
#define  __CHANNEL_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Channel - Header file                                                     
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\socom.h>
#include <socom\sample.h>

//Ŀ
//                                                                           
// Class specification                                                       
//                                                                           
//

class Channel
{

 public:

   // Constructor
   Channel( void );

   // Destructor
   ~Channel( void );

   // Clear channel
   void  Clear( void );

   // Parse line effects (occur once every play line)
   void  DoLineSfx( void );

   // Parse real effects (occur once every play tick)
   void  DoRealSfx( void );

   // Parse a new note
   void  ParseNote( ubyte* pat );

 private:

   ulong myStartPos;          // start offset within sample (sample offset)
   int   myOrigPeriod;        // original period
   int   myPlayPeriod;        // playing period
   int   myWantPeriod;        // desired period in tone slides
   int   myOldPeriod;         // old period
   int   myFineTune60;        // finetune value * 60
   ubyte myRetrig;            // retrig counter
   ubyte myPanPos;            // channel pan position
   ubyte mySampleNum;         // active sample number
   ubyte myEffect;            // effect number
   ubyte myEffectData;        // effect data byte
   ubyte myKick;              // kick channel flag
   ubyte myWaveControl;       // wave control bits
   ubyte myVibratoDepth;      // vibrato depth
   ubyte myVibratoSpeed;      // vibrato speed
   ubyte myTremoloSpeed;      // tremolo speed
   ubyte myTremoloDepth;      // tremolo depth
   ubyte myGlissando;         // glissando tone slide flag
   ubyte myToneDirec;         // tone slide direction
   ubyte myToneSpeed;         // tone slide speed
   ubyte myWantNote;          // desired note in glissando
   ubyte myNoteNum;           // active note number
   ubyte myLoNibble;          // effect data low nibble
   ubyte myHiNibble;          // effect data high nibble
   char  myVibratoPos;        // vibrato position (signed)
   char  myTremoloPos;        // tremolo position (signed)
   char  myVolume;            // original volume
   char  myPlayVolume;        // current playing volume
   char  myOldVolume;         // old volume

   static Sample* mySamples;
   static int     myBpm;
   static int     myModType;
   static bool    myBpmChange;

   // Handle arpeggio
   void  Arpeggio( void );

   // Volume slide up to default sample volume
   void  DefaultVolumeSlideUp( void );

   // Fine portamento down (once per line)
   void  FinePortamentoDown( void );

   // Fine portamento down (once per line) using 5 octaves
   void  FinePortamentoDown5( void );

   // Fine portamento up (once per line)
   void  FinePortamentoUp( void );

   // Fine portamento up (once per line) using 5 octaves
   void  FinePortamentoUp5( void );

   // Fine volume slide down (once per line)
   void  FineVolumeSlideDown( void );

   // Fine volume slide up (once per line)
   void  FineVolumeSlideUp( void );

   // Glissando control
   void  Glissando( void );

   // Slide master volume down
   void  MasterVolumeDown( void );

   // Slide master volume up
   void  MasterVolumeUp( void );

   // Cut off note when tick counter passes effect data nibble
   void  NoteCut( void );

   // Delay start of sample until tick counter = effect data nibble             
   void  NoteDelay( void );

   // Panning control
   void  PanControl( void );

   // Handle pattern break
   void  PatternBreak( void );

   // Handle pattern delay
   void  PatternDelay( void );

   // Handle pattern loop
   void  PatternLoop( void );

   // Handle portamento down using 3 octaves
   void  PortamentoDown( void );

   // Portamento down using 5 octaves
   void  PortamentoDown5( void );

   // Handle portamento up using 3 octaves
   void  PortamentoUp( void );

   // Portamento up using 5 octaves
   void  PortamentoUp5( void );

   // Handle position jump
   void  PositionJump( void );

   // Retrig note after a specified number of ticks
   void  RetrigNote( void );

   // Handle sample offset
   void  SampleOffset( void );

   // Set finetune for current sample
   void  SetFineTune( void );

   // Set master volume
   void  SetMasterVolume( void );

   // Handle speed and BPM changes
   void  SetSpeed( void );

   // Set new tremolo waveform type
   void  SetTremoloWaveForm( void );

   // Set new vibrato waveform type
   void  SetVibratoWaveForm( void );

   // Directly set the volume of current sample
   void  SetVolume( void );

   // Set volume and sample offset
   void  SetVolumeSampleOffset( void );

   // Simulate a 3D effect
   void  Simulate3D( void );

   // Handle tone portamento
   void  TonePortamento( bool doInit );

   // Handle tremolo
   void  Tremolo( void );

   // Handle vibrato
   void  Vibrato( bool doInit );

   // Handle volume slide
   void  VolumeSlide( void );

   friend class Gravis;
   friend class Module;
};

#endif   // __CHANNEL_H__
