#include <stdlib.h>
#include <stdio.h>
#include "..\include\ilfs.h"

void main(void)
{
        unsigned long error, k, index;
        FILE *fp;

        ilfs(ilfs_show_banner);
        error=ilfs(ilfs_open_lib, "test.lfs");
        switch(error)
        {
                case 0:
                        printf("Successfully opened test.lfs\n");
                        break;
                case 1:
                        printf("Unable to open library file.\n");
                        break;
                case 2:
                        printf("Not an valid ILFS file.\n");
                        break;
                case 3:
                        printf("Not enough memory for the ILF FAT.\n");
                        break;
        }
        if(error==NULL)
        {
                printf("\nFiles in this LFS are -\n");
                index=0;
                do
                {
                        k=ilfs(100, index);  /* leftover debug option */
                        if(k!=NULL)
                                printf("%s\n", k);
                        index++;
                }while(k!=NULL);
                printf("\n%u files in the library.\n", index-1);

                fp=fopen("av.exe", "rb");
                if(fp!=NULL)
                {
                        printf("\nSuccessfully opened AV.EXE\n\n");

                        fseek(fp, 0L, SEEK_END);
                        printf("                File size is : %#08lx\n", ftell(fp));
                        fseek(fp, 0x100L, SEEK_SET);
                        printf("     File SEEK_SET offset is : %#08lx\n", ftell(fp));
                        fseek(fp, -1L, SEEK_CUR);
                        printf("  File SEEK_CUR -1 offset is : %#08lx\n", ftell(fp));
                        fseek(fp, 2L, SEEK_CUR);
                        printf("  File SEEK_CUR +2 offset is : %#08lx\n", ftell(fp));

                        fclose(fp);

                        printf("\nAttempting to disable the ILFS\n");
                        ilfs(ilfs_disable_lib);

                        if((fp=fopen(".\\Av.ExE", "rb"))==NULL)
                        {
                                printf("ILFS was disabled successfully.\n");
                                fclose(fp);
                        }
                        else
                                printf("ILFS was NOT disabled successfully.\n");

                        k=ilfs(ilfs_enable_lib);
                        if(k==NULL)
                                printf("\nSuccessful re-enabling of the ILFS.\n");
                }
                else
                        printf("Error opening ilfs AV.exe file.\n");

        }
        ilfs(ilfs_close_lib);
        ilfs(ilfs_uninstall);
}