#ifdef __cplusplus
#define extern "C"{
#else
#define extern
#endif

#pragma pack(1);

typedef struct
{
        char    name[13];
        unsigned long   size;
        unsigned long   offset;
        unsigned long   pointer;
        unsigned char   open_file;
} LFS;

typedef struct
{
        unsigned long offset;
        unsigned long size;
        unsigned char name_len;
} ILFS;


extern  unsigned short ilfs_init(unsigned char *ilfs_name);
        #pragma aux ilfs_init "_*" parm caller [] modify [];
extern  unsigned short ilfs_exit(void);
        #pragma aux ilfs_exit "_*" parm caller [] modify [];

#define ilfs_show_banner        0
#define ilfs_open_lib           1
#define ilfs_close_lib          2
#define ilfs_disable_lib        3
#define ilfs_enable_lib         4
#define ilfs_get_address_lib    5
#define ilfs_set_address_lib    6
#define ilfs_uninstall          10

unsigned long ilfs(unsigned short ilfs_cmd, ...);
        #pragma aux ilfs "_*" parm caller [] modify [] value [eax];

#ifdef __cplusplus
};
#endif