{$N+}

type
    RGBr = array[0..2] of byte;

var T : Text;
    F : File;
    PAL : array[0..255] of RGBr;
    is, os : string;
    gamma : array[0..2] of single;

    colptr, nextptr : byte;
    n : RGBr;


procedure MakePalette( i : byte; c : RGBr );
var
  oc : RGBr;
  dr : array[0..2] of single;
  di, s : single;
  k,j : integer;
begin
  if i=0 then
    PAL[0] := c
  else begin
    oc := PAL[colptr];
    di := i-colptr;
    for j := 0 to 2 do dr[j] := (c[j] - oc[j])/di;
    for k := colptr to i do for j := 0 to 2 do begin
      s := (oc[j] + dr[j]*(k-colptr))/63;
      if s > 0 then s := exp(gamma[j]*ln(s)) else s := 0;
      PAL[k,j] := round( s*63 );
    end;
  end;
  PAL[i] := c;
  colptr := i;
end;


begin

  if ParamCount = 1 then
     is := ParamStr(1)
  else begin
     write('File name (no extension): '); readln(is);
  end;

  os := is + '.bin';
  is := is + '.def';


  assign( T, is ); reset( T );

  FillChar( PAL, sizeof(PAL), 0 );

  readln( T, gamma[0], gamma[1], gamma[2] );

  colptr := 0;
  while not eof(T) do begin
    readln( T, nextptr, n[0], n[1], n[2] );
    MakePalette( nextptr, n );
  end;

  close(T);

  assign( F, os ); rewrite( F,1 );
  blockwrite( F, PAL, sizeof(PAL) );
  close(F);

end.

